set quoted_identifier on
GO

/****** Object:  Table dbo.dict    Script Date: 19.12.99 18:13:27 ******/
if exists (select * from sysobjects where id = object_id('dbo.dict') and sysstat & 0xf = 3)
	drop table dbo.dict
GO

/****** Object:  Table dbo.robots    Script Date: 19.12.99 18:13:27 ******/
if exists (select * from sysobjects where id = object_id('dbo.robots') and sysstat & 0xf = 3)
	drop table dbo.robots
GO

/****** Object:  Table dbo.stopword    Script Date: 19.12.99 18:13:27 ******/
if exists (select * from sysobjects where id = object_id('dbo.stopword') and sysstat & 0xf = 3)
	drop table dbo.stopword
GO

/****** Object:  Table dbo.url    Script Date: 19.12.99 18:13:27 ******/
if exists (select * from sysobjects where id = object_id('dbo.url') and sysstat & 0xf = 3)
	drop table dbo.url
GO

/****** Object:  Table dbo.dict    Script Date: 19.12.99 18:13:27 ******/
CREATE TABLE dbo.dict (
	url_id int NOT NULL ,
	word char (32) NOT NULL ,
	intag int NOT NULL 
)
GO

 CREATE  INDEX dict_url_id ON dbo.dict(url_id)
GO

 CREATE  INDEX dict_word_url_id ON dbo.dict(word, url_id)
GO

/****** Object:  Table dbo.robots    Script Date: 19.12.99 18:13:27 ******/
CREATE TABLE dbo.robots (
	hostinfo char (127) NOT NULL ,
	path char (127) NOT NULL 
)
GO

/****** Object:  Table dbo.stopword    Script Date: 19.12.99 18:13:27 ******/
CREATE TABLE dbo.stopword (
	word char (32) NOT NULL, 
	lang char (2)  NOT NULL 
)
GO

 CREATE  UNIQUE  INDEX stopword_word ON dbo.stopword(word,lang)
GO

/****** Object:  Table dbo.url    Script Date: 19.12.99 18:13:27 ******/
CREATE TABLE dbo.url (
	rec_id numeric IDENTITY NOT NULL ,
	status int NOT NULL ,
	url char (128) NOT NULL ,
	content_type char (48) NULL ,
	title char (128) NULL ,
	txt char (255) NULL ,
	docsize int NULL ,
	last_index_time int NOT NULL ,
	next_index_time int NOT NULL ,
	last_mod_time int NOT NULL ,
	referrer int NULL ,
	tag char (10) NULL ,
	hops int NULL ,
	category char (10) NULL ,
	keywords char (255) NULL ,
	description char (100) NULL ,
	crc32 int NULL ,
	lang char(2) NULL ,
	CONSTRAINT PK__url__rec_id__3197676B PRIMARY KEY  CLUSTERED 
	(
		rec_id
	),
	CONSTRAINT UQ_url_1__10 UNIQUE  NONCLUSTERED 
	(
		url
	)
)
GO

 CREATE  INDEX url_crc ON dbo.url(crc32)
GO

 CREATE  UNIQUE  INDEX url_url ON dbo.url(url)
GO


