/**
*** Program jdbcMysqliPStmt.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;
import twz1.jdbc.mysql.jdbcMysqlMutex;
import java.sql.*;
import java.util.StringTokenizer;
import java.util.Vector;
import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;

public final class jdbcMysqlPStmt extends jdbcMysqlStmt 
       implements PreparedStatement 
{
Vector fixedStatement;
Vector parameters;
int fsize;
int psize;
int pCommandValue;
String pCommandWord;

public jdbcMysqlPStmt(jdbcMysqlConnex cx, String pStatement)
        throws SQLException
    {
    super(cx);
    fixedStatement = new Vector();
    parameters     = new Vector();
    prepParse(pStatement);
    }
 
/** This method parses the statement being prepared.
**/
private void prepParse(String pstatement) throws SQLException
    {
    String prev = "";
    String test;
    StringTokenizer st = new StringTokenizer(pstatement, "?", true);
    int state = 0;
    while(st.hasMoreTokens())
        {
        test = st.nextToken();
        switch(state)
            {
            case 0:
                if(test.equals("?"))  errHandlerM(21, "");
                getCommandValue(test);
                pCommandValue = commandValue;
                pCommandWord  = commandWord;
                prev = test;
                state = 1;
                break;
            case 1:
                if(test.equals("?")) state = 2;
                else prev = new String(prev + test);
                break;
            case 2:
                if(test.equals("?")) prev = new String(prev + "?");
                else{
                    newFixed(prev);
                    newParam();
                    prev = test;
                    }
                state = 1;
                break; 
            default:;
            } 
        }
    if(state == 0) errHandlerM(22, "");
    newFixed(prev);
    if(state == 2) newParam();
    fsize = fixedStatement.size();
    psize = parameters.size();
    }      
     
private void newFixed(String fs)
    {
    byte[] mb = fs.getBytes();
    fixedStatement.addElement(mb);
    }

private void newParam()
    {
    jdbcMysqlPSParam jp = new jdbcMysqlPSParam(parameters.size()+1);
    parameters.addElement(jp);
    }

/*===================================================================+
||                                                                  ||
+===================================================================*/

/** See API */
public void setNull(int p, int t) throws SQLException 
    { doMe(C_SETNULL, p, null, null, 0); }

/** Until MySQL supports pure booleans (and this driver is updated
*** appropriately) this will be sent as a zero or one.
**/
public void setBoolean(int p, boolean x) throws SQLException 
    {int t = x ? 1 : 0; doMe(C_SETBOOLEAN, p, null, null, t); }

/** Saved as a numeric. */
public void setByte(int p, byte x) throws SQLException
    {int t = x; doMe(C_SETBYTE, p, null, null, t); }

/** See API. */
public void setShort(int p, short x) throws SQLException
    {int t = x; doMe(C_SETSHORT, p, null, null, t); }

/** See API. */
public void setInt(int p, int x) throws SQLException
    { doMe(C_SETINT, p, null, null, x); }

/** See the API. */
public void setLong(int p, long x) throws SQLException
    { Long L = new Long(x); doMe(C_SETLONG, p, null, L, 0); }

/** See API. */
public void setFloat(int p, float x) throws SQLException
    { Float F = new Float(x); doMe(C_SETFLOAT, p, null, F, 0);}

/** See API. */
public void setDouble(int p, double x) throws SQLException
    { Double D = new Double(x); doMe(C_SETDOUBLE, p, null, D, 0);}

/** See the API. */
public void setString(int p, String x) throws SQLException 
    { doMe(C_SETSTRING, p, x, null, 0);}

public void setBytes(int p, byte[] x) throws SQLException 
    { doMe(C_SETBYTES, p, null, x, 0);}

/** See the API. */
public void setDate(int p, Date x) throws SQLException 
    { doMe(C_SETDATE, p, null, x, 0); }

/** See API. */
public void setTime(int p, Time x) throws SQLException 
    { doMe(C_SETTIME, p, null, x, 0); }

/** See API. */
public void setTimestamp(int p,   Timestamp x) throws SQLException 
    { doMe(C_SETTIMESTAMP, p, null, x, 0); }

/** All stream methods are treated the same in MySQL, else see API. */
public void setAsciiStream(int p, InputStream x, int l) throws SQLException 
    { doMe(C_SETASCIISTREAM, p, null, x, l); }

/** All stream methods are treated the same in MySQL, else see API. */
public void setBinaryStream(int p, InputStream x, int l) throws SQLException 
    { doMe(C_SETBINARYSTREAM, p, null, x, l); }

/** All stream methods are treated the same in MySQL, else see API. */
public void setUnicodeStream(int p, InputStream x, int l) throws SQLException 
    { doMe(C_SETUNICODESTREAM, p, null, x, l); }

/** See API */
public void setBigDecimal(int p, BigDecimal x) throws SQLException 
    { doMe(C_SETBIGDECIMAL, p, null, x, 0); }

/** Mad scientist at work.  Attempt at using object serialization
*** without the slightest hint at what I'm playing at.  Ggg..grandpa
*** Faust would be so proud!
**/
public void setObject(int p, Object x, int t, int s)throws SQLException 
    { doMe(C_SETOBJECT, p, null, x, t); }

/** Mad scientist at work.  Attempt at using object serialization
*** without the slightest hint at what I'm playing at.  Ggg..grandpa
*** Faust would be so proud!
**/
public void setObject(int p, Object x, int t) throws SQLException 
    { doMe(C_SETOBJECT, p, null, x, t); }

/** Mad scientist at work.  Attempt at using object serialization
*** without the slightest hint at what I'm playing at.  Ggg..grandpa
*** Faust would be so proud!
**/
public void setObject(int p, Object x) throws SQLException 
    { doMe(C_SETOBJECT, p, null, x, 0); }

public void clearParameters() throws SQLException 
    { doMe(C_CLEARPARAMETERS, 0, null, null, 0); }


/*===================================================================+
||                   Implementation of API methods                  ||
+===================================================================*/

private void doMe(int cmd, int p,  String s, Object o, int x1) 
        throws SQLException
    {
    int reqID = jdbcMysqlBase.getOID();
    boolean lockset = false;
    jdbcMysqlPSParam psp = null;
    if(cmd != C_CLEARPARAMETERS)
        {
        if(p < 1 || p > psize) errHandlerM(24, "");
        psp = (jdbcMysqlPSParam) parameters.elementAt(p-1);
        }
    try {
        lockset = lock(true, reqID, lTimeout); 
        if(!open) errHandlerM(16, apis[cmd]);
        switch(cmd)
            {
            case C_SETNULL:
                psp.setNull();
                break;   
            case C_SETBOOLEAN:
            case C_SETBYTE:
            case C_SETSHORT:
            case C_SETINT:
                psp.setString(String.valueOf(x1));
                break;        
            case C_SETLONG:
                Long L = (Long)o;
                psp.setString(L.toString());
                break;
            case C_SETFLOAT:
                Float F = (Float)o;
                psp.setString(F.toString());
                break;
            case C_SETDOUBLE:
                Double D = (Double)o;
                psp.setString(D.toString());
                break;
            case C_SETSTRING:
                psp.setString(s);
                break;
            case C_SETBYTES:
                psp.setBytes((byte[]) o);
                break;
            case C_SETDATE:
                Date DA = (Date)o;
                psp.setString(DA.toString());
                break;
            case C_SETTIME:
                Time T = (Time)o;
                psp.setString(T.toString());
                break;
            case C_SETTIMESTAMP:
                Timestamp TS = (Timestamp)o;
                psp.setString(TS.toString());
                break;
            case C_SETASCIISTREAM:
            case C_SETBINARYSTREAM:
            case C_SETUNICODESTREAM:
                psp.setStream((InputStream)o, x1);
                break;
            case C_SETBIGDECIMAL:
                BigDecimal B = (BigDecimal)o;
                psp.setString(B.toString());
                break;
            case C_SETOBJECT:
                if(x1 == Types.OTHER)
                    {
                    ByteArrayOutputStream baos = 
                            new ByteArrayOutputStream();
                    ObjectOutputStream oos = 
                            new ObjectOutputStream(baos);
                    oos.writeObject(o);
                    oos.flush();
                    byte[] ob = baos.toByteArray();
                    psp.setBytes(ob);
                    }
                else psp.setString(o.toString());
                break;
            case C_CLEARPARAMETERS:
                int ps = parameters.size();
                for(int i = 0; i < ps; i++)
                    {
                    psp = (jdbcMysqlPSParam) parameters.elementAt(i);
                    psp.clear();
                    }
                break;
            default: errHandlerM(25, String.valueOf(cmd));
            }
        lockset = lock(false, reqID, lTimeout); 
        }
    catch(Exception e)
        {
        if(lockset)lock(false, reqID, lTimeout);
        errHandlerE2(23, apis[cmd],  e);
        }
    return ;
    }



/*===================================================================+
||                        executeUpdate()                           ||
+===================================================================*/

public int executeUpdate() throws SQLException
    {
    int reqID = jdbcMysqlBase.getOID();
    boolean lockset = false;
    int rc = -1;
    try {
        lockset = lock(true, reqID, lTimeout); 
        if(!open) errHandlerM(16, "executeUpdate()");
        qResult.clear(); 
        if(pCommandValue < 100 || pCommandValue > 199)
                errHandlerM(1, pCommandWord);
        mExecUpdate();
        rc= qResult.getRows();
        lockset = lock(false, reqID, lTimeout);
        }
    catch(Exception e) 
        {
        if(lockset) lock(false, reqID, lTimeout);
        errHandlerE(9, e);
        }
    return rc;
    }

void mExecUpdate() throws SQLException
    {
    int status = -1;
    int rc  = -1;
    String message = null;
    boolean lockset = false;
    try {
        lockset = cx.lock(true, myOID, lTimeout);    
        mxEU();
        lockset = cx.lock(false, myOID, lTimeout);
        }
    catch(Exception e)
        {
        boolean rep = false;
        if(cx.broken && autoReX)
	    {
	    try {                        
                cx.xOpen();
                mxEU();
                rep = true;
	        }
            catch(Exception e1){}
            }
        if(lockset) cx.lock(false, myOID, lTimeout);
        if(!rep)errHandlerE(2, e);
        }
 
    status  = qResult.getStatus();

    if(status == 255) 
        {
        message = qResult.getMessage();
        errHandlerM(3, String.valueOf(rc) + " " + message);
        }
    if(status != 0) errHandlerM(4, String.valueOf(status));
    return;
    }

private void mxEU() throws SQLException
    {
    outBag.newWrite(0);
    outBag.iToB(jdbcMysqlBase.COM_QUERY, 1);
    putParameters();
    outBag.write();
    qResult.getResult(QTYPE_EU, commandValue);
    }

/*===================================================================+
||                        executeQuery()                            ||
+===================================================================*/

public ResultSet executeQuery() throws SQLException
    { 
    int reqID = jdbcMysqlBase.getOID();
    boolean lockset = false;
    ResultSet rs = null;
    jdbcMysqlRSet jrs = null;
    try {
        lockset = lock(true, reqID, lTimeout); 
        if(!open) errHandlerM(16, "executeQuery()");
        if(pCommandValue < 200 || pCommandValue > 399)
                errHandlerM(5, pCommandWord);
        qResult.clear(); 
        rs = mExecQuery(); 
        if(rs != null){ jrs = (jdbcMysqlRSet) rs; jrs.retrieved(true);}
        lockset = lock(false, reqID, lTimeout);
        }
    catch(Exception e) 
        {
        if(lockset) lock(false, reqID, lTimeout);
        errHandlerE(10, e);
        }
    return rs;
    }

ResultSet mExecQuery() throws SQLException
    {
    int status = -1;
    jdbcMysqlRSet rs = null;
    int rc  = -1;
    String message = null;
    boolean lockset = false;
    try {
        lockset = cx.lock(true, myOID, lTimeout);
        rs = mxEQ();    
        if(qResult.cacheMode != qResult.CM_NONE)
                lockset = cx.lock(false, myOID, lTimeout);
        }
    catch(Exception e)
        {
        if(cx.broken)
	    {
	    try {
                cx.xOpen();
                rs = mxEQ();
                if(qResult.cacheMode != qResult.CM_NONE)
                     lockset = cx.lock(false, myOID, lTimeout);
	        }
            catch(Exception e2){}
            }
        if(rs == null)
	    {
            if(lockset) cx.lock(false, myOID, lTimeout);
            errHandlerE(6, e);
            }
        }
    return rs;
    }


private jdbcMysqlRSet mxEQ() throws SQLException
    {
    jdbcMysqlRSet rs;
    outBag.newWrite(0);
    outBag.iToB(jdbcMysqlBase.COM_QUERY, 1);
    putParameters();
    outBag.write();
    qResult.getResult(QTYPE_EQ, pCommandValue);
    rs = new jdbcMysqlRSet(qResult);
    return rs; 
    }

/*===================================================================+
||                       execute()                                  ||
+===================================================================*/

public boolean execute() throws SQLException 
    {
    int reqID = jdbcMysqlBase.getOID();
    boolean lockset = false;
    ResultSet rs = null;
    try {
        lockset = lock(true, reqID, lTimeout); 
        qResult.clear(); 
        if(pCommandValue > 200 && pCommandValue < 400)
                rs = mExecQuery(); 
        else if(pCommandValue > 100 && pCommandValue < 200)
                mExecUpdate(); 
        else errHandlerM(13, "");
        lockset = lock(false, reqID, lTimeout); 
        }
    catch(Exception e)
        {
        if(lockset)lock(false, reqID, lTimeout);
        errHandlerE(14, e);
        }
    return rs != null;
    }

void putParameters() throws SQLException
    {
    byte[] b;
    jdbcMysqlPSParam psp;
    try {
        for(int i = 0; i < fsize; i++)
            {
            b = (byte[]) fixedStatement.elementAt(i);
            outBag.putByteArray(b, -1);
            if(i < psize)
                {
                psp = (jdbcMysqlPSParam) parameters.elementAt(i);
                psp.bagIt(outBag);
                }
            }
        }
    catch(Exception e) { errHandlerE(26, e); }
    }
}



