/**
*** Program DbMd.java     
***    in product twz1jdbcForMysql, 
***    Copyright 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;

import java.sql.*;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class DbMd implements DatabaseMetaData
{
/** Parent connection */
jdbcMysqlConnex cx;

/** Our connection */
jdbcMysqlConnex myCx;

/** Type mapping hashtable */
private static Hashtable typemap;

/** Max rows */
int maxRows;

/** Do we throw exceptions on unsupported methods or just reurn
*** empty tables?
**/
boolean dbmdXcept;

private static int T_STRING;
private static int T_INTEGER;
private static int T_SHORT;

private static String[] errs = {
                 "E0400 timeout error.",
                 "E0401 Error in API method ",
                 "E0402 Error making query: ",
                 "E0403 Schemas are not supported in MySQL.",
                 "E0404 Table type is not supported in MySQL - ",
                 "E0405 This method is not relevant to MySQL: ",
                 "E0406 dbmdMaxRows property is invalid -",
                               };

private static byte[] yes = null;
private static byte[] no  = null;
private static byte[] ten = null;
private static byte[] cin = null;
private static byte[] cnn = null;
private static byte[] btable = null;
private static byte[] bbestRowSession = null;
private static byte[] bbestRowNotPseudo = null;
private static byte[] bTableIndexOther = null;

private static RSMd getProc_rsmd  = null;
private static RSMd getCols_rsmd  = null;
private static RSMd getPCols_rsmd = null;
private static RSMd getBRId_rsmd  = null;
private static RSMd getTab_rsmd   = null;
private static RSMd getSchm_rsmd  = null;
private static RSMd getCats_rsmd  = null;
private static RSMd getTTyp_rsmd  = null;
private static RSMd getPK_rsmd    = null;
private static RSMd getTI_rsmd    = null;
private static RSMd getII_rsmd    = null;
private static RSMd getXK_rsmd    = null;
private static RSMd getKM_rsmd    = null;
private static RSMd getPr_rsmd    = null;

private static final String[] ctN = {
"ASC_OR_DESC",          // 0
"AUTO_INCREMENT",       // 1
"BUFFER_LENGTH",        // 2
"CARDINALITY",          // 3
"CASE_SENSITIVE",       // 4
"CHAR_OCTET_LENGTH",    // 5
"COLUMN_DEF",           // 6
"COLUMN_NAME",          // 7
"COLUMN_SIZE",          // 8
"COLUMN_TYPE",          // 9
"CREATE_PARAMS",        // 10
"DATA_TYPE",            // 11
"DECIMAL_DIGITS",       // 12
"DEFERRABILITY",        // 13
"DELETE_RULE",          // 14
"FILTER_CONDITION",     // 15
"FIXED_PREC_SCALE",     // 16
"FKCOLUMN_NAME",        // 17
"FKTABLE_CAT",          // 18
"FKTABLE_NAME",         // 19
"FKTABLE_SCHEM",        // 20
"FK_NAME",              // 21
"GRANTEE",              // 22
"GRANTOR",              // 23
"INDEX_NAME",           // 24
"INDEX_QUALIFIER",      // 25
"IS_GRANTABLE",         // 26
"IS_NULLABLE",          // 27
"KEY_SEQ",              // 28
"LENGTH",               // 29
"LITERAL_PREFIX",       // 30
"LITERAL_SUFFIX",       // 31
"LOCAL_TYPE_NAME",      // 32
"MAXIMUM_SCALE",        // 33
"MINIMUM_SCALE",        // 34
"NON_UNIQUE",           // 35
"NULLABLE",             // 36
"NUM_PREC_RADIX",       // 37
"ORDINAL_POSITION",     // 38
"PAGES",                // 39
"PKCOLUMN_NAME",        // 40
"PKTABLE_CAT",          // 41
"PKTABLE_NAME",         // 42
"PKTABLE_SCHEM",        // 43
"PK_NAME",              // 44
"PRECISION",            // 45
"PRIVILEGE",            // 46
"PROCEDURE_CAT",        // 47
"PROCEDURE_NAME",       // 48
"PROCEDURE_SCHEM",      // 49
"PROCEDURE_TYPE",       // 50
"PSEUDO_COLUMN",        // 51
"RADIX",                // 52
"REMARKS",              // 53
"SCALE",                // 54
"SCOPE",                // 55
"SEARCHABLE",           // 56
"SQL_DATA_TYPE",        // 57
"SQL_DATETIME_SUB",     // 58
"TABLE_CAT",            // 59
"TABLE_NAME",           // 60
"TABLE_SCHEM",          // 61
"TABLE_TYPE",           // 62
"TYPE",                 // 63
"TYPE_NAME",            // 64
"UNSIGNED_ATTRIBUTE",   // 65
"UPDATE_RULE",          // 66
"reserved1",            // 67
"reserved2",            // 68
"reserved3",            // 69
};

private static short[] ctL =
{
32,   // 0
11,   // 1
11,   // 2
11,   // 3
11,   // 4
11,   // 5
255,  // 6
32,   // 7
11,   // 8
5,    // 9
32,   // 10
5,    // 11
11,   // 12
5,    // 13
5,    // 14
32,   // 15
11,   // 16
32,   // 17
32,   // 18
32,   // 19
32,   // 20
32,   // 21
32,   // 22
32,   // 23
32,   // 24
32,   // 25
32,   // 26
32,   // 27
5,    // 28
11,   // 29
32,   // 30
32,   // 31
32,   // 32
5,    // 33
5,    // 34
11,   // 35
11,   // 36
11,   // 37
11,   // 38
11,   // 39
32,   // 40
32,   // 41
32,   // 42
32,   // 43
32,   // 44
11,   // 45
32,   // 46
32,   // 47
32,   // 48
32,   // 49
5,    // 50
11,   // 51
5,    // 52
255,  // 53
5,    // 54
5,    // 55
5,    // 56
11,   // 57
11,   // 58
32,   // 59
32,   // 60
32,   // 61
32,   // 62
5,    // 63
32,   // 64
11,   // 65
5,    // 66
32,   // 67
32,   // 68
32,   // 69
};

private static int[][] defref = 
{
{ 47, 49, 48, 67, 68, 69, 53, 50},
{ 41, 43, 42,  7,  9, 11, 60, 45, 29, 54, 52, 36, 53 },
{ 59, 61, 60, 62, 53 },
{ 61 },
{ 59 },
{ 62 },
{ 59, 61, 60, 7, 11, 64, 8,  2, 12, 37, 36, 53, 6, 57, 58, 5, 38, 27 }, 
{ 54, 7, 11, 64, 8, 2, 12, 51 },
{ 55,  7, 11, 64,  8,  2, 12, 51 },
{59, 61, 60,  7, 28, 44 },
{64, 11, 45, 30, 31, 10, 36,  4, 56, 65, 16,  1, 32, 34, 33, 57, 58, 37 },
{59, 61, 60, 35, 25, 24, 63, 38,  7,  0,  3, 39, 15 },
{ 18, 20, 19, 17, 18, 20, 19, 17, 28, 66, 14, 44, 21, 13 },
{ 59, 61, 60, 23, 22, 46, 26 }
};


DbMd(jdbcMysqlConnex connection) throws SQLException
    {
    if(yes == null)
        {
        yes               = "YES".getBytes();
        no                = "NO".getBytes();
        ten               = "10".getBytes();
        cin               = String.valueOf(columnNullable).getBytes();
        cnn               = String.valueOf(columnNoNulls).getBytes();
        btable            = "TABLE".getBytes();
        bbestRowSession   = String.valueOf(bestRowSession).getBytes(); 
        bbestRowNotPseudo = String.valueOf(bestRowNotPseudo).getBytes(); 
        bTableIndexOther  = String.valueOf(tableIndexOther).getBytes();    
        T_STRING  = jdbcMysqlField.FIELD_TYPE_VAR_STRING;
        T_INTEGER = jdbcMysqlField.FIELD_TYPE_LONG;
        T_SHORT   = jdbcMysqlField.FIELD_TYPE_SHORT; 
        }

    cx = connection;
    jdbcMysqlURL turl = new jdbcMysqlURL();
    turl.innovate(cx.curl);
    turl.valid = true;
    turl.setProperty("db", cx.catalog);

    String test = turl.getProperty("dbmdMaxRows");
    maxRows = jdbcMysqlBase.intValue(test, 65536, -1);
    if(maxRows == 0) maxRows = Integer.MAX_VALUE;
    if(maxRows < 0) errHandlerM(6, test);    
    turl.setProperty("maxRows", test);  

    test = turl.getProperty("dbmdDB");
    if(test != null) turl.setProperty("db", test);

    test = turl.getProperty("dbmdUser");
    if(test != null) turl.setProperty("user", test);

    test = turl.getProperty("dbmdPassword");
    if(test != null) turl.setProperty("password", test);
 
    dbmdXcept = false;
    test = turl.getProperty("dbmdXcept");
    if(jdbcMysqlBase.boolValue(test, 0, 0) == 1) dbmdXcept = true;
   
    this.myCx = new jdbcMysqlConnex(turl);
    cx.addDBMDconnex(myCx);

    }


public boolean allProceduresAreCallable() throws SQLException 
    { return false; }
/** Without actually looking we return true. */
public boolean allTablesAreSelectable() throws SQLException
    { return true;  }
public String getURL() throws SQLException
    {  return new String("jdbc:z1MySQL://" + cx.host + ":" + cx.port); }
public String getUserName() throws SQLException
    {   return cx.user; }
public boolean isReadOnly() throws SQLException 
    { return false; }
public boolean nullsAreSortedHigh() throws SQLException 
    { return false; }
public boolean nullsAreSortedLow() throws SQLException 
    { return true; }
public boolean nullsAreSortedAtStart() throws SQLException 
    { return false; }
public boolean nullsAreSortedAtEnd() throws SQLException 
    { return false; }
public String getDatabaseProductName() throws SQLException 
    { return "MySQL"; }
public String getDatabaseProductVersion() throws SQLException
    { return cx.serverVersion; }
public String getDriverName() throws SQLException
    { return cx.curl.getProperty("product"); }
public String getDriverVersion() throws SQLException
    { return cx.curl.getProperty("version"); }
public int getDriverMajorVersion() 
    { 
    try { return Integer.parseInt(cx.curl.getProperty("majorVersion")); } 
    catch(NumberFormatException e) { return -1; }
    }
public int getDriverMinorVersion()
    { 
    try { return Integer.parseInt(cx.curl.getProperty("minorVersion")); }
    catch(NumberFormatException e) { return -1; }
    }
/** Given wording of API I presume "local" means to the database */
public boolean usesLocalFiles() throws SQLException { return true; }
/** Presumed true given API wording */
public boolean usesLocalFilePerTable() throws SQLException {return true; }
public boolean supportsMixedCaseIdentifiers() throws SQLException
    { return false; }
public boolean storesUpperCaseIdentifiers() throws SQLException
    { return false; }
public boolean storesLowerCaseIdentifiers() throws SQLException
    { return false; }
public boolean storesMixedCaseIdentifiers() throws SQLException
    { return true; }
public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException
    { return false; }
public boolean storesUpperCaseQuotedIdentifiers() throws SQLException
    { return false; }
public boolean storesLowerCaseQuotedIdentifiers() throws SQLException
    { return false; }
public boolean storesMixedCaseQuotedIdentifiers() throws SQLException
    { return false; }
public String getIdentifierQuoteString() throws SQLException
    { return " "; }
/** Most of this is a guess from the MySQL documentation since I don't
*** know a lot about the formal ANSI 92 SQL.  Will look it up someday.
**/
public String getSQLKeywords() throws SQLException
    {
    return "MEDIUMINT,SET,ENUM,BLOB,TEXT,AUTO_INCREMENT,BINARY,"
          +"UNSIGNED,ZEROFILL,LOAD,INFILE,OUTFILE,SET,OPTION,REPLACE";
    }
/** Right from the manual */
public String getNumericFunctions() throws SQLException
    {
    return "ABS,SIGN,MOD,FLOOR,CEILING,ROUND,EXP,LOG,LOG10,POW,POWER,"
          +"sqrt,PI,COS,SIN,TAN,ACOS,ATAN,ASIN,ATAN2,COT,RAND,MIN,MAX,"
          +"DEGREES,RADIANS,TRUNCATE";
    }
/** Right from the manual */
public String getStringFunctions() throws SQLException
    {
    return "ASCII,CHAR,CONCAT,OCTET_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,"
          +"LOCATE,POSITION,INSTR,SUBSTRING,LEFT,RIGHT,LTRIM,RTRIM,TRIM,"
          +"SOUNDEX,REPLACE,REPEAT,REVERSE,INSERT,INTERVAL,ELT,FIELD,"
          +"FIND_IN_SET,LCASE,LOWER,UCASE,UPPER";
    }
/** Right from the manual */
public String getSystemFunctions() throws SQLException
    { return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,"
            + "LAST_INSERT_ID,VERSION"; 
    }
/** Right from the manual */
public String getTimeDateFunctions() throws SQLException
    { return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,"
           + "MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,"
           + "PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,"
           + "CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,"
           + "CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,"
           + "TIME_TO_SEC";
    }
public String getSearchStringEscape() throws SQLException 
    { return "\\"; }
public String getExtraNameCharacters() throws SQLException 
    { return ""; }
public boolean supportsAlterTableWithAddColumn() throws SQLException
    { return true; }
public boolean supportsAlterTableWithDropColumn() throws SQLException
    { return true; }
public boolean supportsColumnAliasing() throws SQLException 
    { return true; }
public boolean nullPlusNonNullIsNull() throws SQLException 
    { return true; }
/** Didn't see any explicit mention of CONVERT though implicit conversion
*** is all over the place.
**/
public boolean supportsConvert() throws SQLException 
    { return false; }
public boolean supportsConvert(int x, int y) throws SQLException 
    { return false; }
/** Not quite sure what they mean here; have to dig someday */
public boolean supportsTableCorrelationNames() throws SQLException
    { return true; }
public boolean supportsDifferentTableCorrelationNames() throws SQLException
    { return true; }
public boolean supportsExpressionsInOrderBy() throws SQLException
    { return true; }
public boolean supportsOrderByUnrelated() throws SQLException
    { return true; }
public boolean supportsGroupBy() throws SQLException
    { return true; }
public boolean supportsGroupByUnrelated() throws SQLException
    { return true; }
public boolean supportsGroupByBeyondSelect() throws SQLException
    { return true; }
public boolean supportsLikeEscapeClause() throws SQLException
    { return true; }
public boolean supportsMultipleResultSets() throws SQLException
    { return false; }
/** Odd one, no transactions but diff queries on diff connex */
public boolean supportsMultipleTransactions() throws SQLException
    { return false; }
public boolean supportsNonNullableColumns() throws SQLException
    { return true; }
public boolean supportsMinimumSQLGrammar() throws SQLException
    { return true; }
public boolean supportsCoreSQLGrammar() throws SQLException
    { return true; }
/** A guess */
public boolean supportsExtendedSQLGrammar() throws SQLException
    { return true; }
public boolean supportsANSI92EntryLevelSQL() throws SQLException
    { return true; }
public boolean supportsANSI92IntermediateSQL() throws SQLException
    { return true; }
public boolean supportsANSI92FullSQL() throws SQLException
    { return true; }
public boolean supportsIntegrityEnhancementFacility() throws SQLException
    { return false; }
public boolean supportsOuterJoins() throws SQLException
    { return true; }
/** ng reports problems with left outer join */
public boolean supportsFullOuterJoins() throws SQLException
    { return false; }
public boolean supportsLimitedOuterJoins() throws SQLException
    { return true; }
public String getSchemaTerm() throws SQLException
    { return null; }
public String getProcedureTerm() throws SQLException 
    { return null; }
public String getCatalogTerm() throws SQLException
    { return "database"; }
public boolean isCatalogAtStart() throws SQLException
    { return false; }
public String getCatalogSeparator() throws SQLException
    { return null; }
public boolean supportsSchemasInDataManipulation() throws SQLException
    { return false; }
public boolean supportsSchemasInProcedureCalls() throws SQLException
    { return false; }
public boolean supportsSchemasInTableDefinitions() throws SQLException
    { return false; }
public boolean supportsSchemasInIndexDefinitions() throws SQLException
    { return false; }
public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException
    { return false; }
public boolean supportsCatalogsInDataManipulation() throws SQLException
    { return false; }
public boolean supportsCatalogsInProcedureCalls() throws SQLException
    { return false; }
public boolean supportsCatalogsInTableDefinitions() throws SQLException
    { return false; }
public boolean supportsCatalogsInIndexDefinitions() throws SQLException
    { return false; }
public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException
    { return false; }
public boolean supportsPositionedDelete() throws SQLException
    { return false; }
public boolean supportsPositionedUpdate() throws SQLException
    { return false; }
public boolean supportsSelectForUpdate() throws SQLException
    { return false; }
public boolean supportsStoredProcedures() throws SQLException
    { return false; }
public boolean supportsSubqueriesInComparisons() throws SQLException
    { return true; }
public boolean supportsSubqueriesInExists() throws SQLException
    { return true; }
/** clueless here */
public boolean supportsSubqueriesInIns() throws SQLException
    { return true; }
/** Wazza quantified? */
public boolean supportsSubqueriesInQuantifieds() throws SQLException
    { return false; }
/** Damfino.  Lookee all the purty colors ... */
public boolean supportsCorrelatedSubqueries() throws SQLException
    { return false; }
/** Union??  I may be Pennsylvanian but my heart belongs to Dixie */
public boolean supportsUnion() throws SQLException
    { return false; }
public boolean supportsUnionAll() throws SQLException
    { return false; }
public boolean supportsOpenCursorsAcrossCommit() throws SQLException
    { return false; }
public boolean supportsOpenCursorsAcrossRollback() throws SQLException
    { return false; }
public boolean supportsOpenStatementsAcrossCommit() throws SQLException
    { return false; }
public boolean supportsOpenStatementsAcrossRollback() throws SQLException
    { return false; }
public int getMaxBinaryLiteralLength() throws SQLException
    { return 16777208; }
public int getMaxCharLiteralLength() throws SQLException
    { return 16777208; }
/** settable at gen; is there a way to check? */
public int getMaxColumnNameLength() throws SQLException
    { return 32; }
/** need to look this up */
public int getMaxColumnsInGroupBy() throws SQLException
    { return 16; }
public int getMaxColumnsInIndex() throws SQLException
    { return 16; }
public int getMaxColumnsInOrderBy() throws SQLException
    { return 16; }
/** Is there a limit? */
public int getMaxColumnsInSelect() throws SQLException
    { return 256; }
public int getMaxColumnsInTable() throws SQLException
    { return 512; }
public int getMaxConnections() throws SQLException
    { return 64; }
public int getMaxCursorNameLength() throws SQLException
    { return 0; }
public int getMaxIndexLength() throws SQLException
    { return 128; }
public int getMaxSchemaNameLength() throws SQLException
    { return 0; }
public int getMaxProcedureNameLength() throws SQLException
    { return 0; }
/* Is this even architected in MySQL??? */
public int getMaxCatalogNameLength() throws SQLException
    { return 32; }
public int getMaxRowSize() throws SQLException
    { return Integer.MAX_VALUE - 8; }
public boolean doesMaxRowSizeIncludeBlobs() throws SQLException
    { return true; }
public int getMaxStatementLength() throws SQLException
    { return 16777208; }
public int getMaxStatements() throws SQLException
    { return Integer.MAX_VALUE; }
public int getMaxTableNameLength() throws SQLException
    { return 32; }
/** Is there a limit? */
public int getMaxTablesInSelect() throws SQLException
    { return 256; }
public int getMaxUserNameLength() throws SQLException
    { return 16; }
public int getDefaultTransactionIsolation() throws SQLException
    { return java.sql.Connection.TRANSACTION_NONE; }
public boolean supportsTransactions() throws SQLException
    { return false; }
public boolean supportsTransactionIsolationLevel(int l)
        throws  SQLException
    { return l == java.sql.Connection.TRANSACTION_NONE; }
public boolean supportsDataDefinitionAndDataManipulationTransactions()
        throws SQLException
    { return false; }
public boolean supportsDataManipulationTransactionsOnly()
        throws SQLException
    { return false; }
public boolean dataDefinitionCausesTransactionCommit() throws SQLException
    { return false; }
public boolean dataDefinitionIgnoredInTransactions() throws SQLException
    { return false; }

/** No procedures in MySQL, return empty RS */
public ResultSet getProcedures(String c, String s, String p)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getProcedures()");
    ResultSet rs = null;
    try {
        RSMd rsmd = null;
        if(getProc_rsmd != null)
	    { rsmd = getProc_rsmd.copy(); }
        else{
            rsmd = rsMake(0);
            getProc_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        rs = ws.pseudoResult(null, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getProcedures()", e);  } 
    return rs;
    }

/** No procedures in MySQL, return empty RS */
public ResultSet 
       getProcedureColumns(String c, String s, String p, String l)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getProcedureColumns()");
    ResultSet rs = null;
    try {
        RSMd rsmd = null;
        if(getPCols_rsmd != null)
	    { rsmd = getPCols_rsmd.copy(); }
        else{
	  rsmd = rsMake(1);
            getPCols_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        rs = ws.pseudoResult(null, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getProcedureColumns()", e); } 
    return rs;
    }

/** See the API */
public ResultSet 
       getTables(String c, String s, String p, String[] t)
       throws SQLException
    {
    String pcat = c;
    if(c == null)pcat = cx.catalog;
    if(s != null) errHandlerM(2, s);
    ResultSet rs = null;
    String tp;
    if(p == null) tp = "";
    else tp = " LIKE '" + p + "'";
    try {
        if(t != null)
             {
             int u = t.length;
             for(int i = 0; i < u; i++)
                 { if(!t[i].equals("TABLE")) errHandlerM(4, t[i]); }
             }

        RSMd rsmd = null;
        if(getTab_rsmd != null)
	    { rsmd = getTab_rsmd.copy(); }
        else{
            rsmd = rsMake(2);
            getTab_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        Statement ds = myCx.createStatement();

        Vector cats;
	// Used to be c rather than pcat.  Why??
        if(pcat == null) cats = getResult1("show databases");
        else{
            cats = new Vector();
            cats.addElement(pcat);
            }
        int catSize = cats.size();
        String catString;
        byte[] catBytes;
        ResultSet dr = null;
        Vector v = new Vector();
        int rc = 0;
        byte[] b;
        for(int i = 0; i < catSize && rc < maxRows; i++)
            {
            catString = (String) cats.elementAt(i);
            catBytes = catString.getBytes();
            dr = ds.executeQuery("show tables from " + catString + tp);
            while(dr.next() && rc < maxRows)
                {
                Object[] oa = new Object[5];
                oa[0] = catBytes;
                oa[1] = null;
                oa[2] = dr.getBytes(1);
                oa[3] = btable;
                oa[4] = null;
                v.addElement(oa);
                rc++;
                }   
            dr.close();
            }   
        rs = ws.pseudoResult(v, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getTables()", e);} 
    return rs;
    }

/*-------------------------------------------------------------------+
|                          schemas                                   |
+-------------------------------------------------------------------*/

/** No schemas in MySQL, return empty RS */
public ResultSet getSchemas() throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getSchemas()");
    ResultSet rs = null;
    try {
        RSMd rsmd = null;
        if(getSchm_rsmd != null)
	    { rsmd = getSchm_rsmd.copy(); }
        else{
            rsmd = rsMake(3);
            getSchm_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        //rsCol(rsmd, "TABLE_SCHEM", T_STRING, 32);

        rs = ws.pseudoResult(null, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getSchemas()", e);} 
    return rs;
    }

/*-------------------------------------------------------------------+
|                           catalogs                                 |
+-------------------------------------------------------------------*/

public ResultSet getCatalogs() throws SQLException
    {
    ResultSet rs = null;
    try {
        RSMd rsmd = null;
        if(getCats_rsmd != null)
	    { rsmd = getCats_rsmd.copy(); }
        else{
            rsmd = rsMake(4);
            getCats_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        Statement ds = myCx.createStatement();
        ResultSet dr = ds.executeQuery("show databases");
        Vector v = new Vector();   
        int rc = 0; 
        while(dr.next() && rc < maxRows)
           {
           Object[] oa = new Object[1];
           oa[0] = dr.getBytes(1);
           v.addElement(oa);
           rc++;
           }   
        dr.close();
        rs = ws.pseudoResult(v, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getCatalogs()", e);} 
    return rs;
    }

/*-------------------------------------------------------------------+
|                          table types                               |
+-------------------------------------------------------------------*/

public ResultSet getTableTypes() throws SQLException
    {
    ResultSet rs = null;
    try {
        RSMd rsmd = null;
        if(getTTyp_rsmd != null)
	    { rsmd = getTTyp_rsmd.copy(); }
        else{
            rsmd = rsMake(5);
            getTTyp_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        Vector v = new Vector();
        Object[] o = new Object[1];
        o[0] = btable; 
        v.addElement(o);
        rs = ws.pseudoResult(v, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getTableTypes()", e);} 
    return rs;
    }
 
/*-------------------------------------------------------------------+
|                       table privileges                             |
+-------------------------------------------------------------------*/

/** Priveliges work a little different in MySQL, return empty RS */
public ResultSet 
       getTablePrivileges(String c, String s, String p)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getProcedureColumns()");
    ResultSet rs = null;
    try { rs = makePrivs(); }
    catch(Exception e) { errHandlerE2(1, "getTablePrivileges()", e);} 
    return rs;
    }

 
/*-------------------------------------------------------------------+
|                        column privileges                           |
+-------------------------------------------------------------------*/

/** Priveliges work a little different in MySQL, return empty RS */
public ResultSet 
       getColumnPrivileges(String c, String s, String p, String l)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getColumnPrivilegess()");
    ResultSet rs = null;
    try { rs = makePrivs(); }
    catch(Exception e) { errHandlerE2(1, "getColumnPrivileges()", e); } 
    return rs;
    }


/*-------------------------------------------------------------------+
|                             columns                                |
+-------------------------------------------------------------------*/

public ResultSet 
       getColumns(String c, String s, String p, String l)
       throws SQLException
    {
    ResultSet rs = null;
    if(s != null) errHandlerM(2, s);
    try {
        RSMd rsmd = null;
        if(getCols_rsmd != null)
	    { rsmd = getCols_rsmd.copy(); }
        else{
            rsmd = rsMake(6);
            getCols_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        Statement ds = myCx.createStatement();

        Vector cats;
        Vector tabs;
        String ttq;
        String ffq;
        String catString;
        byte[] catBytes;
        int catSize;
        String tabString;
        byte[] tabBytes;
        int tabSize;
        Vector flds;
        int    fldSize;
        String q;
        Vector v = new Vector();
        int i;
        int rc = 0;
        String tname;
        DMTable xtable;
        DMTabCol[] cols;
        DMTabCol  xcol;

        String ttqx = "";
        if(p != null) ttqx = new String(" LIKE \'" + p + "\'");

        String ffqx = "";
        if(l != null) ffqx = new String(" LIKE \'" + l + "\'");

        if(c == null) cats = getResult1("show databases");
        else{
            cats = new Vector();
            cats.addElement(c);
            }
        catSize = cats.size();
        for(int cc = 0; cc < catSize && rc < maxRows; cc++)
            {
            catString = (String)cats.elementAt(cc);
            catBytes = catString.getBytes();
            ttq = new String("show tables from " + catString + ttqx);
            tabs = getResult1(ttq);
            tabSize = tabs.size();
            for(int tt = 0; tt < tabSize && rc < maxRows; tt++)
                {
                tabString = (String) tabs.elementAt(tt);
                tabBytes = tabString.getBytes();
                xtable = new DMTable(ws, catString, tabString);
                cols = xtable.subColumns(ws, ffqx);
                if(cols != null)for(i = 0; i < cols.length; i++)
                    {
                    xcol = cols[i];
                    Object[] oa = new Object[18];
                    oa[0]  = catBytes;
                    oa[1]  = null;
                    oa[2]  = tabBytes;
                    oa[3]  = xcol.bColName;
                    oa[4]  = xcol.bSQLType;
                    oa[5]  = xcol.typeName;
                    oa[6]  = xcol.bLength;
                    oa[7]  = null;
                    oa[8]  = xcol.bDigits;
                    oa[9]  = ten;
                    oa[10] = xcol.nullable ? cin : cnn;
                    oa[11] = xcol.bRemarks;
                    oa[12] = xcol.bDefault;
                    oa[13] = null;
                    oa[14] = null;
                    oa[15] = xcol.bLength;
                    oa[16] = xcol.bPos;
                    oa[17] = xcol.nullable ? yes : no ;
                    v.addElement(oa);
                    rc++;
                    }
                }
            }   
        rs = ws.pseudoResult(v, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getColumns()", e); } 
    return rs;
    }
 
/*-------------------------------------------------------------------+
|                         best row identifier                        |
+-------------------------------------------------------------------*/

/** Maybe later, and maybe peace will break out all over,
***, return empty RS */
public ResultSet 
       getBestRowIdentifier(String c, String s, String t, int r, boolean n)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getBestRowIdentifier()");
    ResultSet rs = null;
    try {
        Vector v = new Vector();
        int pkn, bk, ks, i; 
        DMKey tk = null;
        DMKTine wt;
        DMTabCol wc;

        RSMd rsmd = null;
        if(getBRId_rsmd != null)
	    { rsmd = getBRId_rsmd.copy(); }
        else{
            rsmd = rsMake(7);
            getBRId_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        DMTable table = new DMTable(ws, c, t);
        pkn = table.getKeys(ws);
        ks = table.keys.size();
        bk = -1;
        for(i = 0; i < ks; i++)
	    {
            tk = (DMKey) table.keys.elementAt(i);
            if(tk.tines.size() == 1 && tk.autoinc && tk.unique) i = ks + 2;
            else tk = null;
            }
        if(tk == null && pkn > -1) tk = 
                (DMKey) table.keys.elementAt(pkn);
        if(tk != null)
	    {
            ks = tk.tines.size();
            for(i = 0; i < ks; i++)
                {
                wt = (DMKTine) tk.tines.elementAt(i);
                wc = wt.column;
                Object[] o = new Object[8];
                o[0] = bbestRowSession;
                o[1] = wc.bColName;
                o[2] = wc.bSQLType;
                o[3] = wc.typeName;
                o[4] = wc.bLength;
                o[5] = wc.bLength;
                o[6] = wc.bDigits;     
                o[7] = bbestRowNotPseudo;
                v.addElement(o);
                }
            rs = ws.pseudoResult(v, rsmd);
            }  
        if(rs == null) rs = ws.pseudoResult(null, rsmd);      
        }
    catch(Exception e) { errHandlerE2(1, "getBestRowIdentifier()", e); } 
    return rs;
    }
 
/*-------------------------------------------------------------------+
|                       version columns ?                            |
+-------------------------------------------------------------------*/

/** AFAIK no version columns in MySQL, return empty RS */
public ResultSet 
       getVersionColumns(String c, String s, String t)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getVersionColumns()");
    ResultSet rs = null;
    Vector oa = new Vector();
    try {

        RSMd rsmd = null;
        if(getKM_rsmd != null)
	    { rsmd = getKM_rsmd.copy(); }
        else{
            rsmd = rsMake(8);
            getKM_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        rs = ws.pseudoResult(null, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getVersionColumns()", e); } 
    return rs;
    }

/*-------------------------------------------------------------------+
|                           primary keys                             |
+-------------------------------------------------------------------*/

/** May do this later, return empty RS */
public ResultSet 
       getPrimaryKeys(String c, String s, String t)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getPrimaryKeys()");
    if(s != null) errHandlerM(2, s);
    DMKey pkey = null;
    ResultSet rs = null;
    Vector oa = new Vector();
    String cat = c;
    if(c == null) cat = cx.catalog;
    try {
        DMKTine wt;
        DMTabCol wc;

        RSMd rsmd = null;
        if(getPK_rsmd != null)
	    { rsmd = getPK_rsmd.copy(); }
        else{
            rsmd = rsMake(9);
            getPK_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        DMTable table = new DMTable(ws, cat, t);
        int pkn = table.getKeys(ws);
        if(pkn < 0) rs = ws.pseudoResult(null, rsmd);
        else{
            pkey = (DMKey) table.keys.elementAt(pkn);
            int ks = pkey.tines.size();
            String[] nk = new String[ks];
            DMKTine[] kt = new DMKTine[ks];
            for(int i = 0; i < ks; i++)
	        {
                wt = (DMKTine) pkey.tines.elementAt(i);
                wc = wt.column;
                nk[i] = wc.colName;
                kt[i] = wt;
                } 
            sillySort(nk, kt);
            for(int i = 0; i < ks; i++)
	        {
                wt = kt[i];
                wc = wt.column;
                Object[] o = new Object[6];
                o[0] = cat.getBytes();
                o[1] = null;
                o[2] = t.getBytes();
                o[3] = wc.bColName;
                o[4] = String.valueOf(wt.seq).getBytes();
                o[5] = "PRIMARY".getBytes();
                oa.addElement(o);
                } 
            rs = ws.pseudoResult(oa, rsmd);
	    }
        }    
    catch(Exception e) { errHandlerE2(1, "getPrimaryKeys()", e); } 
    return rs;
    }


void sillySort(String[] s, Object[] o)
    {
    int m = s.length;
    int i, j;
    i = 0; j = 1;
    String ws;
    Object wo;
    while(j < m)
        {
        if(s[j].compareTo(s[i]) < 0)
	    { 
            ws = s[i];
            wo = o[i];
            s[i] = s[j];
            o[i] = o[j];
            s[j] = ws;
            o[j] = wo;
            if(i > 0) { i--; j--; }
            }
        else{ i++; j++; }
        }
    }

/*-------------------------------------------------------------------+
|                         imported keys                              |
 +-------------------------------------------------------------------*/

/** Return empty RS */
public ResultSet 
       getImportedKeys(String c, String s, String t)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getImportedKeys()");
    ResultSet rs = null;
    try { rs = makeXkey(); }
    catch(Exception e) { errHandlerE2(1, "getImportedKeys()", e); } 
    return rs;
    }

/*-------------------------------------------------------------------+
|                         exported keys                              |
+-------------------------------------------------------------------*/

/** Return empty RS */
public ResultSet 
       getExportedKeys(String c, String s, String t)
       throws SQLException
    {
    ResultSet rs = null;
    if(dbmdXcept) errHandlerM(5, "getExportedKeys()");
    try { rs = makeXkey(); }
    catch(Exception e) { errHandlerE2(1, "getExportedKeys()", e); } 
    return rs;
    }

/*-------------------------------------------------------------------+
|                        cross reference                             |
+-------------------------------------------------------------------*/

/** Return empty RS */
public ResultSet 
       getCrossReference(String pc, String ps, String pt,
                         String fc, String fs, String ft)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getCrossReference()");
    ResultSet rs = null;
    try { rs = makeXkey(); }
    catch(Exception e) { errHandlerE2(1, "getCrossReference()", e);} 
    return rs;
    }

/*-------------------------------------------------------------------+
|                          type info                                 |
+-------------------------------------------------------------------*/

/** Someday, Return empty RS */
public ResultSet 
       getTypeInfo() throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getTypeInfo()");
    ResultSet rs = null;
    try {

        RSMd rsmd = null;
        if(getTI_rsmd != null)
	    { rsmd = getTI_rsmd.copy(); }
        else{
            rsmd = rsMake(10);
            getTI_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;
/*        if(typeInfoVector != null)
**             {
**             Vector typeInfoVector = new Vector();
*/               
        rs = ws.pseudoResult(null, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getTypeInfo()", e); } 
    return rs;
    }

/*-------------------------------------------------------------------+
|                           index info                               |
+-------------------------------------------------------------------*/

/** Return empty RS */
public ResultSet 
       getIndexInfo(String c, String s, String t, boolean u, boolean a)
       throws SQLException
    {
    if(dbmdXcept) errHandlerM(5, "getIndexInfo()");
    ResultSet rs = null;
    String cat = c; 
    if(c == null)cat = cx.catalog;
    try {
        DMKey wk;
        DMKTine wt;
        DMTabCol wc;

        RSMd rsmd = null;
        if(getII_rsmd != null)
	    { rsmd = getII_rsmd.copy(); }
        else{
            rsmd = rsMake(11);
            getII_rsmd = rsmd.copy();
	    }
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rsmd.stmt = ws;

        DMTable table = new DMTable(ws, cat, t);
        table.getKeys(ws);
        int ks = table.keys.size();
        int i, j, ts;
        Vector v = new Vector();
        String[] inames = new String[ks];
        Object[] iobj   = new Object[ks];
        for(i = 0; i < ks; i++)
	    {
            wk = (DMKey) table.keys.elementAt(i);
            inames[i] = wk.unique 
                      ? "1" + wk.keyName 
	              : "0" + wk.keyName;
            iobj[i] = wk;
            }
        sillySort(inames, iobj);
        for(i = 0; i < ks; i++)
	    {
            wk = (DMKey) iobj[i];
            ts = wk.tines.size();
            for(j = 0; j < ts; j++)
	        {
                wt = (DMKTine) wk.tines.elementAt(j);
                wc = (DMTabCol) wt.column;
                if(!u || wk.unique)
		    {
                    Object[] o = new Object[13];
                    o[0] = cat.getBytes();
                    o[1] = null;
                    o[2] = table.bTableName;  
                    o[3] = wk.unique ? "1".getBytes() : "0".getBytes(); 
                    o[4] = null;
                    o[5] = wk.bKeyName;
                    o[6] = bTableIndexOther;  
                    o[7] = String.valueOf(wt.seq).getBytes();      
                    o[8] = wc.bColName;
                    o[9] = wt.order.getBytes();
                    o[10] = wt.cardinality;
                    o[11] = "1".getBytes(); // Hope to keep from bombing.
                    o[12] = null;
                    v.addElement(o);
                    }
                }
            }
        rs = ws.pseudoResult(v, rsmd);
        }
    catch(Exception e) { errHandlerE2(1, "getIndexInfo()", e); } 
    return rs;
    }

/*-------------------------------------------------------------------+
|                      collapse duplicate                            |
+-------------------------------------------------------------------*/

private ResultSet makeXkey() throws SQLException
    {
    RSMd rsmd = null;
    if(getXK_rsmd != null)
        { rsmd = getXK_rsmd.copy(); }
    else{
        rsmd = rsMake(12);
        getXK_rsmd = rsmd.copy();
        }
    jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
    rsmd.stmt = ws;

    return ws.pseudoResult(null, rsmd);
    }

private ResultSet makePrivs() throws SQLException
    {
    RSMd rsmd = null;
    if(getPr_rsmd != null)
        { rsmd = getPr_rsmd.copy(); }
    else{
        rsmd = rsMake(13);
        getPr_rsmd = rsmd.copy();
        }
    jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
    rsmd.stmt = ws;

    return ws.pseudoResult(null, rsmd);
    }

/*-------------------------------------------------------------------+
|                     Helper methods                                 |
+-------------------------------------------------------------------*/


/** A simple method to return a vector of the first column of a query */
private Vector getResult1(String query) throws SQLException
    {
    ResultSet rs = null; 
    Vector v = new Vector();
    try {
        jdbcMysqlStmt ws = (jdbcMysqlStmt) myCx.createStatement();
        rs = ws.executeQuery(query); 
        String u;
        while(rs.next())
             { 
             u = rs.getString(1);
             v.addElement(u);
             }
         }
    catch(Exception e) { errHandlerE2(2, query, e); }
    return v;
    }

private jdbcMysqlField 
        rsCol(RSMd rd, String name, int ty, int len)
        throws SQLException
    {
    jdbcMysqlField f = new jdbcMysqlField(rd.cc);
    f.setColumnName(name);
    f.setColumnType(ty);
    f.setColumnSize(len);
    rd.addField(f);
    return f;
    } 

private RSMd rsMake(int m) throws SQLException
    {
    RSMd r = new RSMd(null);
    int x;
    int[] p = defref[m];
    int t = p.length;
    String s;
    int l, y;
    for(int i=0; i < t; i++)
        {
        x = p[i];
        s = ctN[x];
        l = ctL[x];
        switch(l)
	    {
            case 11: y = T_INTEGER; break;
            case 5 : y = T_SHORT; break;
            default: y = T_STRING;
            }
        rsCol(r, s, y, l);
	}
    return r;
    }

/*===================================================================+
||                        Error handlers                            ||
+===================================================================*/

void errHandlerM(int n, String m) throws SQLException
    {
    String o = "\n" + errs[n] + m;
    jdbcMysqlBase.errMessage(o);
    }
    
void errHandlerE(int n, Exception e) throws SQLException
    {
    String o = "\n" +errs[n] + jdbcMysqlBase.eMessage(e);
    jdbcMysqlBase.errMessage(o);
    }

void errHandlerE2(int n, String s, Exception e) throws SQLException
    {
    String o = "\n" + errs[n] + " " + s + jdbcMysqlBase.eMessage(e);
    jdbcMysqlBase.errMessage(o);
    }

}


