/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlConnex;
import twz1.jdbc.mysql.jdbcMysqlDebug;
import twz1.jdbc.mysql.jdbcMysqlDriver;
import twz1.jdbc.mysql.jdbcMysqlResult;
import twz1.jdbc.mysql.jdbcMysqlStmt;

public final class jdbcMysqlBase {
    static final int COM_SLEEP = 0;
    static final int COM_QUIT = 1;
    static final int COM_INIT_DB = 2;
    static final int COM_QUERY = 3;
    static final int COM_FIELD_LIST = 4;
    static final int COM_CREATE_DB = 5;
    static final int COM_DROP_DB = 6;
    static final int COM_REFRESH = 7;
    static final int COM_SHUTDOWN = 8;
    static final int COM_STATISTICS = 9;
    static final int COM_PROCESS_INFO = 10;
    static final int COM_CONNECT = 11;
    static final int COM_PROCESS_KILL = 12;
    static final int COM_DEBUG = 13;
    static final int COM_INSERT = 101;
    static final int COM_UPDATE = 102;
    static final int COM_DELETE = 103;
    static final int COM_CREATE_T = 104;
    static final int COM_DROP = 105;
    static final int COM_ALTER = 106;
    static final int COM_LOCK = 107;
    static final int COM_UNLOCK = 109;
    static final int COM_SET = 110;
    static final int COM_GRANT = 111;
    static final int COM_REPLACE = 112;
    static final int COM_COMMENT = 190;
    static final int COM_SELECT = 201;
    static final int COM_DESCRIBE = 301;
    static final int COM_EXPLAIN = 302;
    static final int COM_SHOW = 304;
    static final int NOT_NULL_FLAG = 1;
    static final int PRI_KEY_FLAG = 2;
    static final int UNIQUE_KEY_FLAG = 4;
    static final int MULTIPLE_KEY_FLAG = 8;
    static final int BLOB_FLAG = 16;
    static final int UNSIGNED_FLAG = 32;
    static final int ZEROFILL_FLAG = 64;
    static final int BINARY_FLAG = 128;
    static final int ENUM_FLAG = 256;
    static final int PART_KEY_FLAG = 512;
    static final int GROUP_FLAG = 1024;
    static final int FIELD_TYPE_DECIMAL = 0;
    static final int FIELD_TYPE_TINY = 1;
    static final int FIELD_TYPE_CHAR = 1;
    static final int FIELD_TYPE_SHORT = 2;
    static final int FIELD_TYPE_LONG = 3;
    static final int FIELD_TYPE_FLOAT = 4;
    static final int FIELD_TYPE_DOUBLE = 5;
    static final int FIELD_TYPE_NULL = 6;
    static final int FIELD_TYPE_TIMESTAMP = 7;
    static final int FIELD_TYPE_LONGLONG = 8;
    static final int FIELD_TYPE_INT24 = 9;
    static final int FIELD_TYPE_DATE = 10;
    static final int FIELD_TYPE_TIME = 11;
    static final int FIELD_TYPE_DATETIME = 12;
    static final int FIELD_TYPE_ENUM = 247;
    static final int FIELD_TYPE_INTERVAL = 247;
    static final int FIELD_TYPE_SET = 248;
    static final int FIELD_TYPE_TINY_BLOB = 249;
    static final int FIELD_TYPE_MEDIUM_BLOB = 250;
    static final int FIELD_TYPE_LONG_BLOB = 251;
    static final int FIELD_TYPE_BLOB = 252;
    static final int FIELD_TYPE_VAR_STRING = 253;
    static final int FIELD_TYPE_STRING = 254;
    static final String[] errs = new String[]{"E0300 setReadDump()", "E0301 setWriteDump()", "E0302 setMultipleQuery()", "E0303 isMultipleQuery()", "E0304 getLastInsertID()"};
    private static jdbcMysqlBase self;
    private static Hashtable mysqlDefaults;
    private static jdbcMysqlDriver driver;
    private static int pdepth;
    private static jdbcMysqlDebug debug;
    static Hashtable cmds;
    static int xoid;
    boolean applet;

    jdbcMysqlBase(jdbcMysqlDriver jdbcMysqlDriver2) {
        Object object;
        self = this;
        driver = jdbcMysqlDriver2;
        mysqlDefaults = new Hashtable();
        debug = null;
        xoid = 0;
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            object = new Properties(System.getProperties());
            string = ((Properties)object).getProperty("user.name");
            string2 = ((Properties)object).getProperty("file.separator");
            string3 = ((Properties)object).getProperty("user.home");
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        mysqlDefaults.put("host", "localhost");
        mysqlDefaults.put("port", "3306");
        mysqlDefaults.put("db", "mysql");
        if (string != null) {
            mysqlDefaults.put("user", string);
        }
        mysqlDefaults.put("version", "1.0.0");
        mysqlDefaults.put("majorVersion", "1");
        mysqlDefaults.put("minorVersion", "0");
        mysqlDefaults.put("product", "twz1jdbcForMysql");
        mysqlDefaults.put("Copyright", "1997, 1998 by Terrence W. Zellers");
        if (bl && ".jdbcMysql.properties" != null && !this.append(".jdbcMysql.properties") && string3 != null && string2 != null) {
            this.append(String.valueOf(string3) + string2 + ".jdbcMysql.properties");
        }
        if ((object = (String)mysqlDefaults.get("debugFile")) != null) {
            debug = new jdbcMysqlDebug((String)object);
        }
        cmds = new Hashtable();
        cmds.put("insert", new Integer(101));
        cmds.put("replace", new Integer(112));
        cmds.put("update", new Integer(102));
        cmds.put("create", new Integer(104));
        cmds.put("delete", new Integer(103));
        cmds.put("alter", new Integer(106));
        cmds.put("drop", new Integer(105));
        cmds.put("lock", new Integer(107));
        cmds.put("unlock", new Integer(109));
        cmds.put("set", new Integer(110));
        cmds.put("grant", new Integer(111));
        cmds.put("select", new Integer(201));
        cmds.put("describe", new Integer(301));
        cmds.put("explain", new Integer(302));
        cmds.put("show", new Integer(304));
    }

    static int getOID() {
        return ++xoid;
    }

    private boolean append(String string) {
        String string2 = null;
        try {
            File file = new File(string);
            if (file.isFile() && file.canRead()) {
                String string3;
                String string4 = file.getCanonicalPath();
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                mysqlDefaults.remove("moreProperties");
                ++pdepth;
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    string3 = properties.getProperty(string5);
                    mysqlDefaults.put(string5, string3);
                }
                String string6 = new String("PropertyFile" + pdepth);
                mysqlDefaults.put(string6, string4);
                if (pdepth < 17) {
                    string3 = (String)mysqlDefaults.get("moreProperties");
                    if (string3 != null) {
                        this.append(string3);
                    }
                } else {
                    string2 = "Properties files depth limit.";
                }
                return true;
            }
            string2 = new String(String.valueOf(string) + " is not a readable file.");
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        if (string2 != null) {
            mysqlDefaults.put("Properties.error", string2);
        }
        return false;
    }

    static jdbcMysqlBase base() {
        return self;
    }

    static jdbcMysqlDebug getDebug() {
        return debug;
    }

    static jdbcMysqlDriver getDriver() {
        return driver;
    }

    static Hashtable copyDefaults() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = mysqlDefaults.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, (String)mysqlDefaults.get(string));
        }
        return hashtable;
    }

    static int getCommand(String string) {
        String string2 = string.toLowerCase();
        Integer n = (Integer)cmds.get(string2);
        if (n == null) {
            if (string2.charAt(0) == '#') {
                return 190;
            }
            if (string2.substring(0, 2).equals("/*")) {
                return 190;
            }
            return -1;
        }
        int n2 = n;
        return n2;
    }

    public static String[] getDefaultNames() {
        int n = mysqlDefaults.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = mysqlDefaults.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static String getDefault(String string) {
        return (String)mysqlDefaults.get(string);
    }

    public static void setReadDump(jdbcMysqlConnex jdbcMysqlConnex2, boolean bl) throws SQLException {
        try {
            if (!jdbcMysqlConnex2.open) {
                jdbcMysqlConnex2.errHandlerL(13, "setReadDump()");
            }
            jdbcMysqlBag jdbcMysqlBag2 = jdbcMysqlConnex2.inBag;
            jdbcMysqlBag2.dumpRead = bl;
            return;
        }
        catch (Exception exception) {
            self.errHandlerM(0, exception);
            return;
        }
    }

    public static void setWriteDump(jdbcMysqlConnex jdbcMysqlConnex2, boolean bl) throws SQLException {
        try {
            if (!jdbcMysqlConnex2.open) {
                jdbcMysqlConnex2.errHandlerL(13, "setWriteDump()");
            }
            jdbcMysqlBag jdbcMysqlBag2 = jdbcMysqlConnex2.outBag;
            jdbcMysqlBag2.dumpWrite = bl;
            return;
        }
        catch (Exception exception) {
            self.errHandlerM(1, exception);
            return;
        }
    }

    public static void setMultipleQuery(jdbcMysqlConnex jdbcMysqlConnex2, boolean bl) throws SQLException {
        try {
            if (!jdbcMysqlConnex2.open) {
                jdbcMysqlConnex2.errHandlerL(13, "setMultipleQueries()");
            }
            jdbcMysqlConnex2.multipleQueries = bl;
            return;
        }
        catch (Exception exception) {
            self.errHandlerM(2, exception);
            return;
        }
    }

    public static boolean isMultipleQuery(jdbcMysqlConnex jdbcMysqlConnex2) throws SQLException {
        boolean bl = true;
        try {
            if (!jdbcMysqlConnex2.open) {
                jdbcMysqlConnex2.errHandlerL(13, "isMultipleQuery");
            }
            bl = jdbcMysqlConnex2.multipleQueries;
        }
        catch (Exception exception) {
            self.errHandlerM(3, exception);
        }
        return bl;
    }

    public static long getLastInsertID(Statement statement) throws SQLException {
        try {
            return ((jdbcMysqlStmt)statement).lastInsertID;
        }
        catch (Exception exception) {
            self.errHandlerM(4, exception);
            return -1L;
        }
    }

    public static long getRowCount(Statement statement) throws SQLException {
        jdbcMysqlResult jdbcMysqlResult2 = ((jdbcMysqlStmt)statement).qResult;
        if (jdbcMysqlResult2 == null) {
            return -1L;
        }
        return jdbcMysqlResult2.realRowCount;
    }

    private void errHandlerP(int n, Exception exception) throws SQLException {
        this.errMessage(n, exception);
        this.errHandlerM(n, exception);
    }

    private void errHandlerS(int n, String string) throws SQLException {
        String string2 = String.valueOf(errs[n]) + string;
        this.debugMessage(string2);
        throw new SQLException(string2);
    }

    private void errHandlerM(int n, Exception exception) throws SQLException {
        String string = this.errMessage(n, exception);
        this.debugMessage(string);
        throw new SQLException(string);
    }

    private String errMessage(int n, Exception exception) {
        String string = exception.toString();
        String string2 = String.valueOf(errs[n]) + " - " + string;
        return string2;
    }

    private void debugMessage(String string) {
        jdbcMysqlDebug jdbcMysqlDebug2 = debug;
        if (jdbcMysqlDebug2 == null) {
            return;
        }
        jdbcMysqlDebug2.put(string);
    }

    static void errMessage(String string) throws SQLException {
        self.debugMessage(string);
        throw new SQLException(string);
    }

    static String eMessage(Exception exception) {
        if (exception == null) {
            return "";
        }
        String string = exception.getMessage();
        if (string == null) {
            string = "";
        }
        if (string.trim().equals("")) {
            string = "\n    " + exception.toString();
        } else if (string.charAt(0) != '\n') {
            string = "\n" + string;
        }
        return string;
    }

    static int boolValue(String string, int n, int n2) {
        if (string == null) {
            return n;
        }
        if (string.equalsIgnoreCase("true")) {
            return 1;
        }
        if (string.equalsIgnoreCase("t")) {
            return 1;
        }
        if (string.equalsIgnoreCase("yes")) {
            return 1;
        }
        if (string.equalsIgnoreCase("y")) {
            return 1;
        }
        if (string.equals("1")) {
            return 1;
        }
        if (string.equalsIgnoreCase("false")) {
            return 0;
        }
        if (string.equalsIgnoreCase("f")) {
            return 0;
        }
        if (string.equalsIgnoreCase("no")) {
            return 0;
        }
        if (string.equalsIgnoreCase("n")) {
            return 0;
        }
        if (string.equals("0")) {
            return 0;
        }
        return n2;
    }

    static int intValue(String string, int n, int n2) {
        if (string == null) {
            return n;
        }
        int n3 = n2;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n3;
    }
}

