/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlConnex;
import twz1.jdbc.mysql.jdbcMysqlDebug;
import twz1.jdbc.mysql.jdbcMysqlDumpBuffer;

final class jdbcMysqlBag {
    static final int DEFAULTBUFFERSIZE = 8192;
    static final int HEADERSIZE = 4;
    int capacity;
    int seq;
    int at;
    int maxAt;
    byte[] inside;
    byte[] fhead;
    BufferedInputStream bis;
    BufferedOutputStream bos;
    boolean dumpRead;
    boolean dumpWrite;
    jdbcMysqlConnex connex;
    boolean teeny;
    static final String[] errs = new String[]{"E0100 Placeholder.", "P0101 Input stream null in jdbcMysqlBag.read().", "E0102 Socket stream was closed in while read was incomplete.", "E0103 IO exception returned while reading socket -", "P0104 Data request beyonds limits of received data in iTob().", "P0105 Data request to read beyond max in bToI();", "E0106 A getZTbytes() requested beyond end of data.", "E0107 Error writing bag to socket.", "E0108 putZT(String) - ", "E0109 putZT(byte[]) - ", "E0110 getZTstring() - ", "E0111 newCapacity(int) - ", "E0112 read() - ", "E0113 getZTbytes() - ", "E0114 Data request beyond end of data in viToI().", "E0115 Error in viToI() -", "E0116 Error in nbToI() -", "E0117 In getNbytes() the requested size would exceed data.", "E0118 Error in getNbytes() - ", "E0119 Error in getNstring() - ", "E0120 putByteArray() - ", "E0121 Error in getRbytes() -", "E0122 Error in getRstring() -", "E0123 Numeric overflow() -"};

    jdbcMysqlBag() {
        this.capacity = 8196;
        this.init();
    }

    jdbcMysqlBag(int n) {
        this.capacity = n;
        this.init();
    }

    void init() {
        this.seq = 0;
        this.at = 0;
        this.maxAt = 0;
        this.bos = null;
        this.bis = null;
        this.dumpRead = false;
        this.dumpWrite = false;
        this.inside = null;
        if (this.capacity > 0) {
            this.inside = new byte[this.capacity];
        }
        this.fhead = new byte[4];
        this.teeny = false;
    }

    jdbcMysqlBag dataCopy() {
        jdbcMysqlBag jdbcMysqlBag2 = new jdbcMysqlBag(this.maxAt);
        jdbcMysqlBag2.maxAt = this.maxAt;
        jdbcMysqlBag2.at = 4;
        System.arraycopy(this.inside, 0, jdbcMysqlBag2.inside, 0, this.maxAt);
        return jdbcMysqlBag2;
    }

    void setInput(BufferedInputStream bufferedInputStream) {
        this.bis = bufferedInputStream;
    }

    void setOutput(BufferedOutputStream bufferedOutputStream) {
        this.bos = bufferedOutputStream;
    }

    void newWrite() {
        this.maxAt = 4;
        this.at = 4;
    }

    void newWrite(int n) {
        this.maxAt = 4;
        this.at = 4;
        this.seq = n;
    }

    void setSequence(int n) {
        this.seq = n;
    }

    int getSequence() {
        return this.seq;
    }

    int getPosition() {
        return this.at;
    }

    int getSize() {
        return this.maxAt - 4;
    }

    void setPosition(int n) {
        this.at = n;
    }

    void setReadDump(boolean bl) {
        this.dumpRead = bl;
    }

    void setWriteDump(boolean bl) {
        this.dumpWrite = bl;
    }

    int peekAbyte() {
        int n = this.inside[this.at];
        if (n < 0) {
            n += 256;
        }
        return n;
    }

    void testread() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        while (!bl) {
            try {
                if (this.bis.available() > 0) {
                    this.read();
                } else {
                    Thread.sleep(2000L);
                }
                if (this.bis.available() != 0) continue;
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void read() throws SQLException {
        if (this.bis == null) {
            throw new SQLException(errs[1]);
        }
        try {
            this.inside = this.fhead;
            this.capacity = 4;
            this.at = 0;
            this.readSome(4);
            this.maxAt = 4;
            this.at = 0;
            int n = this.bToI(3);
            this.seq = this.bToI(1);
            this.newCapacity(n);
            this.readSome(n);
            this.maxAt = n + 4;
            if (this.dumpRead) {
                this.dump("data read ...");
            }
            this.at = 4;
            return;
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[12]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    private void readSome(int n) throws SQLException {
        int n2 = n;
        try {
            while (n2 > 0) {
                int n3 = this.bis.read(this.inside, this.at, n2);
                if (n3 < 0) {
                    throw new SQLException(errs[2]);
                }
                this.at += n3;
                n2 -= n3;
            }
            return;
        }
        catch (IOException iOException) {
            if (this.connex != null) {
                this.connex.broken = true;
            }
            String string = String.valueOf(errs[3]) + iOException;
            this.dump(string);
            throw new SQLException(string);
        }
    }

    private void newCapacity(int n) throws SQLException {
        try {
            byte[] byArray = new byte[n + 4];
            System.arraycopy(this.inside, 0, byArray, 0, this.at);
            this.inside = byArray;
            this.capacity = this.inside.length;
            return;
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[11]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    void write() throws SQLException {
        try {
            this.at = 0;
            this.iToB(this.maxAt - 4, 3);
            this.iToB(this.seq, 1);
            if (this.dumpWrite) {
                this.dump("writing...");
            }
            this.bos.write(this.inside, 0, this.maxAt);
            this.bos.flush();
            return;
        }
        catch (Exception exception) {
            if (this.connex != null) {
                this.connex.broken = true;
            }
            String string = String.valueOf(errs[7]) + exception;
            this.dump(string);
            throw new SQLException(string);
        }
    }

    void putByte(byte by) throws SQLException {
        try {
            while (this.maxAt + 1 > this.capacity) {
                this.newCapacity(this.capacity + 8192);
            }
            this.inside[this.at++] = by;
            if (this.at > this.maxAt) {
                this.maxAt = this.at;
                return;
            }
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[20]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    void putByteArray(byte[] byArray, int n) throws SQLException {
        int n2;
        if (n < 0) {
            n2 = byArray.length;
        } else {
            int n3 = n2 = byArray.length < n ? byArray.length : n;
        }
        if (n2 == 0) {
            return;
        }
        try {
            while (this.maxAt + n2 > this.capacity) {
                this.newCapacity(this.capacity + n2 + 8192);
            }
            System.arraycopy(byArray, 0, this.inside, this.at, n2);
            this.at += n2;
            if (this.at > this.maxAt) {
                this.maxAt = this.at;
                return;
            }
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[20]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    void putZT(byte[] byArray) throws SQLException {
        try {
            while (this.maxAt + byArray.length + 1 > this.capacity) {
                this.newCapacity(this.capacity + byArray.length + 8192);
            }
            System.arraycopy(byArray, 0, this.inside, this.at, byArray.length);
            this.at += byArray.length;
            this.inside[this.at++] = 0;
            if (this.at > this.maxAt) {
                this.maxAt = this.at;
                return;
            }
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[9]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    void putZT(String string) throws SQLException {
        try {
            byte[] byArray = string.getBytes();
            this.putZT(byArray);
            return;
        }
        catch (Exception exception) {
            String string2 = String.valueOf(errs[8]) + exception;
            this.debugMessage(string2);
            throw new SQLException(string2);
        }
    }

    String getNstring(int n) throws SQLException {
        try {
            byte[] byArray = this.getNbytes(n);
            return new String(byArray);
        }
        catch (Exception exception) {
            this.errHandlerM(errs[19], exception);
            return null;
        }
    }

    byte[] getNbytes(int n) throws SQLException {
        int n2 = this.at + n;
        if (n2 > this.maxAt) {
            String string = errs[17];
            this.dump(string);
            throw new SQLException(string);
        }
        try {
            byte[] byArray = new byte[n];
            System.arraycopy(this.inside, this.at, byArray, 0, n);
            this.at = n2;
            return byArray;
        }
        catch (Exception exception) {
            this.errHandlerM(errs[18], exception);
            return null;
        }
    }

    byte[] getRbytes() throws SQLException {
        int n = this.maxAt - this.at;
        if (n < 1) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = this.getNbytes(n);
        }
        catch (Exception exception) {
            this.errHandlerM(errs[21], exception);
        }
        return byArray;
    }

    String getRstring() throws SQLException {
        int n = this.maxAt - this.at;
        if (n < 1) {
            return null;
        }
        String string = null;
        try {
            string = this.getNstring(n);
        }
        catch (Exception exception) {
            this.errHandlerM(errs[22], exception);
        }
        return string;
    }

    String getZTstring() throws SQLException {
        try {
            byte[] byArray = this.getZTbytes();
            if (byArray == null) {
                return "";
            }
            return new String(byArray);
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[10]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    byte[] getZTbytes() throws SQLException {
        if (this.at >= this.maxAt) {
            String string = errs[6];
            this.dump(string);
            throw new SQLException(string);
        }
        try {
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = this.at;
            while (!bl) {
                if (n2 >= this.maxAt) {
                    bl = true;
                    bl2 = true;
                } else if (this.inside[n2] == 0) {
                    bl = true;
                }
                if (!bl) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                if (!bl2) {
                    ++this.at;
                }
                return null;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.inside, this.at, byArray, 0, n);
            this.at += n + 1;
            if (bl2) {
                --this.at;
            }
            return byArray;
        }
        catch (Exception exception) {
            String string = String.valueOf(errs[13]) + exception;
            this.debugMessage(string);
            throw new SQLException(string);
        }
    }

    int viToI() throws SQLException {
        int n = this.bToI(1);
        return this.xnToI(n);
    }

    int xToI() throws SQLException {
        int n = this.bToI(1);
        if (n == 251) {
            return -1;
        }
        return this.xnToI(n);
    }

    private int xnToI(int n) throws SQLException {
        try {
            switch (n) {
                case 251: {
                    return 0;
                }
                case 252: {
                    return this.bToI(2);
                }
                case 253: {
                    return this.bToI(3);
                }
                case 254: {
                    long l;
                    if (this.teeny) {
                        l = this.bToL(4);
                        if (this.at > this.maxAt) {
                            String string = errs[14];
                            this.dump(string);
                            throw new SQLException(string);
                        }
                    } else {
                        l = this.bToL(8);
                    }
                    if (l > Integer.MAX_VALUE) {
                        String string = errs[23];
                        this.dump(string);
                        throw new SQLException(string);
                    }
                    return (int)l;
                }
            }
            return n;
        }
        catch (Exception exception) {
            this.errHandlerM(errs[15], exception);
            return n;
        }
    }

    int nbToI() throws SQLException {
        try {
            int n = this.bToI(1);
            return this.bToI(n);
        }
        catch (Exception exception) {
            this.errHandlerM(errs[16], exception);
            return 0;
        }
    }

    int bToI(int n) throws SQLException {
        int n2 = this.at + n - 1;
        int n3 = 0;
        while (n2 >= this.at) {
            int n4 = this.inside[n2];
            n3 <<= 8;
            n3 |= (n4 &= 0xFF);
            --n2;
        }
        this.at += n;
        if (this.at > this.maxAt) {
            throw new SQLException(errs[5]);
        }
        return n3;
    }

    long bToL(int n) throws SQLException {
        int n2 = this.at + n - 1;
        long l = 0L;
        while (n2 >= this.at) {
            int n3 = this.inside[n2];
            l <<= 8;
            l |= (long)(n3 &= 0xFF);
            --n2;
        }
        this.at += n;
        if (this.at > this.maxAt) {
            throw new SQLException(errs[5]);
        }
        return l;
    }

    long viToL() throws SQLException {
        int n = this.bToI(1);
        return this.xnToL(n);
    }

    long xToI_L() throws SQLException {
        int n = this.bToI(1);
        if (n == 251) {
            return -1L;
        }
        return this.xnToL(n);
    }

    private long xnToL(int n) throws SQLException {
        try {
            switch (n) {
                case 251: {
                    return 0L;
                }
                case 252: {
                    return this.bToL(2);
                }
                case 253: {
                    return this.bToL(3);
                }
                case 254: {
                    long l;
                    if (this.teeny) {
                        l = this.bToL(4);
                        if (this.at > this.maxAt) {
                            String string = errs[14];
                            this.dump(string);
                            throw new SQLException(string);
                        }
                    } else {
                        l = this.bToL(8);
                    }
                    return l;
                }
            }
            return n;
        }
        catch (Exception exception) {
            this.errHandlerM(errs[15], exception);
            return n;
        }
    }

    void iToB(int n, int n2) throws SQLException {
        int n3 = this.at + n2;
        if (n3 > this.capacity) {
            this.newCapacity(n3 + 8192);
        }
        int n4 = n;
        int n5 = n2;
        while (n5 > 0) {
            n3 = n4 & 0xFF;
            n4 >>= 8;
            if (n3 > 127) {
                n3 -= 256;
            }
            this.inside[this.at++] = (byte)n3;
            --n5;
        }
        if (this.at > this.maxAt) {
            this.maxAt = this.at;
        }
    }

    private void errHandlerM(String string, Exception exception) throws SQLException {
        String string2 = String.valueOf(string) + "\n" + exception.getMessage();
        this.dump(string2);
        throw new SQLException(string2);
    }

    private void errHandlerD(String string) throws SQLException {
        this.dump(string);
        throw new SQLException(string);
    }

    private void errHandler(String string) throws SQLException {
        this.debugMessage(string);
        throw new SQLException(string);
    }

    void debugMessage(String string) {
        jdbcMysqlDebug jdbcMysqlDebug2 = jdbcMysqlBase.getDebug();
        if (jdbcMysqlDebug2 == null) {
            return;
        }
        jdbcMysqlDebug2.put(string);
        jdbcMysqlDebug2.guard.synch(jdbcMysqlDebug2.myOID, true, 120);
        if (jdbcMysqlDebug2.dfile != null) {
            jdbcMysqlDebug2.dfile.close();
            jdbcMysqlDebug2.open();
        }
        jdbcMysqlDebug2.guard.synch(jdbcMysqlDebug2.myOID, false, 120);
    }

    void dump(String string) {
        jdbcMysqlDebug jdbcMysqlDebug2 = jdbcMysqlBase.getDebug();
        if (jdbcMysqlDebug2 == null) {
            return;
        }
        jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer2 = new jdbcMysqlDumpBuffer();
        jdbcMysqlDumpBuffer2.dumpBuffer.addElement(" ");
        jdbcMysqlDumpBuffer2.dumpBuffer.addElement(string);
        String string2 = "Capacity " + this.capacity + "   maxAt " + this.maxAt + "   at " + this.at + "   seq " + this.seq;
        jdbcMysqlDumpBuffer2.dumpBuffer.addElement(string2);
        jdbcMysqlDebug2.dump(this.inside, 0, this.maxAt, jdbcMysqlDumpBuffer2);
        jdbcMysqlDebug2.put(jdbcMysqlDumpBuffer2);
    }
}

