#!/usr/bin/perl -w

my $STK_READONLY_WARNING = ";;
;; WARNING WARNING WARNING!
;;
;; DO NOT edit this file. It is generated automatically.
;; Any changes made here WILL be overwritten!
;;";

use Getopt::Long;
# use diagnostics;
use strict;

$0 =~ s/.*\///;

my $api_prefix = 'mysql';
my $lib_name = '';
my $fileno = 0;
my $file = $ARGV[$fileno];
my $func_type;
my $n_functions = -1;
my $return_id;
my $nargs;
my @arg_name;
my @arg_type;
my $file_prefix = '';
my %arg_signature = ();
my %rtn_signature = ();
my %arg_signature_name = ();
my %rtn_signature_name = ();
my $n_arg_signatures = 0;
my $n_rtn_signatures = 0;
my %arg_struct_printed = ();
my %rtn_struct_printed = ();
my $max_function_name_length = 0;
my $stk = 1;
my $optional_args_string = '-maybe-more-args-BLAHBLAH';
my $api_wanted = 'STDCALL';                   # The API marker to look for in function definitions.
my $last_arg_len_marker = 'STK_LAST_ARG_LEN'; # The API arg name marker to use the string length of the last arg for this arg.
my $ignoring = 0;
my $debug = 0;

# Functions that take a ? at the end of their name.
my %interrogation = ();

my %stk_arg_type =
(
 'char'                             => ':char',
 'unsigned char'                    => ':char',  # Note: the STk interface does not have :uchar
 'short'                            => ':short',
 'unsigned short'                   => ':short',
 'int'                              => ':int',
 'uint'                             => ':uint',
 'unsigned int'                     => ':uint',
 'long'                             => ':long',
 'unsigned long'                    => ':ulong',
 'ulong'                            => ':ulong',
 'ulong *'                          => ':static-ptr',
 'float'                            => ':float',
 'double'                           => ':double',
 'void'                             => ':void',
 'char *'                           => ':string',
 'const char *'                     => ':string',
 'MYSQL *'                          => ':static-ptr',
 'MYSQL_ROW'                        => ':static-ptr',
 'MYSQL_ROW *'                      => ':static-ptr',
 'MYSQL_RES *'                      => ':static-ptr',
 'MYSQL_FIELD_OFFSET'               => ':uint',
 'MYSQL_ROW_OFFSET'                 => ':static-ptr',
 'enum mysql_option'                => ':int',
 );

my %stk_return_type =
(
 'void'                             => ':void',
 'char'                             => ':char',
 'unsigned char'                    => ':char',  # Note: the STk interface does not have :uchar
 'short'                            => ':short',
 'unsigned short'                   => ':short',
 'int'                              => ':int',
 'uint'                             => ':uint',
 'unsigned int'                     => ':uint',
 'long'                             => ':long',
 'ulong'                            => ':ulong',
 'ulong *'                          => ':static-ptr',
 'unsigned long'                    => ':ulong',
 'my_ulonglong'                     => ':ulong',
 'float'                            => ':float',
 'double'                           => ':double',
 'char *'                           => ':static-ptr',
 'DYNAMIC_STR'                      => ':dynamic-ptr',
 'MYSQL *'                          => ':static-ptr',
 'MYSQL_ROW'                        => ':static-ptr',
 'MYSQL_ROW *'                      => ':static-ptr',
 'MYSQL_ROWS *'                     => ':static-ptr',
 'MYSQL_RES *'                      => ':static-ptr',
 'MYSQL_FIELD *'                    => ':static-ptr',
 'MYSQL_FIELD_OFFSET'               => ':uint',
 'MYSQL_ROW_OFFSET'                 => ':static-ptr',
 'my_bool'                          => ':char',
 );


&GetOptions("debug!"                => \$debug,
	    "lib=s"                 => \$lib_name);

if ($Getopt::Long::error){
    print STDERR "Usage: $0 [-debug] filenames...\n";
    exit(1)
}

print "$STK_READONLY_WARNING\n\n";

while (<>){

    my $line = $_;
    my $ok = 0;
    my $i;

    if (eof){
	# Next read will eof.
	close(ARGV); # Reset $. and $file on change of filename. Is this one line early?
	$file = $ARGV[$fileno]; # Fileno is never incremented! (yet this seems to work).
	# print "Now processing file $file (fileno $fileno).\n"
    }

    if ($ignoring){
	if ($line =~ /^\s*\#if/){
	    $ignoring++;
	}
	elsif ($line =~ /^\s*\#endif/){
	    $ignoring--;
	}
    }
    elsif ($line =~ /^\s*\#if\s+0\s*$/ || $line =~ /^\s*\#ifn?def\s+LONG_LONG_SUPPORTED\s*$/){
	$ignoring++;
    }

    next if $ignoring;
    
    if ($line =~ /^(.*)\s+$api_wanted\s*$/){
	$ok = 1;
	$func_type = $1;
	$nargs = 0;
    }

    next unless $ok;
    
    $func_type =~ s/^\s*//;
    $func_type =~ s/\s*$//;

    # Get and process the function name and args.
    $line = <>;

    die "$0: Bad function definition line (number $.) found in $file.\n$0: Line was '$line'.\n" unless
	$line =~ /^\s*([^ \t\(]+)\s*\((.*)/;
	
    my $c_func = $1;
    my $arg_spec = $2;

    while ($arg_spec !~ /\)\s*$/){
	$arg_spec .= <>;
    }

    $arg_spec =~ s/\)\s*$//;

    my @args = split(/\s*,\s*/, $arg_spec);
    $nargs = 0;
    my $arg;

    foreach $arg (@args){

	my @x = split(/\s+/, $arg);
	my $n = $#x + 1;
	my $type = $x[0];

	for ($i = 1; $i < $n-1; $i++){
	    $type .= ' ' .$x[$i];
	}

	if ($x[$n - 1] =~ /(\*+)(.*)/){
	    $type .= ' ' . $1;
	    $x[$n - 1] = $2;
	}

	$type =~ s/\s*$//;

	$arg_type[$nargs] = $type;
	$arg_name[$nargs] = ($type eq '...') ? '' : $x[$n - 1];
	$nargs++;
    }

    $n_functions++;


    # STk foreign function interface processing.
    if ($stk){

	my $type_error = 0;
	my $string_wrap = 0; # If true, wrap the function in c-string->string.
	my $length_wrap = 0; # If true, we'll wrap and do auto length calculation on args.

	if (!exists $stk_return_type{$func_type}){
	    print STDERR "$0: stk return type undefined for C type '$func_type'. Stubbing '$c_func'.\n";
	    $type_error = 1;
	}

	if ($nargs == 1 && $arg_type[0] eq 'void'){
	    # Ignore single void args (i.e., no args).
	    $nargs = 0;
	}

	# Check that we know about all arg types.
	for ($i = 0; $i < $nargs; $i++){
	    if ($arg_type[$i] ne '...' && !exists $stk_arg_type{$arg_type[$i]}){
		print STDERR "$0: stk arg type undefined for C type '$arg_type[$i]'. Stubbing '$c_func'.\n";
		$type_error = 1;
	    }
	    
	    if ($arg_name[$i] eq $last_arg_len_marker && $i > 0){
		$length_wrap = 1;
	    }

	}

	my $stk_func = $c_func;
	$stk_func =~ s/($api_prefix)_/$1:/;
        $stk_func =~ tr/_/-/;
	$stk_func .= '?' if exists $interrogation{$c_func};

        if ($type_error){
	    printf "(define %s (lambda () (format (current-error-port) \"You have managed to call an STk stub function (%s) for an Avs API function (%s) that is not currently available due to limited type support in the STk foreign function interface. I'm trying to get this fixed. Please feel free to bug me.~%%\") #f))\n\n", $stk_func, $stk_func, $c_func;
	    next;
	}

	if ($func_type eq 'char *' || $func_type eq 'DYNAMIC_STR'){
	    $string_wrap = 1;
	}

	# We understand all arg types, and the return type. Emit the foreign function definition.

	printf "(define-external %s (%s", ($string_wrap || $length_wrap) ? $c_func : $stk_func, $nargs ? "\n" : '';

	for ($i = 0; $i < $nargs; $i++){
	    if ($arg_type[$i] eq '...'){
		printf "\t. %d", $i - 1;
	    }
	    else {
		printf "\t(%s %s)", $arg_name[$i], $stk_arg_type{$arg_type[$i]};
	    }

	    print "\n" unless $i == $nargs - 1;
	}

	printf ")\n  :return-type %s\n  :entry-name \"%s\"\n  :library-name \"%s\")\n\n",
	    $stk_return_type{$func_type}, $c_func, $lib_name;

	if ($string_wrap || $length_wrap){
	    my $opt_args = 0;
	    #
	    # Now define the actual STk function that will be used.
	    # This will break if there is already an argument called $optional_args_string.
	    # We should really check for it, but the collision probability is low
	    # and the effect will be obvious and not kill anyone...
	    #
	    printf "(define %s\n  (lambda (", $stk_func;

	    for ($i = 0; $i < $nargs; $i++){
		if ($arg_name[$i] eq $last_arg_len_marker && $i > 0){
		    # This arg is omitted in the STk interface.
		}
		elsif ($arg_type[$i] eq '...'){
		    printf ". %s", $optional_args_string;
		    $opt_args = 1;
		}
		else {
		    printf "%s", $arg_name[$i];
		}

		print " " unless $i == $nargs - 1;
	    }

	    printf ")\n";

	    if ($string_wrap){
		printf "    (let ((result (%s%s ", $opt_args ? 'apply ' : '', $c_func;

		for ($i = 0; $i < $nargs; $i++){
		    if ($arg_name[$i] eq $last_arg_len_marker && $i > 0){
			# Send the length of the previous argument.
			printf "(string-length %s)", $arg_name[$i - 1];
		    }
		    elsif ($arg_type[$i] eq '...'){
			print $optional_args_string;
		    }
		    else {
			printf "%s", $arg_name[$i];
		    }

		    print " " unless $i == $nargs - 1;
		}
	    
		print ")))
      (if result
          (c-string->string result)
          \#f))))\n\n";
	    }
	    else {
		printf "    (%s%s ", $opt_args ? 'apply ' : '', $c_func;
		
		for ($i = 0; $i < $nargs; $i++){
		    if ($arg_name[$i] eq $last_arg_len_marker && $i > 0){
			# Send the length of the previous argument.
			printf "(string-length %s)", $arg_name[$i - 1];
		    }
		    elsif ($arg_type[$i] eq '...'){
			print $optional_args_string;
		    }
		    else {
			printf "%s", $arg_name[$i];
		    }

		    print " " unless $i == $nargs - 1;
		}
	    
		print ")))\n";
	    }
	}
    }
}

exit(0);
