#!/bin/sh
# A script connecting to mysql's db table. This is just to show how
# you can specify the field setup by listing the columns
# You just need to change the database and table names and the list
# of columns if you want to connect to another test table

# The following nonsense is required because mysqlwish dumps core when 
# SQLDBTYPE is ODBC, reason unknown.
# The following lines are executed by sh, not by wish because of the
# backslashes... Puke loudly
#\
case "A$SQLDBTYPE" in 
#\
  A|AMYSQL) exec /usr/local/bin/mysqlwish "$0" "$@";;
#\
*) exec wish "$0" "$@";; 
#\
esac

package require sqlsc

# Things that you may want to change
set username ""
set hostname ""
set password ""
catch {set username $env(SQLSCUSER)}
catch {set hostname $env(SQLSCHOST)}
catch {set password $env(SQLSCPASSWORD)}

set dbname mysql
set table db

catch {unset env(CDKITDB)}

if {$argc != 0} {
    puts "Usage: mysqldb.tcl"
    exit 1
}

# Create Quit button
button .quit -text quit -command exit
pack .quit -side top -expand yes -fill x

# Create screen
set ${table}(window)   .$table
set ${table}(database) $dbname
set ${table}(table)    $table
set ${table}(allowdelete) ""
# No need to set the next 3 if you're connecting to the local host and
# don't need user name or passwd
set ${table}(sqlschost) $hostname
set ${table}(sqlscuser) $username
set ${table}(sqlscpasswd) $password

set ${table}(columns) {
    host \n
    user db \n
    select_priv insert_priv update_priv \n
    delete_priv create_priv drop_priv
}

puts "Connecting to $hostname, db $dbname, table $table as $username"

sqlscreen ${table}

pack .${table} -side top -expand 1 -fill x
