#!/usr/local/bin/perl

# sql.cgi - SQL/HTML Interface [199903171002]
#           Copyright(c) 1999, Jonathan A. Zdziarski
#           All Rights Reserved

use DBI;
use SDBM_File;
use Fcntl qw (/^O_/);

## Configuration Options
#
$CONFIG{'DATA'} = ".";        # Location of data files
$CONFIG{'HOST'} = "";         # Hostname of SQL Server, or blank for localhost
$CONFIG{'USER'} = "";         # Username for SQL, or blank for none
$CONFIG{'PASS'} = "";         # Password for SQL, or blank for none
$CONFIG{'PORT'} = "";         # SQL Port, or blank to exclude
$CONFIG{'OPTIONS'}="";        # SQL Options, or blank for none
#
## End Configuration Options

%FORM = &ReadParse;
if ($FORM{'database'} eq "") {
  $FORM{'username'} = $ENV{'REMOTE_USER'};

  srand($$|time);
  my($SESSION) = int(rand(60000));
  $SESSION = unpack("H*", pack("Nnn", time, $$, $SESSION));
  open(FILE, ">$CONFIG{'DATA'}/auth/AUTH$SESSION.dat");
  print FILE "$ENV{'REMOTE_USER'}\n";
  close(FILE);
  $FORM{'password'} = "AUTH$SESSION";

  &WriteHTML("index.html");
}
$ENV{'REMOTE_USER'} = $FORM{'username'};

# Authorize that the user has permission to view the database
open(FILE, "<$CONFIG{'DATA'}/auth/$FORM{'password'}.dat");
my($LINE) = <FILE>;
close(FILE);
chomp $LINE;
if ($LINE ne $ENV{'REMOTE_USER'}) {
  &WriteHTML("error.html", "This auth cookie ($FORM{'password'}) has expired.  Log in again.");
}

my($USERNAME, $PAIRS);
open(FILE, "<$CONFIG{'DATA'}/etc/users");
while(<FILE>) {
  ($USERNAME, $PAIRS) = split(/\:/);
  last if ($USERNAME eq $FORM{'username'});
}
close(FILE);
if ($USERNAME ne $FORM{'username'}) { 
  &WriteHTML("error.html", "User '$ENV{'REMOTE_USER'}' is not authorized to " .
             "access this database");
}

my(@PAIRS) = split(/\,/, $PAIRS);
my($AUTH) = 0;
foreach(@PAIRS) {
  if (/^$FORM{'database'}\.(look|touch)$/) {
    $CONFIG{'ACCESS'} = $1;
    $AUTH = 1;
  } 
}
&WriteHTML("error.html", "User '$ENV{'REMOTE_USER'}' is not authorized to " .
           "access this database") unless ($AUTH);


## Put together the CONNECT sequence
#
$CONFIG{'CONNECT'} = "dbi:mysql:dbname=$FORM{'database'}";
$CONFIG{'CONNECT'} .= ";host=$CONFIG{'HOST'}" if ($CONFIG{'HOST'});
$CONFIG{'CONNECT'} .= ";port=$CONFIG{'PORT'}" if ($CONFIG{'PORT'});
$CONFIG{'CONNECT'} .= ";options=$CONFIG{'OPTIONS'}" if ($CONFIG{'OPTIONS'});
#
##

if ($FORM{'command'} eq "") {
  &list(1);
  exit;
}

sub list {
  my($connect) = $_;
  my($TABLE);
  if ($FORM{'table'} eq "") {
    my($DBH) = &connect if ($connect); 
    my(@TABLES) = $DBH->func('_ListTables');
    foreach(@TABLES) { 
      $TABLE .= qq!<INPUT TYPE=RADIO NAME=table VALUE="$_">$_<BR>\n!; 
    }
    $DBH->disconnect;
    &WriteHTML("tables.html", $TABLE);
  }
  else {
    my($DBH) = &connect;
    my(@STH) = &getfields($DBH);
    $TABLE = "<TR>";
    my($FIELD1);
    my(%VIEW);
    tie %VIEW, SDBM_File::, "$CONFIG{'DATA'}/etc/view", O_RDONLY, 0644;
    my(@VIEWS) = split(/\,/, $VIEW{"$ENV{'REMOTE_USER'}:$FORM{'database'}:$FORM{'table'}"});
    my(@VIEWS2) = @VIEWS;
    untie %VIEW;
    my(%REF, %XREF);
    my($SELECT) = "";
    my($SKIP) =0;
    my($x)=1; foreach(@STH) {
      my($V);
      if ($x==1) { $FIELD1 = $_; $SELECT .= "$_";}
      if ($x>1) { $V = shift(@VIEWS); }
      my($OD) = $_; $OD =~ s/ /\+/g; $OD =~ s/&/\%26/g;
      do {
      $SELECT .= ", $_" unless ($x==1);
      $TABLE .= qq!<TD><B><NOBR><A HREF="sql.cgi?database=$FORM{'database'}&!.
        qq!table=$FORM{'table'}&username=$FORM{'username'}&password=!.
        qq!$FORM{'password'}&orderby=$OD">$_</A>&nbsp;&nbsp;</NOBR></B></TD>!
      } unless (($x>1) && ($V eq "-")); 
      if (($x>1) && ($V eq "-")) { $SKIP = 1; }
      $REF{$x}=$_;
      $x++;
    }
    $SELECT = "*" if (! $SKIP);
    $TABLE .= "</TR>";
    (%XREF) = &getxref;
    my($ORDER) = 1; if ($FORM{'orderby'}) { $ORDER = $FORM{'orderby'}; }
    my($CMD) = "SELECT $SELECT FROM $FORM{'table'} ORDER BY $ORDER";
    $STH = $DBH->prepare($CMD);
    my($RET) = $STH->execute;
    if ($RET) {
      my($ary_ref);
      while($ary_ref = $STH->fetchrow_arrayref) {
        my(@a) = @$ary_ref;
        my($ITEM) = shift(@a);
        my($ITEMNAME) = $ITEM;
        my(@DISPLAY);
        my($x) = 2;
        my(@VIEWS) = @VIEWS2;
        foreach(@a) {
          my($V) = shift(@VIEWS);
          while($V eq "-") { $V = shift(@VIEWS); $x++; }
          if ($XREF{$REF{$x}} ne "") {
            my($DB, $TABLE) = split(/\:/, $XREF{$REF{$x}});
            $DB =~ s/ /\+/g;
            $DB =~ s/&/%26/g;
            $TABLE =~ s/ /\+/g;
            $TABLE =~ s/&/%26/g;
            my($IT) = $_; 
            $IT =~ s/ /\+/g;
            $IT =~ s/&/%26/g;
            my($LINE) = qq!<A HREF="sql.cgi?command=display&username!.
            qq!=$FORM{'username'}&password=$FORM{'password'}&database=! .
            qq!$DB&table=$TABLE&id=$IT">$_</A>!;
            $_ = $LINE;
          }
          push(@DISPLAY, $_);
          $x++;
        }
        $ITEM =~ s/ /\+/g;
        $ITEM =~ s/&/%26/g;
        $TABLE .= qq!\n<TR><TD><NOBR><A HREF="sql.cgi?command=display&! .
                  qq!username=$FORM{'username'}&password=$FORM{'password'}! .
                  qq!&database=$FORM{'database'}&table=$FORM{'table'}! .
                  qq!&id=$ITEM\">$ITEMNAME</A></NOBR></TD><TD><NOBR>! .
                  join("&nbsp;</NOBR></TD><TD><NOBR>&nbsp;", @DISPLAY);
        $FIELD1 =~ s/ /\+/g;
        $FIELD1 =~ s/&/%26/g;
        $TABLE .= qq!</NOBR></TD><TD>&nbsp;&nbsp;! .
                  qq!<NOBR><A HREF="sql.cgi?command=delete&! .
                  qq!database=$FORM{'database'}&table=$FORM{'table'}! .
                  qq!&id=$ITEM&delete=on&field=$FIELD1&username=! .
                  qq!$FORM{'username'}&password=$FORM{'password'}">DELETE</A> |! .
                  qq!<A HREF="sql.cgi?command=edit&database=! .
                  qq!$FORM{'database'}&table=$FORM{'table'}&id=$ITEM&modify! .
                qq!=on&field=$FIELD1&password=$FORM{'password'}&username=! .
                qq!$FORM{'username'}">MODIFY</A></NOBR></TD></TR>!;
      }
    }
    else { &WriteHTML("error.html", "$CMD<BR>$DBI::errstr"); }
    $STH->finish;
    $DBH->disconnect;
    &WriteHTML("list.html", $TABLE);
  }
  exit;
}

if ($FORM{'command'} eq "display") {
  my($TABLE, %REF, %XREF);
  my($DBH) = &connect;
  my(@STH) = &getfields($DBH);
  my(@ITEMS, $FIELD);
  $FIELD = $STH[0];
  @ITEMS = @STH;
  my($x) = 1;
  foreach(@STH) {
    $REF{$x}=$_;
    $x++;
  }
  (%XREF) = &getxref;
  my($CMD) = "SELECT * FROM $FORM{'table'} WHERE $FIELD = '$FORM{'id'}'";
  $STH = $DBH->prepare($CMD);
  my($RET) = $STH->execute;
  if ($RET) {
    my($ary_ref);
    if ($ary_ref = $STH->fetchrow_arrayref) {
      my($x)=1;
      foreach(@$ary_ref) {
        my($F) = shift(@ITEMS);
        if ($XREF{$REF{$x}} ne "") {
          my($DB, $TABLE) = split(/\:/, $XREF{$REF{$x}});
          $DB =~ s/ /\+/g;
          $DB =~ s/&/%26/g;
          $TABLE =~ s/ /\+/g;
          $TABLE =~ s/&/%26/g;
          my($IT) = $_; 
          $IT =~ s/ /\+/g;
          $IT =~ s/&/%26/g;
          my($LINE) = qq!<A HREF="sql.cgi?command=display&username!.
          qq!=$FORM{'username'}&password=$FORM{'password'}&database=! .
          qq!$DB&table=$TABLE&id=$IT">$_</A>!;
          $_ = $LINE;
        }
        $TABLE .= "\n<TR><TD><B>$F:&nbsp;&nbsp;</B></TD><TD>$_</TD></TR>";
        $x++;
      }
    }
  }
  $STH->finish;
  $DBH->disconnect;
  &WriteHTML("display.html", $TABLE);
}

if ($FORM{'command'} eq "add") {
  if ($CONFIG{'ACCESS'} ne "touch") { 
    &WriteHTML("error.html", "ACCESS DENIED");
  }
  my($TABLE);
  if ($FORM{'add'} eq "") {
    my($DBH) = &connect;
    my(@STH) = &getfields($DBH);
    $TABLE = "<TR>";
    my($x) = 1;
    foreach(@STH) { 
      $TABLE .= "<TD>$_</TD><TD><INPUT NAME=\"SQL$x\"></TD></TR><BR>";
      $x++;
    }
    $DBH->disconnect;
    $FORM{'add'} = 1;
    &WriteHTML("add.html", $TABLE);
  }
  else {
    my($DBH) = &connect;

    # Make sure the first field is unique
    my(@STH) = &getfields($DBH);
    my($FIELD)=$STH[0];
    my($CMD) = "SELECT * FROM $FORM{'table'} WHERE $FIELD = '$FORM{'SQL1'}'";
    $STH = $DBH->prepare($CMD);
    my($RET) = $STH->execute;
    if ($RET) {
      my($ary_ref);
      if ($ary_ref = $STH->fetchrow_arrayref) {
        foreach(@$ary_ref) {
          &WriteHTML("error.html", "A record with the unique identifier " .
                     "'$_' already exists");
        }
      }
    }
    $STH->finish;
    my(@STH) = &getfields($DBH);
    my($CMD) = "INSERT INTO $FORM{'table'}\n    VALUES (";
    my($x) = 1; 
    foreach(@STH) {
      if ($FORM{"SQL$x"} !~ /^\d+$/) {
        $CMD .= "'" . $FORM{"SQL$x"} . "', ";
      }
      else { $CMD .= $FORM{"SQL$x"} . ", "; }
      $x++;
    }
    $CMD =~ s/, $//;
    $CMD .= ")";
    $STH = $DBH->prepare($CMD);
    my($RET) = $STH->execute;
#    $DBH->disconnect;
    my($ER) = $DBI::errstr;
    if ($RET) { 
      $STH->finish;
      &list(0);
      #&WriteHTML("done.html", "COMMAND: $CMD SUCCESSFUL");
    }
    else { 
      $DBH->disconnect;
      &WriteHTML("error.html", "UNABLE TO SEND COMMAND: $CMD: $ER");
    } 
  }
}

if ($FORM{'command'} eq "delete") {
  if ($CONFIG{'ACCESS'} ne "touch") { 
    &WriteHTML("error.html", "ACCESS DENIED");
  }

  my($MESSAGE);
  my($DBH) = &connect;
  my($CMD) = qq!DELETE FROM $FORM{'table'} WHERE $FORM{'field'} ! .
             qq!= '$FORM{'id'}'!;
  my($STH) = $DBH->prepare($CMD);
  my($RET) = $STH->execute;
  $STH->finish;
#  $DBH->disconnect;
  if ($RET) { &list(0); } 
#&WriteHTML("done.html", "Record $FORM{'id'} deleted"); }
  else {
    $DBH->disconnect;
    &WriteHTML("error.html", "UNSUCCESSFUL Delete of $FORM{'id'}: " .
               "$DBI::errstr"); }
}

if ($FORM{'command'} eq "editview") {
  if ($FORM{'set'} eq "") {
    my($TABLE, @STH, %VIEW);
    my($DBH) = &connect;
    my(@STH) = &getfields($DBH);
    $TABLE = "<TR>";
    tie %VIEW, SDBM_File::, "$CONFIG{'DATA'}/etc/view", O_RDONLY, 0644;
    my(@VIEWS) = split(/\,/, $VIEW{"$ENV{'REMOTE_USER'}:$FORM{'database'}:$FORM{'table'}"});
    untie %VIEW;
    my($x) = 1;
    foreach(@STH) {
      my($V);
      if ($x>1) { $V = shift(@VIEWS); }
      if ($V ne "-") { $V = "CHECKED"; }
      else { $V = ""; }
      $TABLE .= qq!<TR><TD><B><NOBR>$_:</NOBR></B>&nbsp;&nbsp;</TD><TD>!;
      if ($x==1) { $TABLE .= "<B>REQUIRED</B>"; }
      else { $TABLE .= qq!<INPUT TYPE=CHECKBOX NAME="SQL$x" $V>!; }
      $TABLE .= "</TD></TR>\n";
      $FORM{'totalitems'} = $x;
      $x++;
    }
    &WriteHTML("editview.html", $TABLE);
  }
  else {
    undef($FORM{'set'});
    my($VIEW, %VIEWS);
    for(2..$FORM{'totalitems'}) {
      my($V) = $FORM{"SQL$_"};
      if ($V ne "") { $V="1"; }
      else { $V="-"; }
      $VIEW .= "$V,";
    }
    $VIEW =~ s/,$//;
    tie %VIEWS, SDBM_File::, "$CONFIG{'DATA'}/etc/view", O_CREAT | O_RDWR, 0644 ||
      &WriteHTML("error.html", "preference database: $!");
    $VIEWS{"$ENV{'REMOTE_USER'}:$FORM{'database'}:$FORM{'table'}"} = $VIEW;
    untie %VIEWS;
    &list(1);
#    &WriteHTML("done.html", "Your view preferences have been updated.  Click BACK.");
  }
}

if ($FORM{'command'} eq "edit") {
  if ($CONFIG{'ACCESS'} ne "touch") { 
    &WriteHTML("error.html", "ACCESS DENIED");
  }

  if ($FORM{'set'} eq "") {
    my($TABLE);
    my($DBH) = &connect;
    my(@STH) = &getfields($DBH);
    my(@ITEMS, $FIELD, %REF);
    my($x) = 1;
    foreach(@STH) {
      if ($x == 1) { $FIELD = $_; }
      $REF{$_} = $x;
      push(@ITEMS, $_);
      $x++;
    }
    my($CMD) = "SELECT * FROM $FORM{'table'} WHERE $FIELD = '$FORM{'id'}'";
    $STH = $DBH->prepare($CMD);
    my($RET) = $STH->execute;
    if ($RET) {
      my($ary_ref);
      if ($ary_ref = $STH->fetchrow_arrayref) {
        foreach(@$ary_ref) {
          my($F) = shift(@ITEMS);
          $TABLE .= "\n<TR><TD><B>$F:&nbsp;&nbsp;</B></TD>" .
            qq!<TD><INPUT NAME="SQL$REF{$F}" VALUE="$_"></TD></TR>!;
        }
      }
    }
    $STH->finish;
    $DBH->disconnect;
    $FORM{'set'} = 1;
    &WriteHTML("edit.html", $TABLE);
  }
  else {
    undef($FORM{'set'}); 
    my($CMD) = "UPDATE $FORM{'table'}";
    my($DBH) = &connect;
    my(@STH) = &getfields($DBH);
    my(@ITEMS, $FIELD);
    my($x) = 1;
    foreach(@STH) {
      my($SET);  $SET = "SET" if ($x==1);
      if ($x==1) { $FIELD = $_; }
      $CMD .= qq!\n  $SET $_ = '$FORM{"SQL$x"}',!; 
      $x++;
    }
    $CMD =~ s/\,$//g;
    $CMD .= qq!\n  WHERE $FIELD = '$FORM{'id'}'\n!;
    $STH = $DBH->prepare($CMD);
    my($RET) = $STH->execute;
    $STH->finish;
    $CMD =~ s/\n/<BR>\n/g;
    if ($RET) { &list(0); }
#&WriteHTML("done.html", "RECORD UPDATE SUCCESSFUL:<BR> $CMD"); }
    else { 
      $DBH->disconnect;
      &WriteHTML("error.html", "ERROR: $CMD: $DBI::errstr");
    }
  }
}

&WriteHTML("error.html", "This command has not been implemented yet");
  

sub ReadParse {
  my(@pairs, %FORM);
  if ($ENV{'REQUEST_METHOD'} =~ /GET/i)
    { @pairs = split(/&/, $ENV{'QUERY_STRING'}); }
  else {
    my($buffer);
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/\&/, $buffer);
  }
  foreach(@pairs) {
    my($name, $value) = split(/\=/, $_);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<!--(.|\n)*-->//g;
    $FORM{$name}=$value;
  }
  return %FORM;
}

sub WriteHTML {
  my($FILE, $MESSAGE, $LINK) = @_;
  my($HIDDEN);
  foreach(keys(%FORM)) {
    $HIDDEN .= qq!<INPUT TYPE=HIDDEN NAME=$_ VALUE="$FORM{$_}">\n!;
  }
  if ($LINK eq "") { $LINK = $ENV{'HTTP_REFERER'}; }
  print "Content-type: text/html\n\n";
  foreach(keys(%FORM)) { 
    $FORM{$_} =~ s/ /\+/g; 
    $FORM{$_} =~ s/&/\%26/g; 
  }
  open(HTML, "<$CONFIG{'DATA'}/html/$FILE") || die $!;
  while(<HTML>) {
    s/\$LINK\$/$LINK/gi;
    s/\$MESSAGE\$/$MESSAGE/gi;   
    s/\$HIDDEN\$/$HIDDEN/gi;
    s/\$(\w+)\$/$FORM{$1}/gi;
    print $_;
  }
  close(HTML);
  exit;
}


sub connect {
  my($DBH) = DBI->connect($CONFIG{'CONNECT'}, $CONFIG{'USER'}, $CONFIG{'PASS'})
    || &WriteHTML("error.html", "$0: DBI::mysql:connect: $!");
  return $DBH;
}


sub getfields{
  my($DBH) = @_;
  my($CMD) = "SHOW fields FROM $FORM{'table'};";
  my($STH) = $DBH->prepare($CMD);
  my($RET) = $STH->execute;
  if ($RET) {
    my(@FIELDS);
    my($ary_ref);
    while($ary_ref = $STH->fetchrow_arrayref) { push(@FIELDS, @$ary_ref[0]); }
    $STH->finish;
    return @FIELDS;
  }
  return;
}

sub getxref {
  my(%XREF);
  open(FILE, "$CONFIG{'DATA'}/etc/crossref");
  while(<FILE>) {
    next if (/^#/);
    next unless (/\:/);
    chomp;
    my($FROM, $TO) = split(/\=/);
    my($DBIN, $TABLEIN, $NAME) = split(/\:/, $FROM);
    my($DBOUT, $TABLEOUT, $NAMEOUT) = split(/\:/, $TO);
    next unless ($DBIN eq $FORM{'database'});
    next unless (($TABLEIN eq $FORM{'table'}) || ($TABLEIN eq "*"));
    $XREF{$NAME}="$DBOUT:$TABLEOUT:$NAMEOUT";
  }
  close(FILE);
  return %XREF;
}

# EOF

