#!/usr/bin/perl

use CGI;
use DBI;

$query=new CGI;
$address  = $query->param('address')  || 'dewey';
$database = $query->param('database') || 'mysql';
$username = $query->param('username') || 'bastille';
$password = $query->param('password') || '';
$table    = $query->param('table')    || 'user';
$select   = $query->param('select')   || 'select * from '.$table;
if ($password eq '') { $pwstring = ''; } else { $pwstring = '-p=$password' };

#load the driver for mysql
$drh=DBI->install_driver('mysql') || cgidie("Could not load mysql driver\n");

$dbh=$drh->connect("$database:$address","$username","$password") || cgidie("Failed to connect to mysql server\n");

$cursor=$dbh->prepare("describe $table") || cgidie("Describe failed: describe $table");
$cursor->execute;
@fields = ();
@fieldtypes = ();
while (@fielddesc = $cursor->fetchrow) {
  push @fields, $fielddesc[0];
  push @fieldtypes, $fielddesc[1];
}

print <<EOF
Content-type: text/html

<html><head>
<title>Edit Record</title>
</head><body>
<h1>Editing record in table $table.</h1>
<form method=post action='do_mod_rec.pl'>
<input name=address value='$address' type=hidden>
<input name=database value='$database' type=hidden>
<input name=username value='$username' type=hidden>
<input name=password value='$password' type=hidden>
<input name=table value='$table' type=hidden>
<input name=select value='$select' type=hidden>
EOF
;

@names = $query->param;
$selstr = '';
while ($name = shift @names) {
  if ($name =~ m/^field_(.*)/) {
    print "<input name=$name value='".$query->param($name)."' type=hidden>\n";
    if ($selstr ne '') {
      $selstr .= ' and ';
    }
    $selstr .= "$1='".$query->param($name)."'";
  }
}
$cursor=$dbh->prepare("select * from $table where $selstr") || cgidie("Select failed: select * from $table where $selstr");
$cursor->execute;

print "<table border=1 cellpadding=0 cellspacing=0>\n";
@record = $cursor->fetchrow;
while ($#record > -1) {
  $field = shift @record;
  $fieldname = shift @fields;
  $fielddesc = shift @fieldtypes;
  print "<tr><td>$fieldname</td><td>\n";
  print webeditfield($fielddesc, "update_$fieldname", $field);
  print "\n</td></tr>\n";
}
print <<EOF
</table>
<input type=submit value='Update Record'>
</form>
<hr>
<address>
Orignial Code by: <a href='mailto:tps\@users.buoy.com'>Tim Sailer</a><BR>
Modified by: <a href='mailto:hightide\@iname.com'>Sean Bastille</a>
</address>
</body>
</html>
EOF
;

sub webeditfield {
  $result = '';
  ($type, $name, $val) = @_;
  if (substr($type, 0, 5) eq 'char(') {
    $x = substr($type, 5, -1);
    $result .= "<input name='$name' value='$val' size='$x'>";
  } elsif (substr($type, 0, 5) eq 'enum(') {
    $args = substr($type, 5, -1);
    @list = split(/,/, $args);
    $result .= "<select name=$name>";
    while ($option = shift @list) {
      if ($option =~ /^'(.*)'$/) {
        $option = $1;
      }
      if ($option eq "$val") {
        $result .= "<option selected>";
      } else {
        $result .= "<option>";
      }
      $result .= "$option\n";
    }
    $result .= "</select>";
  }
}

sub cgidie {
  ($die_str) = @_;
print <<EOF
Content-Type: text/html

CGI_Error:<p><pre>
$die_str
</pre>
</body>
</HTML>
EOF
;
  die $dir_str;
}
      
