#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlistview.h>

#include "table.h"

void Table::slot_close()
{
	parentWidget()->close();
}

void Table::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a table window."));
}

void Table::slot_fire()
{
	if(table->text().length() == 0)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter table name you will create."));
		return;
	}

	if(database->currentText() == QString("mysql"))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Can't create table in mysql database."));
		return;
	}

	mysql_select_db(mysql, database->currentText());

	QString sql;

	sql += "CREATE TABLE ";
	sql += table->text(); 
	sql += "(";

	QListViewItem *l;
	l = fields->firstChild();

	while(l)
	{
		sql+= l->text(0);						// field
		sql+= QString(" ") + l->text(1);		    // type	
		if(l->text(2).contains("NOT"))
		{
			sql+= QString(" ") + l->text(2);		// null, not null
		}
		
		if(!l->text(4).isEmpty())					// default
		{
			sql+= QString(" ") + QString("DEFAULT ") + QString("\'") + l->text(4) + QString("\'");
		}
		if(!l->text(5).isEmpty())					// extra 
		{
			sql+= QString(" ") + l->text(5);						 
		}
		if(!l->text(3).isEmpty())
		{
			sql+= QString(", ") + l->text(3);		// key 
		}

		l= l->nextSibling();

		if(l)
		{
			sql += QString(", ");
		}
	}

	sql += ")";
	sql += " comment = \'";
	sql += comment->text();
	sql += "\'";

	sql= sql.simplifyWhiteSpace();

	//debug(sql.latin1());

	if(!mysql_query(mysql, sql.latin1()))
	{
		emit signal_schema();
		QMessageBox::warning(this, tr("MySQL Navigator"), QString(tr("Table ")) + table->text() + QString(tr(" in ")) + database->currentText() + QString(tr(" is created.")));
	}
	else
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		emit signal_error_log();
	}
}

void Table::slot_new()
{
	field->setText("");
	type->setCurrentItem(0);
	attribute->setCurrentItem(0);
	length->setText("");
	null->setCurrentItem(0);
	_default->setText("");
	extra->setCurrentItem(0);
	primary->setChecked(FALSE);
	index->setChecked(FALSE);
	unique->setChecked(FALSE);
	field->setFocus();
}

void Table::slot_save()
{
	if(field->text().length() == 0)
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), tr("Please enter field name you will create.\n"));
		return;
	}

	l = new QListViewItem(fields, l);

	l->setText(0, field->text());
	
	if(length->text().length() == 0)
	{
		l->setText(1, type->currentText() + " " + attribute->currentText());
	}
	else
	{
		l->setText(1, type->currentText() + "(" + length->text() + ") " + attribute->currentText());
	}
	if(null->currentText() == QString("NOT NULL"))
	{
		l->setText(2, "NOT NULL");
	}
	else
	{
		l->setText(2, "");
	}

	if(primary->isChecked())
	{
		l->setText(3, QString("PRIMARY KEY") + QString("(") + field->text() + QString(")"));
	}
	else
	{
		l->setText(3, "");
	}

	l->setText(4, _default->text());

	if(extra->currentText() == QString("AUTO_INCREMENT"))
	{
		QString l_;
		l_ += QString("AUTO_INCREMENT");

		if(index->isChecked())
		{
			l_ += QString(", ");
			l_ += QString("INDEX") + QString("(") + field->text() + QString(")");
			if(unique->isChecked())
			{
				l_ += QString(", ");
				l_ += QString("UNIQUE") + QString("(") + field->text() + QString(")");
			}
		}
		else if(unique->isChecked())
		{
			l_ += QString(", ");
			l_ += QString("UNIQUE") + QString("(") + field->text() + QString(")");
		}

		l->setText(5, l_);
	}
	else
	{
		QString l_;

		if(index->isChecked())
		{
			l_ += QString(", ");
			l_ += QString("INDEX") + QString("(") + field->text() + QString(")");
			if(unique->isChecked())
			{
				l_ += QString(", ");
				l_ += QString("UNIQUE") + QString("(") + field->text() + QString(")");
			}
		}
		else if(unique->isChecked())
		{
			l_ += QString(", ");
			l_ += QString("UNIQUE") + QString("(") + field->text() + QString(")");
		}
		l->setText(5, l_);
	}
}

void Table::slot_drop()
{
	fields->removeItem(fields->selectedItem());
	fields->clearSelection();
}
