#include "query.h"
#include "treelistview.h"
#include "mdiwindow.h"
#include "mainwindow.h"

#include <qmessagebox.h>

void Query::set_database()
{
	result=mysql_list_dbs(mysql,NULL);

	if(result==NULL)
	{
		debug("mysql_list_dbs failed");
		return;
	}

	while((row=mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}
	mysql_free_result(result);
}

void Query::slot_close()
{
	parentWidget()->close();
}

void Query::slot_clear()
{
	query->clear();				
	listview->slot_clear();
}

void Query::slot_undo()
{
	query->undo();
}

void Query::slot_redo()
{
	query->redo();
}

void Query::slot_cut()
{
	query->cut();
}

void Query::slot_copy()
{
	query->copy();
}

void Query::slot_paste()
{
	query->paste();
}

void Query::slot_select_all()
{
	query->selectAll();
}

void Query::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a query window."));
}

void Query::slot_fire()
{
	listview->set_sql(database->currentText(), query->text());
	if(listview->execute() == FALSE)
	{
		emit signal_tree();
	}
}
