#include "process.h"
#include <qmessagebox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>

void Process::signal_connect()
{
	connect((const QObject *)close, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_close()));
	connect((const QObject *)process, SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT(slot_kill(QListViewItem *)));
}

void Process::show_process()
{
	MYSQL_RES *result;
	MYSQL_FIELD *field;
	MYSQL_ROW row;

	process->clear();

	int si_;

	si_ = process->columns();

	for(int i = 0; i < si_; i++)
	{
		process->removeColumn(0);
	}

	mysql_select_db(mysql, "mysql");

	if(mysql_query(mysql, "show processlist"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return; 	 
	}

	result = mysql_store_result(mysql);

	if(result == NULL)
	{
		return;
	}
	
	si_ = mysql_num_fields(result);

	while((field = mysql_fetch_field(result)))
	{
		process->addColumn(field->name);
	}

	QListViewItem *si;
	
	while((row = mysql_fetch_row(result)))
	{
		si = new QListViewItem(process, row[0]);
	
		for(int _si = 1; _si < si_; _si++)
		{
			si->setText(_si, row[_si]);
		}
	}

	mysql_free_result(result);
}
