#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qmenubar.h>
#include <qpopupmenu.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "tree.h"
#include "field.h"

void MainWindow::slot_tree_clicked(QListViewItem *sise, const QPoint &, int)
{
	if(sise == NULL)
	{
		return;
	}

	QPopupMenu *l = new QPopupMenu(this);
		
	switch(get_level(sise))
	{
		case 0:
		{
			// host	
			l->insertItem(tr("Refresh"), this, SLOT(slot_schema_refresh(int)));	
			l->insertSeparator();	
			l->insertItem(tr("Create database"), this, SLOT(slot_create_database(int)));	
			break;
		}
		case 1:
		{
			// database
			l->insertItem(tr("Delete database"), this, SLOT(slot_delete_database(int)));	
			l->insertSeparator();	
			l->insertItem(tr("Create table"), this, SLOT(slot_create_table(int)));	
			_si = sise;

			break;
		}
		case 2:
		{
			// table
			l->insertItem(tr("See Table"),this,SLOT(slot_see_table(int)));	
			l->insertItem(tr("See Keys"),this,SLOT(slot_see_keys(int)));	
			l->insertItem(tr("See Fields"),this,SLOT(slot_see_fields(int)));	
			l->insertItem(tr("See Status"),this,SLOT(slot_see_status(int)));	
			l->insertSeparator();
			l->insertItem(tr("Delete table"), this, SLOT(slot_delete_table(int)));	
			l->insertSeparator();
			l->insertItem(tr("Create field"), this, SLOT(slot_create_field(int)));
			_si = sise;
			break;

		}
		case 3:
		{
			l->insertItem(tr("Delete field"), this, SLOT(slot_delete_field(int)));
			l->insertItem(tr("Change field"), this, SLOT(slot_change_field(int)));
			l->insertSeparator();	
			l->insertItem(tr("Delete primary"), this, SLOT(slot_delete_primary(int)));
			l->insertItem(tr("Delete index"), this, SLOT(slot_delete_index(int)));
			l->insertSeparator();	
			l->insertItem(tr("Create primary"), this, SLOT(slot_create_primary(int)));
			l->insertItem(tr("Create unique"), this, SLOT(slot_create_unique(int)));
			l->insertItem(tr("Create index"), this, SLOT(slot_create_index(int)));
			_si = sise;
			break;
		}
	}

	l->popup(QCursor::pos());
}

void MainWindow::slot_see_table(int)
{
	slot_query(((QListViewItem *)_si)->parent()->text(0), QString("select * from ") + ((QListViewItem *)_si)->text(0), tr("Table"));
}

void MainWindow::slot_see_keys(int)
{
	slot_query(((QListViewItem *)_si)->parent()->text(0), QString("show keys from ") + ((QListViewItem *)_si)->text(0), tr("Keys"));
}

void MainWindow::slot_see_fields(int)
{
	slot_query(((QListViewItem *)_si)->parent()->text(0), QString("show fields from ") + ((QListViewItem *)_si)->text(0), tr("Fields"));
}

void MainWindow::slot_see_status(int)
{
	slot_query(((QListViewItem *)_si)->parent()->text(0), QString("show table status like \'") + ((QListViewItem *)_si)->text(0) + QString("\'"), tr("Status"));
}

void MainWindow::slot_create_database(int)
{
	bool si = FALSE;
	
	QString text = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter database name you will create."), QString::null, &si, this );
	
	if(si && !text.isEmpty())
	{
		if((mysql_create_db(&mysql, text.latin1())))
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
			slot_error_log();
		}
		else
		{
			set_database();
			emit signal_tree();
			QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Database ")) + text + QString(tr(" is successfully created.")));
			
			mysql_reload(&mysql);

		}
	}
	else
	{
	}
}

void MainWindow::slot_delete_database(int)
{
	QListViewItem *database = (QListViewItem *)_si;

	QString sql = database->text(0);

	if(database == NULL)
	{
		return;
	}

	if(sql == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("mysql database cannot be deleted"));
	}
	else
	{
		int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this database?"), tr("Yes"), tr("No"));
		
		if(l == 1)
		{
			return;
		}
		
		if((mysql_drop_db(&mysql, sql)))
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
			slot_error_log();
		}
		else
		{
			set_database();
			emit signal_tree();
			QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Database ")) + sql + QString(tr(" is successfully deleted.")));

			mysql_reload(&mysql);
		}
	}

}

void MainWindow::slot_create_table(int)
{
	slot_table();
}

void MainWindow::slot_delete_table(int)
{
	QListViewItem *table = (QListViewItem *)_si;

	if(table == NULL)
	{
		return;
	}

	QString sql = table->text(0);
	QString database = table->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("drop table %s", sql.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this table?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Table ")) + sql + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_create_field(int)
{
	QListViewItem *table = (QListViewItem *)_si;
	
	if(table == NULL)
	{
		return;
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
  
	Field *sql = new Field(&mysql, TRUE, table->parent()->text(0), table->text(0), QString(""), l);

	connect(sql, SIGNAL(signal_error_log()), this, SLOT(slot_error_log()));
	connect(sql, SIGNAL(signal_tree()), this, SLOT(slot_tree()));

	l->setCentralWidget(sql);
	
	l->setFixedSize(221, 357);

	l->setCaption(tr("Create field"));

	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("&File"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Clear"), sql, SLOT(slot_clear()));
	l->menuBar()->insertItem(tr("&Edit"), l_);
	
	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);

	l->show();
}

void MainWindow::slot_change_field(int)
{
	QListViewItem *field = (QListViewItem *)_si;
	
	if(field == NULL)
	{
		return;
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
  
	Field *sql = new Field(&mysql, FALSE, field->parent()->parent()->text(0), field->parent()->text(0), field->text(0), l);

	connect(sql, SIGNAL(signal_error_log()), this, SLOT(slot_error_log()));
	connect(sql, SIGNAL(signal_tree()), this, SLOT(slot_tree()));

	l->setCentralWidget(sql);

	l->setFixedSize(221, 357);

	l->setCaption(tr("Change field - ") + field->text(0));
	
	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), sql, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("&File"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Clear"), sql, SLOT(slot_clear()));
	l->menuBar()->insertItem(tr("&Edit"), l_);
	
	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);

	l->show();
}

void MainWindow::slot_delete_field(int)
{
	QListViewItem *field = (QListViewItem *)_si;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Field in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("alter table %s drop %s", table.latin1(), sql.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this field?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}


	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ")) + sql + "@" + table + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_primary(int)
{
	QListViewItem *field = (QListViewItem *)_si;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Primary key in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("alter table %s drop primary key", table.latin1());
	//debug(query.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this primary key?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}
	
	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Primary key")) + "@" + table + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_index(int)
{
	QListViewItem *field = (QListViewItem *)_si;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Index in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("alter table %s drop index %s", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this index?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Index")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_unique(int)
{
}

void MainWindow::slot_create_primary(int)
{
	QListViewItem *field = (QListViewItem *)_si;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create primary key in mysql database"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("alter table %s add primary key(%s)", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Primary key")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully created.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_create_unique(int)
{
	QListViewItem *field = (QListViewItem *)_si;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create unique index in mysql database"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("alter table %s add unique(%s)", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Unique index")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully create.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_create_index(int)
{
	QListViewItem *field = (QListViewItem *)_si;

	if(field == NULL)
	{
		return;
	}

	QString sql = field->text(0);
	QString database = field->parent()->parent()->text(0);
	QString table = field->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't create index in mysql database"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error_log();
		return;
	}

	QString query;

	query.sprintf("alter table %s add index(%s)", table.latin1(), sql.latin1());
	
	//debug(query.latin1());

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error_log();
	}
	else
	{
		emit signal_tree();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Index")) + "@" + sql +"@" + table + "@" + database + QString(tr(" is successfully created.")));
		mysql_reload(&mysql);
	}

}

void MainWindow::slot_schema()
{
	if(flag)
	{
		MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);
	
		Tree *tree = new Tree(&mysql, host, user, window);

		connect((QListView *)tree,SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int)),this,SLOT(slot_tree_clicked(QListViewItem *, const QPoint &, int)));

		connect(this, SIGNAL(signal_tree()), tree, SLOT(slot_refresh()));

		tree->slot_refresh();

		window->setCentralWidget(tree);
	
		window->setCaption(tr("Schema"));

		window->resize(200,work_space->height()-25);
	
		window->show();
	}
}

void MainWindow::slot_tree()
{
	set_database();
	emit signal_tree();
}

void MainWindow::slot_schema_refresh(int)
{
	slot_tree();
}
