#include <qmenubar.h>

#include "mdiwindow.h"
#include "mainwindow.h"
#include "process.h"

void MainWindow::slot_process()
{
	if(!flag)
	{
		return;	
	}
		
	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);

	window->setFixedSize(378, 178);
	
	Process *process = new Process(&mysql,window);
	
	connect(process, SIGNAL(signal_error_log()), this, SLOT(slot_error_log()));

    window->setCentralWidget(process);
			 
    window->setCaption(tr("Process"));

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Kill"), process, SLOT(slot_kill()), CTRL+Key_K);
	l->insertItem(tr("&Refresh"), process, SLOT(slot_refresh()), CTRL+Key_R);
	l->insertSeparator();
	l->insertItem(tr("&Close"), process, SLOT(slot_close()), CTRL+Key_C);
	window->menuBar()->insertItem(tr("&File"), l);

	l = new QPopupMenu();
	l->insertItem(tr("&About..."), process, SLOT(slot_about()), Key_F1);
	window->menuBar()->insertItem(tr("&Help"), l);

	window->show();
}
