/***************************************************************************
                          opendialog.cpp  -  description
                             -------------------
    begin                : Mon Oct 23 2000
    copyright            : (C) 2000 by shi bok jang
    email                : sise15@mizi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "connect.h"

#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include "serverlistviewitem.h"

void Connect::slot_socket()
{
	QString l = QFileDialog::getOpenFileName();

	if(!l.isEmpty())
	{
		socket->setText(l);
	}
}

void Connect::slot_new()
{
	list->clearSelection();

	host->setText("");
	user->setText("");
	password->setText("");
	database->setText("");
	port->setText("");
	socket->setText("");

	host->setFocus();
}

void Connect::slot_save()
{
	if(host->text().isEmpty())
	{
		return;
	}

	ServerListViewItem *l = (ServerListViewItem *)list->selectedItem();
	
	if(l == NULL)
	{
		dummy = new ServerListViewItem(list, dummy, host->text(), host->text(), user->text(), password->text(), database->text(), port->text(), socket->text());
	}
	else
	{
		l->host = host->text();
		l->user = user->text();
		l->password = password->text();
		l->database = database->text();
		l->port = port->text();
		l->socket = socket->text();
	}
	
	list->clearSelection();
}

void Connect::slot_drop()
{
	list->removeItem(list->selectedItem());
	
	list->clearSelection();
}

void Connect::slot_server(QListViewItem *l)
{
	if(l == NULL)
	{
		return;
	}

	list->setSelected(l, TRUE);

	host->setText(((ServerListViewItem *)l)->host);
	user->setText(((ServerListViewItem *)l)->user);
	password->setText(((ServerListViewItem *)l)->password);
	database->setText(((ServerListViewItem *)l)->database);
	port->setText(((ServerListViewItem *)l)->port);
	socket->setText(((ServerListViewItem *)l)->socket);
}
