package mysqladmin;

/** 

    TableMetaData is a part of Admin

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.1 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.sql.*;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;



public class TableMetaData extends JPanel {


   private JTable info;
   public JButton cancel;
   private TableInfo ti;

    String host;
    
    /**
       * Get the value of host.
       * @return Value of host.
       */
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    
    String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    
    String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}
    
    String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    
    String table;
    
    /**
       * Get the value of table.
       * @return Value of table.
       */
    public String getTable() {return table;}
    
    /**
       * Set the value of table.
       * @param v  Value to assign to table.
       */
    public void setTable(String  v) {this.table = v;}
    
    private Vector name, type,size, isNull, remarks, defaults;

    public TableMetaData(String host, String user, String password, String database, String table) {

       setHost(host);
       setUser(user);
       setPassword(password);
       setDatabase(database);
       setTable(table);
       inits();

       }

       public TableMetaData() {
	   inits();
       }


       private void inits() {
	   name = new Vector();
	   type = new Vector();
	   size = new Vector();
	   isNull = new Vector();
	   remarks = new Vector();
	   defaults = new Vector();
	   this.setLayout(new BorderLayout());
	   this.add("North",descr());
	   this.add("Center",listPanel());
	   this.add("South",buttonPanel());
       }


       private void  tableInit() {

	   ti = new TableInfo();
	   info = new JTable(ti);
	   t_connect con = new t_connect(getHost(),getUser(),getPassword(),getDatabase());

        try {
	 DatabaseMetaData dmd = con.con.getMetaData();
         ResultSet rs = dmd.getColumns(null, null, getTable(), null);
	 while (rs.next()) { 
     	    Vector v = new Vector();

	    String n = rs.getString("COLUMN_NAME");
	    v.addElement(n);
	    
	    String t = rs.getString("TYPE_NAME");
	    v.addElement(t);

	    int s = rs.getInt("COLUMN_SIZE");
            Integer si = new Integer(s);
	    v.addElement(si);

	    boolean nu;
	    if ( rs.getString("IS_NULLABLE").equalsIgnoreCase("NO")) {
		nu = false;
	    } else { 
	       nu = true; 
	    }

            Boolean nuu = new Boolean(nu);
            v.addElement(nuu);

	    String r = rs.getString("REMARKS");
	    v.addElement(r);

	    String d = rs.getString("COLUMN_DEF");
	    if ( d == null) d= " "; //This is a change for postgres

	    v.addElement(d);

	    ti.addRow(v);
	 }
	} catch (SQLException se) {;}
	con.close();
       }

  
       private JPanel listPanel() {
	   

	   tableInit();
	   JPanel panel = new JPanel();
	   panel.setLayout(new BorderLayout());
	 
	   //panel.add("North",descr());

	   JScrollPane scrollpane = new JScrollPane();
	   info.getTableHeader().setReorderingAllowed(false);
	   info.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
           info.setPreferredScrollableViewportSize(new Dimension(400, 80));
	   scrollpane.getViewport().add(info);
	   panel.add("South",scrollpane);

	   return panel;
       }

       private JPanel buttonPanel() {

	   JPanel panel = new JPanel();
	   panel.setLayout(new FlowLayout());

	   cancel = new JButton("Cancel");
	   panel.add(cancel);
	   return panel;
       }


    private JPanel descr() {

	JPanel panel = new  JPanel();
	panel.setLayout(new FlowLayout());

	JLabel      l1 = new JLabel("Host:");
	JTextField  t1 = new JTextField(getHost());
	t1.setEditable(false);
	t1.setBackground(Color.black);
	t1.setForeground(Color.white);

	JLabel      l2 = new JLabel("User:");
	JTextField  t2 = new JTextField(getUser());
	t2.setEditable(false);
	t2.setBackground(Color.black);
	t2.setForeground(Color.white);

	JLabel      l3 = new JLabel("Database:");
	JTextField  t3 = new JTextField(getDatabase());
	t3.setEditable(false);
	t3.setBackground(Color.black);
	t3.setForeground(Color.white);


	JLabel      l4 = new JLabel("Table:");
	JTextField  t4 = new JTextField(getTable());
	t4.setEditable(false);
	t4.setBackground(Color.black);
	t4.setForeground(Color.white);

	panel.add(l1);
	panel.add(t1);
	panel.add(l2);
	panel.add(t2);
	panel.add(l3);
	panel.add(t3);
	panel.add(l4);
	panel.add(t4);

 
	return panel;

    }



       public static void main(String args[]) {

	   if (args.length != 5) {
	       System.out.println("Syntax: java TableMetaData host user password database table");
	       System.exit(0);
	   }

	   JFrame f = new JFrame("Table Info");
	   f.addWindowListener(new WindowAdapter() {
	       public void windowActivated(WindowEvent e) {}
	       public void windowClosed(WindowEvent e) {}
	       public void windowClosing(WindowEvent e) {System.exit(0);}
	       public void windowDeactivated(WindowEvent e) {}
	       public void windowDeiconified(WindowEvent e) {}
	       public void windowIconified(WindowEvent e) {}
	       public void windowOpened(WindowEvent e) {}});
	   f.getContentPane().setLayout(new BorderLayout());
	   TableMetaData tmd = new TableMetaData(args[0],args[1],args[2],args[3],args[4]);
	   f.getContentPane().add("Center",tmd);
	   tmd.cancel.addActionListener(new ActionListener() {
	       public void actionPerformed(ActionEvent e) {
		   System.exit(0);
		   }});
	   
	   f.pack();
	   f.setVisible(true);
       }
    }
