# copyright (C) 1997-2002 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: myprocs.tcl,v 2.14 2002/01/19 11:53:05 jfontain Exp $}


package provide myprocs [lindex {$Revision: 2.14 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
package require miscellaneous 1


namespace eval myprocs {

    array set data {
        updates 0
        0,label id 0,type integer 0,message {process identifier}
        1,label user 1,type dictionary 1,message {user name}
        2,label host 2,type dictionary 2,message {host name}
        3,label database 3,type dictionary 3,message {database name}
        4,label command 4,type ascii 4,message command
        5,label time 5,type dictionary 5,message {process time in d(ays), h(ours), m(inutes) and s(econds)}
        6,label state 6,type dictionary 6,message state
        7,label information 7,type dictionary 7,message {query information} 7,anchor left
        sort {0 decreasing}
        pollTimes {10 5 20 30 60 120 300}
        switches {--dsn 1 --host 1 --password 1 --port 1 --user 1}
    }
    set file [open myprocs.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable odbc
        variable connection
        variable data

        catch {set user $::env(USER)}                                                                                  ;# by default
        catch {set user $::env(LOGNAME)}                                                          ;# more common in UNIX and even NT
        catch {set user $options(--user)}
        if {[info exists options(--dsn)]} {                                               ;# ODBC mode id data source name specified
            set odbc 1
            package require tclodbc 2                               ;# so that it works with both UNIX 2.2.1 et Windows 2.3 versions
            if {[info exists options(--host)]||[info exists options(--port)]} {
                error {--host and --port options incompatible with ODBC mode}
            }
            set arguments [list $options(--dsn)]
            catch {lappend arguments $user}
            catch {lappend arguments $options(--password)}
            set connection [eval database odbc $arguments]                                           ;# use a unique connection name
            set data(identifier) myprocs($options(--dsn))
            $connection {show processlist}                                        ;# first check that user has the process privilege
        } else {
            set odbc 0
            package require mysqltcl 2
            set arguments {}
            catch {lappend arguments -host $options(--host)}
            catch {lappend arguments -user $user}
            catch {lappend arguments -password $options(--password)}
            catch {lappend arguments -port $options(--port)}
            set connection [eval mysqlconnect $arguments]
            set host [mysqlinfo $connection host]
            set data(identifier) myprocs($host)
            mysqlsel $connection {show processlist} -list                         ;# first check that user has the process privilege
        }
    }

    proc update {} {
        variable odbc
        variable connection
        variable data

        array unset data {[0-9]*,[0-9]*}                                      ;# refresh data every time since processes come and go
        set error 0
        if {$odbc} {
            set error [catch {
                $connection statement $connection.query {show processlist}
                $connection.query execute
            } message]
        } else {
            set error [catch {mysqlsel $connection {show processlist}} message]
        }
        if {$error} {                                                                                     ;# problem reaching server
            flashMessage "myprocs error: $message"
        } else {
            while {1} {
                if {$odbc} {
                    set list [$connection.query fetch]
                } else {
                    set list [mysqlnext $connection]
                }
                if {[llength $list]==0} break
                set row [lindex $list 0]                                                                              ;# id (unique)
                set column 0
                foreach value $list {
                    if {($column==5)&&([string length $value]>0)} {    ;# time column (value may be empty when user connecting, ...)
                        set data($row,$column) [formattedTime $value]
                    } else {
                        set data($row,$column) $value
                    }
                    incr column
                }
            }
        }
        if {$odbc} {
            catch {$connection.query drop}            ;# ignore connection errors at this point (they will be reported at next poll)
        }
        incr data(updates)
    }

    proc terminate {} {
        variable odbc
        variable connection

        if {$odbc} {
            catch {$connection disconnect}
        } else {
            catch {mysqlclose $connection}
        }
    }

}
