/***************************************************************************
                          singlecombo.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jul 10 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef rcsid
static const char rcsid[]="$Id: singlecombo.cpp,v 2.4 1999/10/15 19:02:37 ral Exp $";
//const char* singlecombo_rcs(){return rcsid;}
#endif


#include "singlecombo.h"

CSingleCombo::CSingleCombo(QWidget *parent, const char *name )
    : QComboBox(parent,name)
{
}

CSingleCombo::CSingleCombo(bool rw,QWidget * parent, const char*name)
    :QComboBox(rw,parent,name)
{
}

CSingleCombo::~CSingleCombo()
{
}

void CSingleCombo::insertItem(const char * n_text, int index=-1)
{
    if (count() > 0) {
	if (!n_text){// || strlen(n_text) == 0) {
	    return;
	}
	QString item;
	if (count() == 1) {
	    item = text(0);
	    if (item.isEmpty()) {
		removeItem(0);
	    }
	}
	int max_counter = count();
	for (int counter = 0; counter < max_counter;++counter) {
	    if (strcasecmp(text(counter),n_text) == 0) {
		return;
	    }
	}
    }
    QComboBox::insertItem(n_text,index);
}

void CSingleCombo::buildList()
{
    ItemList.clear();
    if (count() > 1) {
	for (int counter = 0; counter < count(); ++counter) {
	    ItemList.insert(ItemList.count(),text(counter));
	}
    }
}

const QStrIList*CSingleCombo::Items()const
{
    ((CSingleCombo*)this)->buildList();
    return &ItemList;
}
