
#include "selectoutfile.h"
#include <kapp.h>
#include <kwm.h>
#include <kfiledialog.h>

#ifndef rcsid
static const char rcsid[]="$Id: selectoutfile.cpp,v 2.3 1999/10/13 00:51:21 ral Exp $";
//const char*selectoutfile_rcs(){return rcsid;}
#endif

#define Inherited CSelectOutFileData

CSelectOutFile::CSelectOutFile(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( i18n("Select File to save") );
    OkButton->setDefault(false);
    OkButton->setEnabled(false);
    FileNameEdit->setFocus();
    CurrentSel = 0;
}


CSelectOutFile::~CSelectOutFile()
{
}

void CSelectOutFile::SearchFile()
{
    QString s;
    QString pat;
    switch (CurrentSel) {
    case 0:
	pat = "*.txt";
	break;
    case 1:
	pat = "*.html";
	break;
    case 2:
	pat = "*.tex";
	break;
    default:
	pat = "*";
	break;
    }
    s = KFileDialog::getSaveFileName(0,pat);
    FileNameEdit->setText(s);
}

void CSelectOutFile::SelectionChanged(int i)
{
    CurrentSel = i;
}

void CSelectOutFile::textchange(const char*text)
{
    if (strlen(text) > 0) {
	OkButton->setDefault(true);
	OkButton->setEnabled(true);
    }
    else {
	OkButton->setDefault(false);
	OkButton->setEnabled(false);
    }
}
