#include "MainWindowData.h"

#define Inherited QWidget

#include <kapp.h>
#include <qlayout.h>

#ifndef rcsid
static const char rcsid[]="$Id: MainWindowData.cpp,v 2.3 1999/10/13 00:51:19 ral Exp $";
//const char*mainwindowdata_rcs(){return rcsid;}
#endif

CMainWindowData::CMainWindowData(QWidget* parent,const char* name)
    :Inherited( parent, name, 0 )
{
    OutputArea = new QMultiLineEdit( this, "OutputArea1" );
    OutputArea->setGeometry( 1, 1, 346, 100 );
    OutputArea->setMinimumSize( 10, 10 );
    OutputArea->setMaximumSize( 32767, 32767 );
    OutputArea->setReadOnly( TRUE );
    OutputArea->setOverwriteMode( FALSE );

    ConnectButton = new QPushButton( this, "ConnectButton" );
    ConnectButton->setGeometry( 0, 0, 87, 25 );
    ConnectButton->setMinimumSize( 10, 25 );
    ConnectButton->setMaximumSize( 32767, 25 );
    connect( ConnectButton, SIGNAL(clicked()), SLOT(connectSql()) );
    ConnectButton->setText( i18n("&Connect") );
    ConnectButton->setAutoRepeat( FALSE );
    ConnectButton->setAutoResize( FALSE );

    accessButton = new QPushButton( this, "AccessButton" );
    accessButton->setGeometry( 87, 0, 87, 25 );
    accessButton->setMinimumSize( 10, 25 );
    accessButton->setMaximumSize( 32767, 25 );
    connect( accessButton, SIGNAL(clicked()), SLOT(accessControl()) );
    accessButton->setText( i18n("&Grants") );
    accessButton->setAutoRepeat( FALSE );
    accessButton->setAutoResize( FALSE );

    ThreadButton = new QPushButton( this, "ThreadButton" );
    ThreadButton->setGeometry( 261, 0, 87, 25 );
    ThreadButton->setMinimumSize( 10, 25 );
    ThreadButton->setMaximumSize( 32767, 25 );
    connect( ThreadButton, SIGNAL(clicked()), SLOT(view_threads()) );
    ThreadButton->setText( i18n("&Thread") );
    ThreadButton->setAutoRepeat( FALSE );
    ThreadButton->setAutoResize( FALSE );

    CreateDBButton = new QPushButton( this, "CreateDBButton" );
    CreateDBButton->setGeometry( 0, 0, 87, 25 );
    CreateDBButton->setMinimumSize( 10, 25 );
    CreateDBButton->setMaximumSize( 32767, 25 );
    connect( CreateDBButton, SIGNAL(clicked()), SLOT(createDB()) );
    CreateDBButton->setText( i18n("Create &DB") );
    CreateDBButton->setAutoRepeat( FALSE );
    CreateDBButton->setAutoResize( FALSE );

    CreateTableButton = new QPushButton( this, "PushButton_5" );
    CreateTableButton->setGeometry( 87, 0, 87, 25 );
    CreateTableButton->setMinimumSize( 10, 25 );
    CreateTableButton->setMaximumSize( 32767, 25 );
    connect( CreateTableButton, SIGNAL(clicked()), SLOT(createTable()) );
    CreateTableButton->setText( i18n("Cr&eate Table") );
    CreateTableButton->setAutoRepeat( FALSE );
    CreateTableButton->setAutoResize( FALSE );

    AlterTableButton = new QPushButton( this, "alterTableButton" );
    AlterTableButton->setGeometry( 174, 0, 87, 25 );
    AlterTableButton->setMinimumSize( 10, 25 );
    AlterTableButton->setMaximumSize( 32767, 25 );
    connect( AlterTableButton, SIGNAL(clicked()), SLOT(alterTable()) );
    AlterTableButton->setText( i18n("&Alter Table") );
    AlterTableButton->setAutoRepeat( FALSE );
    AlterTableButton->setAutoResize( FALSE );

    StatusButton = new QPushButton( this, "StatusButton" );
    StatusButton->setGeometry( 174, 0, 87, 25 );
    StatusButton->setMinimumSize( 10, 25 );
    StatusButton->setMaximumSize( 32767, 25 );
    connect( StatusButton, SIGNAL(clicked()), SLOT(dispStatus()) );
    StatusButton->setText( i18n("&Status") );
    StatusButton->setAutoRepeat( FALSE );
    StatusButton->setAutoResize( FALSE );

    browseTablesButton = new QPushButton( this, "BrowseTableButton" );
    browseTablesButton->setGeometry( 261, 0, 87, 25 );
    browseTablesButton->setMinimumSize( 10, 25 );
    browseTablesButton->setMaximumSize( 32767, 25 );
    connect( browseTablesButton, SIGNAL(clicked()), SLOT(browseTables()) );
    browseTablesButton->setText( i18n("&Browse Tables") );
    browseTablesButton->setAutoRepeat( FALSE );
    browseTablesButton->setAutoResize( FALSE );

    QBoxLayout* dlgedit_layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 1, 0, NULL );
    dlgedit_layout_1->addStrut( 0 );
    QBoxLayout* dlgedit_layout_1_1 = new QBoxLayout( QBoxLayout::LeftToRight, 0, "UpperBar" );
    dlgedit_layout_1->addLayout( dlgedit_layout_1_1, 0 );
    dlgedit_layout_1_1->addStrut( 0 );
    dlgedit_layout_1_1->addWidget( ConnectButton, 1, 36 );
    dlgedit_layout_1_1->addWidget( accessButton, 1, 36 );
    dlgedit_layout_1_1->addWidget( StatusButton, 1, 36 );
    dlgedit_layout_1_1->addWidget( ThreadButton, 1, 36 );

    QBoxLayout* dlgedit_layout_1_2 = new QBoxLayout( QBoxLayout::TopToBottom, 1, "OutputLayout" );
    dlgedit_layout_1->addLayout( dlgedit_layout_1_2, 5 );
    dlgedit_layout_1_2->addStrut( 0 );
    dlgedit_layout_1_2->addWidget( OutputArea, 1, 36 );

    QBoxLayout* dlgedit_layout_1_3 = new QBoxLayout( QBoxLayout::LeftToRight, 0, "LowerBar" );
    dlgedit_layout_1->addLayout( dlgedit_layout_1_3, 0 );
    dlgedit_layout_1_3->addStrut( 0 );
    dlgedit_layout_1_3->addWidget( CreateDBButton, 1, 36 );
    dlgedit_layout_1_3->addWidget( CreateTableButton, 1, 36 );
    dlgedit_layout_1_3->addWidget( AlterTableButton, 1, 36 );
    dlgedit_layout_1_3->addWidget( browseTablesButton, 1, 36 );


    resize( 350,160 );
    setMinimumSize( 370, 150 );
    setMaximumSize( 32767, 32767 );
}


CMainWindowData::~CMainWindowData()
{
}
void CMainWindowData::connectSql()
{
}
void CMainWindowData::accessControl()
{
}
void CMainWindowData::view_threads()
{
}
void CMainWindowData::createDB()
{
}
void CMainWindowData::createTable()
{
}
void CMainWindowData::alterTable()
{
}
void CMainWindowData::dispStatus()
{
}
void CMainWindowData::browseTables()
{
}
