#include "MainApp.h"
#include <qkeycode.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kwm.h>
#include <kfiledialog.h>
#include <qtstream.h>
#include <qmenudta.h>
#include <qpopmenu.h>
#include <qlayout.h>
#include "stringres.h"
#include "MainWindow.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef version_id
#ifdef VERSION
static char version_id[]="Ver ";
#else
static char version_id[]="Version 0.33";
#endif
#endif

#ifndef rcsid
static const char rcsid[]="$Id: MainApp.cpp,v 2.16 1999/11/08 03:32:34 ral Exp $";
//const char*mainapp_rcs(){return rcsid;}
#endif

#define Inherited KTMainWindow

CMainApp::CMainApp(const char* name)
	:Inherited( name ),CSendMessage()
{
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(124);
    setCaption(head);

    int id;
    MenuBar = new KMenuBar(this);
    MainWidget = new CMainWindow( this, "MainWidget" );
    MainWidget->set_msg_ptr(this);
    file = new QPopupMenu;
    file->insertItem(CStringRes::get_string(47),MainWidget,SLOT(disconnectSql()),CTRL+Key_D);
    file->insertItem(CStringRes::get_string(48),MainWidget,SLOT(clearOutput()));
    file->setCheckable(TRUE);
    logf = file->insertItem(CStringRes::get_string(49),this,SLOT(set_LogFileName()));
    file->insertSeparator();
    file->insertItem(CStringRes::get_string(122),this,SLOT(new_window()),CTRL+Key_N);
    file->insertSeparator();
    file->insertItem(CStringRes::get_string(123),this,SLOT(windowClose()),CTRL+Key_W);
    file->insertItem("&Quit",this,SLOT(raus_hier()),CTRL+Key_Q);
    MenuBar->insertItem(CStringRes::get_string(109),file);
    db_menu = new QPopupMenu;
    id = db_menu->insertItem(CStringRes::get_string(50));
    db_menu->connectItem(id,MainWidget,SLOT(drop_db()));
    id = db_menu->insertItem(CStringRes::get_string(110));
    db_menu->connectItem(id,MainWidget,SLOT(rename_table()));
    id = db_menu->insertItem(CStringRes::get_string(51));
    db_menu->connectItem(id,MainWidget,SLOT(drop_table()));
    db_menu->insertSeparator();
    id = db_menu->insertItem(CStringRes::get_string(52));
    db_menu->connectItem(id,MainWidget,SLOT(flush_cache()));
    id = db_menu->insertItem(CStringRes::get_string(53));
    db_menu->connectItem(id,MainWidget,SLOT(close_tables()));
    id = db_menu->insertItem(CStringRes::get_string(54));
    db_menu->connectItem(id,MainWidget,SLOT(new_log()));
    db_menu->insertSeparator();
    id = db_menu->insertItem(CStringRes::get_string(55));
    db_menu->connectItem(id,MainWidget,SLOT(reload_grants()));
    QString e_str = "&";e_str+=CStringRes::get_string(56);
    id = db_menu->insertItem(e_str);
    db_menu->connectItem(id,MainWidget,SLOT(shutdown()));
    id = db_menu->insertItem("SQL Editor");
    db_menu->connectItem(id,MainWidget,SLOT(sql_Edit()));
    MenuBar->insertItem(CStringRes::get_string(57),db_menu);
    MenuBar->insertSeparator();
    QString about_string = CStringRes::get_string(58);
    about_string+=version_id;
#ifdef VERSION
    about_string+=VERSION;
#endif
    about_string+="\n\n";
    about_string+=CStringRes::get_string(59);
    about_string+="\n";
    about_string+=CStringRes::get_string(60);
    about_string+=" 11.99\n\n";
    about_string+="Email: rajko.albrecht@informatik.tu-chemnitz.de\n";
    about_string+="WWW:   http://www.webeifer.de/alwin/Programs/KMySQLAdmin/index.html";
    QPopupMenu * m = kapp->getHelpMenu(true,
				       about_string);
    MenuBar->insertItem(CStringRes::get_string(111),m);
    setMenu(MenuBar);
    KIconLoader iconload;
    QPixmap icon = iconload.loadIcon("kmysqladmin.xpm");
    setIcon(icon);
    connect(MainWidget,SIGNAL(connected(const char*)),this,SLOT(connected_to_server(const char*)));
    connect(MainWidget,SIGNAL(disconnected()),this,SLOT(disconnected_from_server()));
    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());

    MainWidget->setGeometry( 2, 2, 366, 186 );
    MainWidget->setMinimumSize( 370, 190 );
    MainWidget->setMaximumSize( 32767, 32767 );

    setView(MainWidget,FALSE);
    disconnected_from_server();
    setMinimumSize( 370, 190 );
    setMaximumSize( 32767, 32767 );
}


CMainApp::~CMainApp()
{
    filepointer.close();
}
  
void CMainApp::append_message(const char*text)
{
    if (text && strlen(text) != 0 ) {
	MainWidget->append_message(text);
	if (filepointer.isOpen()) {
	    QTextStream t( &filepointer );
	    t << text << "\n";
	    filepointer.flush();
	}
    }
}

void CMainApp::append_message(const std::string&message)
{
    append_message(message.c_str());
}

void CMainApp::set_LogFileName()
{
    QString s;
    if (logfile.isEmpty()) {
	s = KFileDialog::getOpenFileName(0,"*.log");
	if (!s.isEmpty()) {
	    logfile = s;
	    filepointer.setName(s);
	    if (!filepointer.open(IO_WriteOnly | IO_Append))
		logfile = "";
	}
    }
    else {
	logfile = "";
	filepointer.close();
    }
    file->setItemChecked( logf,(logfile.isEmpty()?0:1) );
}

void CMainApp::disconnected_from_server()
{
    unsigned int i;
    int j;

    for (i = 0; i <= db_menu->count();i++) {
	j = db_menu->idAt(i);
	if (j > -1) {
	    db_menu->setItemEnabled(j,FALSE);
	}
    }
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(124);
    setCaption(head);
}

void CMainApp::connected_to_server(const char*msg)
{
    unsigned int i;
    int j;

    for (i = 0; i <= db_menu->count();i++) {
	j = db_menu->idAt(i);
	if (j > -1) {
	    db_menu->setItemEnabled(j,TRUE);
	}
    }
    QString head = CStringRes::get_string(125);head+=" - ";
    if (msg) {
	head+=msg;
    } else {
	head+="connected";
    }
    setCaption(head);
}

void CMainApp::new_window()
{
    CMainApp*dlg = new CMainApp;
    dlg->show();
}

void CMainApp::raus_hier()
{
    KTMainWindow * w;
    if (memberList) {
	for (w=memberList->first();w;w=memberList->first()) {
	    if (!w->close()) 
		break;
	}
    }
}

void CMainApp::windowClose()
{
    MainWidget->close();
    close();
}
