#include <Plugin.h>


bool Plugin::load(const char *libName)
  {
  errorCode = 0;
  errorString = "";
  path = libName;
  libPtr = dlopen(libName, RTLD_LAZY);
  if(libPtr == 0)
    {
    errorCode = -1;
    errorString = dlerror();
    return false;
    }
  createFunc = (CreateInstanceFuncType)dlsym(libPtr, "createInstance");
  if(createFunc == 0)
    {
    errorCode = -2;
    errorString = dlerror();
    return false;
    }
  deleteFunc = (DeleteInstanceFuncType)dlsym(libPtr, "deleteInstance");
  if(deleteFunc == 0)
    {
    errorCode = -3;
    errorString = dlerror();
    return false;
    }
	getNameFunc = (GetNameFuncType)dlsym(libPtr, "getName");
  if(getNameFunc == 0)
    {
    errorCode = -4;
    errorString = dlerror();
    return false;
    }
 	getInfoFunc = (GetNameFuncType)dlsym(libPtr, "getInfo");
  if(getInfoFunc == 0)
    {
    errorCode = -5;
    errorString = dlerror();
    return false;
    }
  return true;
  }

bool Plugin::unload(void)
  {
  errorCode = 0;
  errorString = "";
  if(libPtr)
    {
    errorCode = -1;
    return false;
    }
  dlclose(libPtr);
  return true;
  }

IObject *Plugin::createInstance(void)
	{
	errorCode = 0;
	errorString = "";
	IObject *instance = (*createFunc)();
  if(instance == 0)
    {
    errorCode = -1;
    errorString = "createInstance() failed";
    return 0;
    }
	return instance;
	}

bool Plugin::deleteInstance(IObject *instance)
	{
	errorCode = 0;
	errorString = "";
	int res = (*deleteFunc)(instance);
  if(res != 0)
    {
    errorCode = -1;
    errorString = "deleteInstance() failed";
    return false;
    }
  return true;	
	}
	
const char *Plugin::getPluginName(void)
	{
	errorCode = 0;
	errorString = "";
	const char *res = (*getNameFunc)();
	return res;
	}
	
const char *Plugin::getPluginInfo(void)
	{
	errorCode = 0;
	errorString = "";
	const char *res = (*getInfoFunc)();
	return res;
	}

const char *Plugin::getPluginPath(void)
	{
	errorCode = 0;
	errorString = "";
	return path;
	}
		
int Plugin::getErrorCode(void)
  {
  return errorCode;
  }

char *Plugin::getErrorString(void)
  {
  return errorString;
  }


