// $Id: testDBugMT.java,v 1.3 1997/10/16 10:34:31 xzhu Exp $

/**
  testDBugMT --  test DBug in Multi Thread environment

  The follow code modified from JavaWorld Sep, 1997, 
  "JavaBeans: properties, events, and thread safety"
  See the original article for Copyright information.

  java -DDBug.debug="-#d:t:L:n:C:m:N:P" testDBugMT
    use System.err to output all debugger and trace message.


  java -DDBug.debug="-#d:t:L:n:C:m:N:P:o,-" testDBugMT
    use System.out to output all debugger and trace message.
    

  java -DDBug.debug="-#d:t:L:n:C:m:N:P:o,1.out" testDBugMT
    use file 1.out to output all debugger and trace message.

  java -DDBug.debug="-#d:t,2:L:n:C:m:N:P" testDBugMT
    maxdepth = 2, all keywords

  java -DDBug.debug="-#d:t,2:L:n:C:m:N:P:p,main,dbThr2*" testDBugMT
    maxdepth = 2, thread: main, dbThr2*
 */
package zxk.util;

import java.awt.Point;

  // Demo Bean that does not guard against multiple thread use.
class BrokenProperties extends Point
{
    void setSpot(Point point) // 'spot' setter
    {
      this.x = point.x;
      this.y = point.y;
    }

    Point getSpot() // 'spot' getter
    {
      return this;
    }
}

public class testDBugMT extends Thread implements DBugConstant
{
  protected BrokenProperties myBean; // the target bean to bash..
  protected int myID; // each thread carries a bit of ID
  protected boolean quitFlag;

  // main() entry point
  public static void
  main (String[] args)
  {
    BrokenProperties bean;
    testDBugMT[] threads = new testDBugMT[20];
    
    // bean = (BrokenProperties) BeansKit.newBean("BrokenProperties");
    bean = new BrokenProperties();
    for (int i=0; i<20; ++i)
    {
      threads[i] = new testDBugMT(bean, i);
      threads[i].setName("dbThr" + (i + 1));
      threads[i].start();
    }

    try 
    {
        Thread.sleep(1000L);
    } catch (InterruptedException e) {}
    for (int i=0; i<20; ++i)
    {
      threads[i].setQuit(true);
    }

    if (zxk_debug)
    {
      DBug.dbug.dbPop();
    }
System.out.println("\nzxk exit");
  }

  // testDBugMT constructor
  public testDBugMT(BrokenProperties bean, int id)
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("testDBug()", "testDBugMT", 100);

    // other stuff ...
    this.myBean = bean;
    this.myID = id;
    this.quitFlag = false;

    if (zxk_debug)
      DBug.dbug.dbReturn(108);
  }

  // the thread main loop:
  //   do forever
  //     create new random Point with x == y
  //     tell bean to adopt Point as its new 'spot' property
  //     ask bean what its 'spot' property is now set to
  //     throw a wobbly if spot x does not equal spot y
  public void
  run()
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("run()", "testDBugMT", 121);

    while ( true )
    {
      doSomething();
      if (quitFlag)
      {
        this.stop();
	break;
      }
    }

    if (zxk_debug)
      DBug.dbug.dbReturn(134);
  }

  public void
  setQuit(boolean flag)
  {
    quitFlag = flag;
  }

  private void
  doSomething()
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("doSomething()", "testDBugMT", 147);

    int someInt;
    Point point = new Point();

    someInt = (int)(Math.random() * 100);
    point.x = someInt;
    point.y = someInt;
    myBean.setSpot(point);

    point = myBean.getSpot();
    if ( point.x != point.y )
    {
      System.out.println("Bean corrupted ! x= " + point.x + ", y= " + point.y);
      System.exit(10);
    }
    if (zxk_debug)
      DBug.dbug.dbPrint(164, "key",  "" + (char)('A' + myID));
    //System.out.print((char)('A' + myID));
    //System.out.flush();

    if (zxk_debug)
      DBug.dbug.dbReturn(169);
  }
}
