// $Id: test_connect.java,v 1.3 1997/11/19 18:19:22 xzhu Exp $
// test_connect.java
//
// This test is for testing how long it takes from computer
// to make $opt_loop_count connections. By changing the variable
// '$opt_loop_count' value you can make this test easier/harder
// to your computer to execute. You can also change this value
// by using option --loop_value='what_ever_you_like'.
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/14
//
// Copyright (C) 1997, X.K.ZHU
//   The `test_connect.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.
package bench;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class test_connect implements DBugConstant
{
  // Change this to make test harder/easier
  // This is the default value for the amount of tables used in this test.
  private int loopCount = 100;
  private int strLength = 32000;

  private long second_orig;
  private InputStream myIn;

  private boolean skipCreate;
  private boolean skipIn;
  private boolean skipDelete;
  private boolean verbose;
  private boolean fastInsert;
  private boolean lockTables;
  private boolean debug;
  private boolean fast;
  private boolean force;
  static private String debugStr = null;

  private test_connect()
  {
    second_orig = -1;
    myIn = System.in;

    skipCreate = false;
    skipIn = false;
    skipDelete = false;
    verbose = false;
    fastInsert = false;
    lockTables = false;
    debug = false;
    fast = false;
    force = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "force", "help", "host", "loop_value", 
      "password", "port", "user", "debug" };
    int[] loHasArg = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.OPT_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG };
    int[] loValue = { 'f', '?', 'h', 'l', 'p', 'P', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?fh:l:p::P:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = new String("test");
    int c;
    boolean tty_password = false;
    boolean error = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
            debugStr = g.getOptarg();
            break;
	  case 'f':
	    force = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'l':
	    String s1 = g.getOptarg();
	    if (s1 != null)
	      loopCount = new Integer(s1).intValue();
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (error)
    {
      System.out.println("Usage: java test_connect [OPTIONS]");
      System.out.println("\n" +
  "-#, --debug=opt      debug string, default is NO, see DBug.java for details\n" +
  "-?, --help		display this help and exit\n" + 
  "-h, --host=#		connect to host\n" +
  "-l, --loop_value=xxx	loop value.\n" +
  "-p, --password[=xxx]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-u, --user=#		user for login if not current user\n");
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();

    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    Connection conn = null;
    int i;

    System.out.println("Testing the speed of connecting to the server and sending of data");
    System.out.println("All tests are done " + loopCount + " times\n");
    
    /***************************** PART:1 ***************
     * Start timeing and start connect test..             
     ****************************************************/

    System.out.println("Testing connection/disconnect...");
    long zsec = second_orig = System.currentTimeMillis();
    for (i=0; i<loopCount; ++i)
    {
      conn = executeConnect(host, port, user, password, database);
      executeClose(conn);
    }
    System.out.println("Time to connect (" + loopCount +"): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

    try
    {
      /**************************** PART:2 ****************************
       * Now we shall do first one connect, then simple select
       * (select 1...) and then close connection. This will be
       * done loopCount times.
       ****************************************************************/    
      System.out.println("Test connect/simple_select/disconnect");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
      {
        conn = executeConnect(host, port, user, password, database);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        executeClose(conn);
      }
      System.out.println("Time to connect+select_simple (" + loopCount + "): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

      /************************** PART:3 ****************************
       * Next thing we'll do is a simple select loopCount times.
       *************************************************************/
      conn = executeConnect(host, port, user, password, database);
      System.out.println("Test simple select");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
      {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
      }
      System.out.println("Time for select_simple (" + loopCount + "): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

      /************************* PART:4 **************************
       * First, we'll create a simple table in db test.
       * Then we shall do loopCount selects from this table.
       * Table will contain very simple data.
       ***********************************************************/
      System.out.println("Testing " +loopCount+" selects from a table with 1 record");
      Statement stmt = conn.createStatement();
      int rows;
      if (force)
      {
        rows = stmt.executeUpdate("drop table test_1");
      }
      rows = stmt.executeUpdate("create table test_1 (auto int,id int, s char(10),primary key (auto))");
      rows = stmt.executeUpdate("insert into test_1 values(1,100,'AAA')");
      executeClose(conn);
      //
      // First test connect/select/disconnect
      //
      System.out.println("Testing connect/select 1 row from table/disconnect");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
      {
        conn = executeConnect(host, port, user, password, database);
        stmt = conn.createStatement();
        stmt.executeQuery("select * from test_1");
        executeClose(conn);
      }
      System.out.println("Time to connect+select (" + loopCount + "): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // The same test, but without connect/disconnect
      //
      System.out.println("Testing select 1 row from table");
      conn = executeConnect(host, port, user, password, database);
      stmt = conn.createStatement();
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
        stmt.executeQuery("select * from test_1");
      System.out.println("Time to select (" + loopCount + "): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // The same test, but with 2 rows.
      //
      System.out.println("Testing select 2 rows from table");
      rows = stmt.executeUpdate("insert into test_1 values(2,200,'BBB')");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
        stmt.executeQuery("select * from test_1");
      System.out.println("Time to connect: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      rows = stmt.executeUpdate("drop table test_1");
      /************************* PART:5 ******************************
       * We'll create one table with a single blob field,but with
       * a huge record in it and then we'll do loopCount selects
       * from it.
       **************************************************************/
      System.out.println("Testing retreival of big blobs");
      rows = stmt.executeUpdate("create table test_1 (b blob)");
      String s1 = new String(new byte[strLength]);
      rows = stmt.executeUpdate("insert into test_1 values('" + s1 + "')");
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
      {
        stmt.executeQuery("select * from test_1");
	//System.out.println("i " + i);
      }
      System.out.println("Time to select_big (" + loopCount + "): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      rows = stmt.executeUpdate("drop table test_1");
      executeClose(conn);
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }

    /*************************** END *********************
     * End of the test 
     * Finally print time used to execute the whole test
     ****************************************************/
    System.out.println("Toal time: " + (System.currentTimeMillis() - zsec)/1000.0 + " sec.");
  }

  private Connection executeConnect(String host, String port, String user, 
    String password, String database)
  {
    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
//System.out.println(url);

      return DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    return null;
  }

  private void executeClose(Connection conn)
  {
    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
    /* System.out.println("wait for 10 sec for closing...");
    try
    {
          Thread.sleep(10000);
    } catch (InterruptedException e) {}
    */
  }

  private int displayResult(ResultSet rs)
    throws SQLException
  {               
    int i;          
    int rows = 0;
    ResultSetMetaData rsmd = rs.getMetaData ();
    int numCols = rsmd.getColumnCount ();
        
    try 
    {
    boolean hasMore = rs.next();
    if (hasMore)
    {
      // Display column headings
      System.out.print("|");
      for (i=1; i<=numCols; i++) 
      {
        System.out.print(rsmd.getColumnName(i));
        System.out.print("\t|");
      }
      System.out.println("");
      // Display data, fetching until end of the result set
      while (hasMore) 
      {          
        rows++;    
        System.out.print("|");
        for (i=1; i<=numCols; i++) 
        {
          System.out.print(rs.getString(i));
  	System.out.print("\t|");
        }
        System.out.println("");
	hasMore = rs.next();
      }
    }       
    } 
    catch (SQLException e)
    { throw e; }

    return rows;
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != 10 && in != 13 && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  public static void main (String[] args) 
  {
    test_connect admin = new test_connect();
    admin.doit(args);
  }
}
