// $Id: test_big_tables.java,v 1.1 1997/11/19 18:19:21 xzhu Exp $
// test_big_tables.java
//
// port from perl script 'test-big-tables'
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/11/14
//
// Copyright (C) 1997, X.K.ZHU
//   The `test_big_tables.java' 
//   is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.
package bench;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class test_big_tables implements DBugConstant
{
  // Change this to make test harder/easier
  // This is the default value for the amount of tables used in this test.
  private int loopCount = 10;
  private int fieldCount = 1000;

  private long second_orig;
  private InputStream myIn;

  private boolean skipIn;
  private boolean verbose;
  private boolean debug;
  private boolean force;
  private boolean fast;

  private test_big_tables()
  {
    second_orig = -1;
    myIn = System.in;

    verbose = false;
    debug = false;
    force = false;
    fast = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "force", "help", "host", "loop_value", 
      "password", "port", "user", "debug" };
    int[] loHasArg = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG };
    int[] loValue = { 'f', '?', 'h', 'l', 'p', 'P', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?fh:l:p::P:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = new String("test");
    String debugStr = null;
    int c;
    boolean tty_password = false;
    boolean error = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
            debugStr = g.getOptarg();
            break;
	  case 'f':
	    force = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'l':
	    String s1 = g.getOptarg();
	    if (s1 != null)
	      loopCount = new Integer(s1).intValue();
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (error)
    {
      System.out.println("Usage: java test_connect [OPTIONS]");
      System.out.println("\n" +
  "-#, --debug=opt      debug string, default is NO, see DBug.java for details\n" +
  "-?, --help		display this help and exit\n" + 
  "-h, --host=#		connect to host\n" +
  "-f, --force		force drop table.\n" +
  "-l, --loop_value=xxx	loop value.\n" +
  "-p, --password[=xxx]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-u, --user=#		user for login if not current user\n");
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();

    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    Connection conn;
    long zsec = System.currentTimeMillis();

    System.out.println("Testing of some extream situations");
    System.out.println("All tests are done " + loopCount + " times\n");
    //
    // Testing many fields
    //
    conn = executeConnect(host, port, user, password, database);
    System.out.println("Testing table with " + fieldCount + " fields");
    try
    {
      if (force)
      {
        System.out.println("Okay, Let's make sure that our tables don't exist yet.");
        Statement stmt = conn.createStatement();
	stmt.executeUpdate("drop table test_1");
      }
      System.out.println("Initializing data...");
      StringBuffer types = new StringBuffer("i_1 int");
      StringBuffer values = new StringBuffer("1");
      StringBuffer fields = new StringBuffer("i_1");
      for (int i=2; i<=fieldCount; ++i)
      {
         types.append(",i_" + i + " int");
	 fields.append(",i_" + i);
	 values.append(",1");
      }

      Statement stmt = conn.createStatement();
      stmt.executeUpdate("create table test_1 (" + types.toString() + ")");
      stmt.executeUpdate("insert into test_1 values (" + values.toString() + ")");
      testQuery("Testing select * from table with 1 record",
        "Time to select", 
	"select * from test_1", conn);
      testQuery("Testing select all_fields from table with 1 record",
        "Time to select", 
	"select "+fields.toString()+" from test_1", conn);
      testQuery("Testing insert VALUES()",
        "Time to insert", 
	"insert into test_1 values ("+values.toString()+")", conn);
      testQuery("Testing insert (all_fields) VALUES()",
        "Time to insert", 
	"insert into test_1 ("+fields.toString()+") values ("+values.toString()+")", conn);
      stmt.executeUpdate("drop table test_1");
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    executeClose(conn);

    // End of the test 
    // Finally print time used to execute the whole test
    System.out.println("Toal time: " + (System.currentTimeMillis() - zsec)/1000.0 + " sec.");
  }

  private void
  testQuery(String testText, String resultText, String query, Connection conn)
  {
    long second_orig = 0;
    try
    {
      System.out.println(testText);
      second_orig = System.currentTimeMillis();
      Statement stmt = conn.createStatement();
      for (int i=0; i<loopCount; ++i)
        stmt.execute(query);
      System.out.println(resultText + ": " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
  }

  private Connection 
  executeConnect(String host, String port, String user, 
    String password, String database)
  {
    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
//System.out.println(url);

      return DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    return null;
  }

  private void executeClose(Connection conn)
  {
    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
    /* System.out.println("wait for 10 sec for closing...");
    try
    {
          Thread.sleep(10000);
    } catch (InterruptedException e) {}
    */
  }

  private int displayResult(ResultSet rs)
    throws SQLException
  {               
    int i;          
    int rows = 0;
    ResultSetMetaData rsmd = rs.getMetaData ();
    int numCols = rsmd.getColumnCount ();
        
    try 
    {
    boolean hasMore = rs.next();
    if (hasMore)
    {
      // Display column headings
      System.out.print("|");
      for (i=1; i<=numCols; i++) 
      {
        System.out.print(rsmd.getColumnName(i));
        System.out.print("\t|");
      }
      System.out.println("");
      // Display data, fetching until end of the result set
      while (hasMore) 
      {          
        rows++;    
        System.out.print("|");
        for (i=1; i<=numCols; i++) 
        {
          System.out.print(rs.getString(i));
  	System.out.print("\t|");
        }
        System.out.println("");
	hasMore = rs.next();
      }
    }       
    } 
    catch (SQLException e)
    { throw e; }

    return rows;
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != 10 && in != 13 && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  public static void main (String[] args) 
  {
    test_big_tables admin = new test_big_tables();
    admin.doit(args);
  }
}
