/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;

import com.ice.util.AWTUtilities;


public class
MainFrame extends JFrame
		implements ActionListener
	{
	private static MainFrame	instance;

	private JMenu		dbMenu;
	private JMenuBar	menuBar;
	private MainPanel	mainPanel;


	public static void
	hideDatabaseMenu()
		{
		instance.menuBar.remove
			( instance.menuBar.getComponentIndex
				( instance.dbMenu ) );
		instance.invalidate();
		instance.validate();
		instance.repaint();
		}

	public static void
	showDatabaseMenu( String[] dbList, String currDb )
		{
		instance.dbMenu.removeAll();

		ButtonGroup grp = new ButtonGroup();

		for ( int i = 0 ; i < dbList.length ; ++i )
			{
			JRadioButtonMenuItem item =
				new JRadioButtonMenuItem( dbList[i] );

			if ( currDb != null )
				{
				if ( currDb.equals( dbList[i] ) )
					item.setSelected( true );
				else
					item.setSelected( false );
				}

			item.addActionListener( instance );
			item.setActionCommand( "NEWDB:" + dbList[i] );

			grp.add( item );

			instance.dbMenu.add( item );
			}

		instance.menuBar.add( instance.dbMenu );
		instance.invalidate();
		instance.validate();
		instance.repaint();
		}


	public
	MainFrame( String title )
		{
		super( title );

		MainFrame.instance = this;

		this.mainPanel = new MainPanel();
		
		this.getContentPane().add( this.mainPanel );

		this.establishMenuBar();
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "QUIT" ) )
			{
			System.exit(0);
			}
		else if ( command.startsWith( "NEWDB:" ) )
			{
			String dbName = command.substring(6);
			this.changeDatabase( dbName );
			}
		else if ( command.startsWith( "PLAF:" ) )
			{
			String plafClassName = command.substring(5);
			this.changeLookAndFeel( plafClassName );
			}
		else
			{
			System.err.println
				( "UNKNOWN Command '" + command + "'" );
			}
		}

	private boolean
	changeDatabase( String dbName )
		{
		boolean result = true;

		SQLClientHandler handler =
			SQLClientHandler.getCurrentHandler();

		if ( handler == null )
			{
			this.showMessage
				( "INTERNAL ERROR: current handler is null." );
			return false;
			}

		if ( ! handler.isOpen() )
			{
			this.showMessage
				( "INTERNAL ERROR: connection is not open." );
			return false;
			}

		try {
			handler.setCurrentDatabase( dbName );
			this.mainPanel.dbHasChanged( dbName );
			this.showMessage( "Database changed to '" + dbName + "'" );
			}
		catch ( SQLException ex )
			{
			result = false;
			this.showMessage
				( "SQLException: changing database to '"
					+ dbName + "':\n" + ex.getMessage() );
			}

		return result;
		}

	private void
	changeLookAndFeel( String plafClassName )
		{
		String plafName;
		int index = plafClassName.lastIndexOf( plafClassName );
		if ( index < 0 )
			plafName = plafClassName;
		else
			plafName = plafClassName.substring( index + 1 );

		if ( false )
		System.err.println
			( "New Look And Feel: " + plafClassName );

		try {
			UIManager.setLookAndFeel( plafClassName );
			SwingUtilities.updateComponentTreeUI
				( this.getRootPane() );
			}
		catch ( IllegalAccessException ex )
			{
			this.lookAndFeelExMessage
				( plafName, plafClassName, ex.getMessage(),
					"could not be accessed" );
			}
		catch ( InstantiationException ex )
			{
			this.lookAndFeelExMessage
				( plafName, plafClassName, ex.getMessage(),
					"could not be instantiated" );
			}
		catch ( ClassNotFoundException ex )
			{
			this.lookAndFeelExMessage
				( plafName, plafClassName, ex.getMessage(),
					"could not be located" );
			}
		catch ( UnsupportedLookAndFeelException ex )
			{
			this.lookAndFeelExMessage
				( plafName, plafClassName, ex.getMessage(),
					"is not supported on this platform" );
			}
		}

	private void
	showMessage( String msg )
		{
		System.err.println( msg );
		}

	private void
	lookAndFeelExMessage(
			String name, String className,
			String exMsg, String msg )
		{
		System.err.println
			( "Look and feel '" + name + "' " + msg + "." );
		
		if ( exMsg.length() > 0 )
			System.err.println( "\t" + exMsg );
		}

	private void
	createDBMenu()
		{
		this.dbMenu = new JMenu( "DB" );
		}

	private void
	establishMenuBar()
		{
		this.menuBar = new JMenuBar();

		JMenu menu = new JMenu( "File" );
		this.menuBar.add( menu );

		JMenuItem item = new JMenuItem( "Quit" );
		item.addActionListener( this );
		item.setActionCommand( "QUIT" );
		item.setAccelerator
			( KeyStroke.getKeyStroke
				( KeyEvent.VK_Q, Event.CTRL_MASK ) );
		menu.add( item );

		this.addLookAndFeelMenu( this.menuBar );

		this.createDBMenu();

		this.setJMenuBar( this.menuBar );
		}

	private void
	addLookAndFeelMenu( JMenuBar mbar )
		{
		JMenu menu = new JMenu( "Look" );
		mbar.add( menu );

		UIManager.LookAndFeelInfo[] info =
			UIManager.getInstalledLookAndFeels();

		for ( int idx = 0 ; idx < info.length ; ++idx )
			{
			JMenuItem item = new JMenuItem( info[idx].getName() );
			item.addActionListener( this );
			item.setActionCommand( "PLAF:" + info[idx].getClassName() );
			menu.add( item );
			}
		}
	
	}

