#ifndef CGI_FORM_H
#define CGI_FORM_H

#include <string>
#include <map>
#include <vector>

#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "cgi_die.h"

class CgiInput
 {
  public:

  string form_name;
  string name;
  string type;
  mutable string storage;
  mutable vector<string> values;
  mutable map<string, string, less<string> > param_hash;

  CgiInput() {}
  CgiInput(const CgiInput& other) 
   {
    if(this != &other)
     *this = other;
   }

  CgiInput& operator = (const CgiInput& other)
   {
    if(this != &other)
    {
     name = other.name;
     form_name = other.form_name;
     type = other.type;
     storage = other.storage;
     values = other.values;
     param_hash = other.param_hash;
    }
    return *this;
   }

  int operator == (const CgiInput& other) const
   {
    return name == other.name;
   }

  void write_sql_create(ofstream& os) const;
  void write_form_mem_decl(ofstream& os) const ;
  void write_parse_val_buf_name(ofstream& os) const ;
  void infer_storage() const;
 };


class CgiForm
 {
  protected:
   vector <CgiInput> inputs;

  public:
   string name;
   string method;
   static int num_post_forms;
   static int num_get_forms;

   CgiForm();
   ~CgiForm();
   
   int input_found(const CgiInput& in) const;
   const CgiInput* find_input(const CgiInput& in) const;

   void add_input(const char* name, const char* type, const char* val = "")
    {
     CgiInput cgi_in;
     cgi_in.name = name;
     cgi_in.type = type;
     add_input(cgi_in, val);
    }
   
   void add_input(const CgiInput& cgi_in, const char* val = "" );

   void set_method(const char* init_method)
    {
     method = init_method;
     if(!strcasecmp("post", init_method))
      num_post_forms++;
     else
      num_get_forms++;
    }

   const CgiInput& operator[] (int i) const { return inputs[i]; } 
   unsigned int size() const	{ return inputs.size(); }
   void write_c(ofstream& os);
   void write_c_parse(ofstream& os);
   void write_c_parse_get(ofstream& os);
   void write_c_parse_post(ofstream& os);
   void write_c_parse_assign(ofstream& os, unsigned int i);
   void write_c_parse_assign(ofstream& os, 
       const char* input_name, const char* storage_var = 0,
        const char* result_var = 0,  
        int do_atoi = 0) ;
   void write_init_inputs(ofstream& os) ;
 
   void write_sql_create_table(ofstream& os) const;
   void write_sql_drop_table(ofstream& os) const;
 };

#endif
