#!/usr/bin/perl
###########################################################################
#    Mysql Web based Administration
#    Written by Ying Gao, gaoying@hotmail.com, http://billow.cjb.net
#    It's a free script. You can modify it freely!
###########################################################################

use gymysqlvars qw(%Config);
use gymysql     qw($dbh);
use strict;
use vars       qw($TableName); 

$| = 1;
gymysql::check_refer();

my $message = "";
my %input = gymysql::Get_Form_Data(0);
gymysql::GetSetDatabaseInfo($input{'dbname'});
$TableName         = $input{'table'};

gymysql::send_header("$Config{'sitename'}");
gymysql::db_connect();
gymysql::table_header(gymysql::ShowIndex(4,"",$TableName));

if($input{'Action'} eq "ShotCut")
{
	$message = gymysql::RunShortcut_Key($input{'Short_Index'});
	$input{'sqlcommand'} = $message;
}
elsif($input{'Action'} eq "EDIT")
{
	my $returnvalue = &Editrecord(\%input);
	$message = "Updated a record!: <br><b>$returnvalue</b>";
}
elsif($input{'Action'} eq "DEL")
{
	my $returnvalue = &Delrecord(\%input);
	$message = "Del a record!: <br><b>$returnvalue</b>";
}
elsif($input{'Action'} eq "Execute")
{
	unless($input{'sqlcommand'} =~ m"Select(.*?)From "si)
	{
	      gymysql::Runsqlcommand($input{'sqlcommand'});
	}
	$message = "Run Command:<br><b><pre>$input{'sqlcommand'}</pre></b>";
}

&ShowTableContent($input{'IndexNo'},$message,$input{'sqlcommand'});
gymysql::db_disconnect();
gymysql::exit;

sub Editrecord
{
	my $inputhash = shift;
	my $searchstr = "";
	my $setstr    = "";
	my $name;

        foreach $name (keys %$inputhash)
        {
        	if ($name =~ m/^field_(.*)/) 
        	{
                    if($$inputhash{$name} ne '')
                    {
                        if ($searchstr ne '') 
                        {
                             $searchstr .= ' and ';
                        }
                        my $sqlquota = $dbh -> quote ($$inputhash{$name});
                        $searchstr .= "$1=$sqlquota";
                    }
        	}
        	if ($name =~ m/^update_(.*)/) 
        	{
                    if ($setstr ne '') 
                    {
                             $setstr .= ', ';
                    }
                    my $sqlquota = $dbh -> quote ($$inputhash{$name});
                    $setstr .= "$1=$sqlquota";
                }
        	
        }
        my $cursor;
        $cursor=$dbh->prepare("update $TableName set $setstr where $searchstr") || gymysql::cgi_error("Update failed, Reason: <em>$DBI::errstr</em>");
        $cursor->execute;
        $cursor->finish;
        return "update $TableName set $setstr where $searchstr";
}

sub Delrecord
{
	my $inputhash = shift;
	my $delstr = "";
	my $name;

        foreach $name (keys %$inputhash)
        {
        	if ($name =~ m/^field_(.*)/) 
        	{
                    #if($$inputhash{$name} ne '')
                    #{
                        if ($delstr ne '') 
                        {
                             $delstr .= ' and ';
                        }
                        my $sqlquota = $dbh -> quote ($$inputhash{$name});
                        $delstr .= "$1=$sqlquota";
                    #}
        	}
        }
        my $cursor;
        $cursor=$dbh->prepare("delete from $TableName where $delstr") || gymysql::cgi_error("Delete failed, Reason: <em>$DBI::errstr</em>");
        $cursor->execute;
        return "delete from $TableName where $delstr";
}

sub ShowTableContent
{
	my ($indexno,$message,$select) = @_;
	my $EncodeTableName  = gymysql::url_encode($TableName);
	my $EncodeSqlcommand = gymysql::url_encode($select);
	my $EncodeDBName     = gymysql::url_encode($Config{'dbname'});
        my $selectitems     = "*";

        my ($cursor,@databases,@list,%primarykeys,$x,);
        my (@primarykeys,@fielddesc,@fields,@fieldtypes) = ();
        	
	$indexno =~ s/\D//g;
	$indexno = int($indexno);
	
	unless($select =~ /SELECT/i)
	{
	     $select = "";
	}
	
	if($select eq "")
	{
	   $select = qq~
SELECT *
FROM $TableName
LIMIT $Config{'listnum'}
~;
        }
        elsif($select =~ m"Select(.*?)From "si)
        {
        	$selectitems = $1;
        	$selectitems =~ s/ |\n|\r//g;
        	if($selectitems ne "*")
        	{
        		@fields = split(/\,/,$selectitems);
        	}
        }
        
        if($selectitems eq "*")
        {
             $cursor = $dbh->prepare("describe $TableName") || gymysql::cgi_error("Show table content failed, Reason: <em>$DBI::errstr</em>");
             $cursor->execute;
             while (@fielddesc = $cursor->fetchrow) 
             {
                   push @fields, $fielddesc[0];
                   push @fieldtypes, $fielddesc[1];
                   if ($fielddesc[3] eq 'PRI') 
                   {
                        push @primarykeys, $fielddesc[0];
                        $primarykeys{$fielddesc[0]} = 1;
                   }
             }
        }

my $tdnum = @fields + 2;
print qq~
<br>
<table align=center border=1 cellpadding=0 cellspacing=0>
<tr bgcolor="$Config{'tableheader'}"><td align=center colspan=$tdnum><font size=+2>Table <font color=BLUE>$TableName</font> Contents</font></td></tr>
~;

my $fieldname;
my @fieldnames = @fields;

print "<tr bgcolor=$Config{'itemheader0'}><td align=center><font color=BLUE>Edit</font></td>";
while ($fieldname = shift @fields)
{
  print "<td align=center>$fieldname</td>";
}
print "<td align=center><font color=BLUE>Delete</font></td></tr>\n";

if($selectitems eq "*")
{
    print "<tr bgcolor=$Config{'itemheader1'}><td align=center><font color=BLUE>&nbsp;</font></td>";
    while ($fieldname = shift @fieldtypes)
    {
        print "<td align=center>$fieldname</td>";
    }
    print "<td align=center><font color=BLUE>&nbsp;</font></td></tr>\n";
}

$cursor=$dbh->prepare($select) || gymysql::cgi_error("Prepare failed: $select, Reson: <em>$DBI::errstr</em>");
$cursor->execute;
my($select_str,$table_str,@record,$field);

my $coloridx = 0;
while (@record = $cursor->fetchrow) {
  $select_str = '';
  $table_str = '';
  for ($x = 0; $x < $#record + 1; $x ++) 
  {
    $field = $record[$x];
    if (($#primarykeys == -1) || (exists $primarykeys{$fieldnames[$x]})) {
        my $encodefiled = gymysql::url_encode($field);
        $select_str .= "field_$fieldnames[$x]=$encodefiled&";
    }
    $table_str .= "<td>$field&nbsp;</td>\n";
  }
  if($selectitems eq "*")
  {
      print "<tr bgcolor=$Config{'itemcolor'.$coloridx}><td align=center><a href='mod_record.pl?dbname=$EncodeDBName&table=$EncodeTableName&sqlcommand=$EncodeSqlcommand&$select_str'><img src='$Config{'docurl'}/ball.green.gif' border=0></a></td>\n";
  }
  else
  {
      print "<tr bgcolor=$Config{'itemcolor'.$coloridx}><td align=center>&nbsp;</td>\n";
  }
  print $table_str;
  if($selectitems eq "*")
  {
       print "<td  align=center><a href='$ENV{'SCRIPT_NAME'}?Action=DEL&dbname=$EncodeDBName&table=$EncodeTableName&sqlcommand=$EncodeSqlcommand&$select_str'><img src='$Config{'docurl'}/ball.purple.gif' border=0></a></td></tr>\n";
  }
  else
  {
       print "<td  align=center>&nbsp;</td></tr>\n";
  }
  $coloridx = ($coloridx) ? 0:1;
}
$cursor->finish;

my $tablename_q = $dbh -> quote($TableName);
print qq~
</table>
<table align=center><tr><td align=center>
<form method=post action='$ENV{'SCRIPT_NAME'}?dbname=$EncodeDBName&table=$EncodeTableName'>
<select size=8 name=Short_Index>
~;

my $query = qq~
    SELECT  ID, Name
    FROM    _ScriptFile
    WHERE   TableName=$tablename_q AND Attrib = 'TB' OR Attrib = 'AL'
    ORDER   BY Name
~;
$cursor=$dbh->prepare("$query") || gymysql::cgi_error("Prepare failed: $query, Reson: <em>$DBI::errstr</em>");
$cursor->execute;
while (my($id,$name) = $cursor->fetchrow)
{
	print "<option value=\"$id\">$name</optin>\n";
}
$cursor->finish;

print qq~
</select><br>
<input type=hidden name=Action value='ShotCut'>
<input type=submit value='Run Script Files'>
</form></td><td align=center>
~;

print qq~
<form method=post action='$ENV{'SCRIPT_NAME'}?dbname=$EncodeDBName&table=$EncodeTableName'>
<table border=0 width=90% align=center>
  <tr align=center>
    <td>
      Enter new SQL statement:<BR>
    </td>
  </tr>
  <tr align=center>
    <td>
      <textarea name=sqlcommand cols=40 rows=6 wrap=off>$select</textarea>
    </td>
  </tr>
  <tr align=center>
    <td>
      <input type=submit name=Action value='Execute'>
    </td>
  </tr>
  <tr align=center>
    <td>
      <a href='insert.pl?dbname=$EncodeDBName&table=$EncodeTableName&sqlcommand=$EncodeSqlcommand'>Insert New Record</a>
    </td>
  </tr>
</table>
</form>
</td></tr></table>
~;

print "<hr>$message<hr>" if($message);

gymysql::send_footer();
}