#!/usr/bin/perl
###########################################################################
#    Mysql Web based Administration
#    Written by Ying Gao, gaoying@hotmail.com, http://billow.cjb.net
#    It's a free script. You can modify it freely!
###########################################################################

use gymysqlvars qw(%Config);
use gymysql     qw($dbh);
use strict;
use vars       qw($TableName); 

$| = 1;
gymysql::check_refer();

my $message = "";
my %input = gymysql::Get_Form_Data(0);
gymysql::GetSetDatabaseInfo($input{'dbname'});
$TableName         = $input{'table'};

my $EncodeDBName    = gymysql::url_encode($Config{'dbname'});
my $EncodeTableName = gymysql::url_encode($TableName);
my $EncodeSqlcommand = gymysql::url_encode($input{'sqlcommand'});

gymysql::send_header("$Config{'sitename'}");

gymysql::db_connect();

gymysql::table_header(gymysql::ShowIndex(4,"Edit Record",$TableName));

my $cursor;
$cursor=$dbh->prepare("describe $TableName") || gymysql::cgi_error("Describe $TableName failed, <em>$DBI::errstr</em>");
$cursor->execute;

my(@fields,@fieldtypes,@fielddesc) = ();

while (@fielddesc = $cursor->fetchrow) {
  push @fields, $fielddesc[0];
  push @fieldtypes, $fielddesc[1];
}

print qq~
<center><h2>Modify the record in the table <font color=BLUE>$TableName</font>.</h2></center>
<form method=post action='table.pl?dbname=$EncodeDBName&table=$EncodeTableName&sqlcommand=$EncodeSqlcommand&Action=EDIT'>
~;

print "<table align=center border=1 cellpadding=0 cellspacing=0>\n";
print "<tr bgcolor=$Config{'itemheader0'}><td align=center>FieldName</td><td align=center>Type</td><td align=center>Value</td></tr>";

my($name,$searchstr) = ();
foreach $name (keys %input)
{
        	if ($name =~ m/^field_(.*)/) 
        	{
                    my $fieldname = $1;
                    my $value = $input{$name};
                    $value =~ s/\\/\\\\/g;
                    $value =~ s/\'/\\\'/g;
                    print "<input name=$name value='".$value."' type=hidden>\n";
                    if($input{$name} ne '')
                    {
                        if ($searchstr ne '') 
                        {
                             $searchstr .= ' and ';
                        }
                        my $sqlquota = $dbh -> quote ($input{$name});
                        $searchstr .= "$fieldname=$sqlquota";
                    }
        	}
}
$cursor=$dbh->prepare("select * from $TableName where $searchstr") || gymysql::cgi_error("Select failed: <em>$DBI::errstr</em>");
$cursor->execute;
my @record = $cursor->fetchrow;

my($field,$fieldname,$fielddesc);
my $coloridx = 0;

while ($#fields > -1) {
  $field = shift @record;
  $fieldname = shift @fields;
  $fielddesc = shift @fieldtypes;

  print "<tr bgcolor=$Config{'itemcolor'.$coloridx}><td>$fieldname</td>\n";  
  print "<td>$fielddesc</td>\n<td>";
  print webeditfield($fielddesc, "update_$fieldname", $field);
  print "\n</td></tr>\n";
  $coloridx = ($coloridx) ? 0:1;  
}

print qq~
</table>
<center><input type=submit value='Update Record'> <input type=reset></center>
</form>
~;

gymysql::send_footer();
gymysql::db_disconnect();
gymysql::exit;


sub webeditfield {
  my $result = "";
  my($type, $name, $val) = @_;
  my($x);
  $x = $1 if($type =~ /.\((\d+)/);
  
  
  if (substr($type, 0, 5) eq 'enum(') 
  {
    my $args = substr($type, 5, -1);
    my @list = split(/,/, $args);
    $result .= "<select name=$name>";
    while (my $option = shift @list) {
      if ($option =~ /^'(.*)'$/) {
        $option = $1;
      }
      if ($option eq "$val") {
        $result .= "<option selected>";
      } else {
        $result .= "<option>";
      }
      $result .= "$option\n";
    }
    $result .= "</select>";
  }
  elsif(($type eq "text") || ($x > 60))
  {
  	$result .= "<textarea name='$name' cols=50 rows=4>$val</textarea>";
  }
  elsif($x > 0)
  {
  	$result .= "<input name='$name' value='$val' size='$x' maxlength='$x'>";
  }
  else
  {
  	$result .= "<input name='$name' value='$val' size='30'>";
  }
  return $result;
}
