/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: msqlacc.c,v $
    Module Description:	Virtual interface to msql database engine

Description: 

Created on   26 Apr 1995    By damian

Edit History:

	$Log: msqlacc.c,v $
 * Revision 1.2  1997/09/02  12:06:45  damian
 * use Vdbmsg error message pointer
 *
	Revision 1.1  1997/08/21 18:08:59  damian
	Initial revision

	Revision 2.4  1996/11/29 11:39:18  damian
	include memory.h

 * Revision 2.3  1996/11/06  10:55:58  damian
 * do selective logging and backup server
 *
 * Revision 2.2  1996/07/03  14:48:37  damian
 * add logging code
 *
 * Revision 2.1  1996/01/04  11:44:51  V
 * Version 2
 * change seperator arg to int
 *
 * Revision 1.1  1995/12/21  18:09:08  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: msqlacc.c,v 1.2 1997/09/02 12:06:45 damian Exp damian $";

/* must come first header files  */
#include "V.h"
#include "Vport.h"


/*
 * system header files 
*/
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#include <memory.h>

/*
 * third party headers ie, X, informix, ctree 
*/

/*
 * project header files 
*/
#include "Vlib.h"
#include "msql.h"
#include "Vdb.h"

#include "dflts.h"

/*
 * local header files 
*/

/*
 * local defines 
*/

#ifdef Vsunos40
#include "Vansi.h"
#endif


/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

/*
 * static functions 
*/

/*
 * non static functions 
*/

typedef struct {
    int   	dbh;
    m_result    *res;
    int         rpos;
    m_row   row;
    int         nrows;
    int         nfields;
    int     	inuse;
} DBhandle;

static DBhandle *dbs = NULL;
static DBhandle *bkdbs = NULL;

static int numhandles = 0;

static char *user = NULL;
static char *passwd = NULL;

int
MsqlaccNumrows(int handle)
{
    return dbs[handle].nrows;
}

int
MsqlaccNumfields(int handle)
{
    return dbs[handle].nfields;
}


static char *backup_server = NULL;
static int  backup_queries = FALSE;

static char errbuf[1024];

int
MsqlInit(char *init_user, char *init_passwd)
{
    DBhandle	*db;
    int         j;

/*
   we'll leave this in in case mSQL gets user password checking
   at a later date 

    if (init_user)
	user = strdup(init_user);

    if ( init_passwd)
	passwd = strdup(init_passwd);
*/

    numhandles = 16;

    dbs = malloc(sizeof(DBhandle) * numhandles);

    for(j = numhandles - 16; j < numhandles; j++) {
      db = &dbs[j];
      memset(db, 0, sizeof(DBhandle));
    }

    return 0;
}

/* 
 * connect to database engine on specified host
*/
int
MsqlaccConnect(char *host)
{
    int     i, j;
    DfltsInfo   di;
    char    *val;
    DBhandle	*db;

    Vdbmsg = errbuf;
    errbuf[0] = '\0';

    if ( numhandles == 0)
	MsqlInit(NULL, NULL);

    if ( backup_server == NULL) {

	memset(&di, 0, sizeof(di));
	di.group = "msql";
	di.tag = "backup_server";
	di.base = ANY_DFLT_SET;

	if ((val = DfltGetString(&di)) == NULL)
	    backup_server = "";
	else
	    backup_server = strdup(val);

	di.tag = "backup_queries";
	di.base = ANY_DFLT_SET;
	backup_queries = DfltGetBool(&di);

    }
    /* find a free handle */
    for(i = 0 ; i < numhandles; i++) {
	if (dbs[i].inuse == 0)
	    break;
    }

    if ( i == numhandles) {
	if (i < NOFILE) {
	    numhandles += 16;

	    if (dbs != NULL) {
		dbs = realloc(dbs, sizeof(DBhandle) * numhandles);
		bkdbs = realloc(bkdbs, sizeof(DBhandle) * numhandles);
	    } else
		dbs = malloc(sizeof(DBhandle) * numhandles);

	    for(j = numhandles - 16; j < numhandles; j++) {
		db = &dbs[j];
		memset(db, 0, sizeof(DBhandle));
	    }

	} else {
	    Vdbmsg = "Couldn't connect to engine! no more handles\n";
	    return -1;
	}
    }

    dbs[i].inuse = 1;

    if ( (dbs[i].dbh = msqlConnect(host)) < 0 )
	sprintf(errbuf, "Couldn't connect to engine! - %s\n", 
		msqlErrMsg);

    if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	if ( (bkdbs[i].dbh = msqlConnect(backup_server)) < 0 )
	    sprintf(errbuf, "Couldn't connect to backup server! - %s\n", 
		    msqlErrMsg);
    }

    return i;
}

/*
 * select a database
*/
int
MsqlaccSelect(int handle, char *db)
{
    int     err;
    
    Vdbmsg = errbuf;
    errbuf[0] = '\0';

    if ( (err = msqlSelectDB(dbs[handle].dbh,db)) < 0 ) {
	sprintf(errbuf, "Couldn't select database [%s]! - %s\n", 
		db, msqlErrMsg);
    }

    if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	if ( (err = msqlSelectDB((int)bkdbs[handle].dbh,db)) < 0 ) {
	    sprintf(errbuf, 
		    "Couldn't select database on backup server [%s]! - %s\n", 
		    db, msqlErrMsg);
	}
    }
    return err;

}

static char     *msql_logfile = NULL;
static int      log_queries = FALSE;
static int      do_insert = FALSE;
static int      do_update = FALSE;
static int      do_delete = FALSE;
static int      do_select = FALSE;

static StringList     incsl = NULL;
static StringList     excsl = NULL;
static int      include_num;
static int      exclude_num;


/*
 * perform a database query
*/
int
MsqlaccQuery(int handle, char *dbname, char *query)
{
    
    int     err, do_logging = FALSE, num;
    DfltsInfo   di;
    char    *val;
    FILE    *lfp;
    DBhandle	*db;

    db = &dbs[handle];

    Vdbmsg = errbuf;
    errbuf[0] = '\0';

    errno = 0;

    /* log the query if logging is enabled */

    if ( msql_logfile == NULL ) {

	memset(&di, 0, sizeof(di));
	di.group = "msql";
	di.tag = "log_file";
	di.base = ANY_DFLT_SET;

	/* if the logfile isn't specified then set logfile to "" so we don't
	   keep trying to get the tag's value */

	if ((val = DfltGetString(&di)) == NULL)
	    msql_logfile = "";
	else
	    msql_logfile = strdup(val);

	di.tag = "log_queries";
	di.base = ANY_DFLT_SET;
	log_queries = DfltGetBool(&di);

	di.tag = "log_insert";
	di.base = ANY_DFLT_SET;
	do_insert = DfltGetBool(&di);

	di.tag = "log_delete";
	di.base = ANY_DFLT_SET;
	do_delete = DfltGetBool(&di);

	di.tag = "log_update";
	di.base = ANY_DFLT_SET;
	do_update = DfltGetBool(&di);

	di.tag = "log_select";
	di.base = ANY_DFLT_SET;
	do_select = DfltGetBool(&di);

#ifdef 0
	di.tag = "log_include";
	di.base = ANY_DFLT_SET;
	if ((val = DfltGetString(&di)) != NULL) {
	    incsl = StringListFromString(val, ';');
	    include_num = CountStringList(incsl);
	}

	di.tag = "log_exclude";
	di.base = ANY_DFLT_SET;
	if ((val = DfltGetString(&di)) != NULL) {
	    excsl = StringListFromString(val, ';');
	    exclude_num = CountStringList(excsl);
	}
#endif

    }

    if ( msql_logfile && msql_logfile[0] && log_queries == TRUE) {

	switch( query[0] ) {
	case 'i':
	case 'I':
	    do_logging = do_insert;
	    break;
	case 'u':
	case 'U':
	    do_logging = do_update;
	    break;
	case 'd':
	case 'D':
	    do_logging = do_delete;
	    break;
	case 's':
	case 'S':
	    do_logging = do_select;
	    break;
	}

	/* work out if the query matches an include or exclude
	   pattern */

	/* if the pattern is explicitly excluded then turn logging off
	   for this query, we don't need to check if logging is
	   already FALSE */
	if ( excsl != NULL && do_logging == TRUE )
	    for(num = 0; num < exclude_num ; num++) {
		if ( strstr(query, excsl[num]) != NULL) {
		    do_logging = FALSE;
		    break;
		}
	    }

	/* if pattern is explicitly included then turn logging on
	   for this query,  we don't need to check if logging is
	   already TRUE */
	if ( incsl != NULL && do_logging == FALSE)
	    for(num = 0; num < include_num ; num++) {
		if ( strstr(query, incsl[num]) != NULL) {
		    do_logging = TRUE;
		    break;
		}
	    }

	if ( do_logging == TRUE ) {
	    if ((lfp = fopen(msql_logfile, "a")) == NULL)
		sprintf(errbuf, "couldn't open msql logfile %s - %m", 
		       msql_logfile);
	    else {
		fprintf(lfp, "%s: %s\n", dbname, query);
		fflush(lfp);
		fclose(lfp);
	    }
	}
    }

    /*-- do the query */
    if ( (err = msqlQuery(db->dbh,query)) < 0 ) {
	/* if this is a select and 
	   there is a backup server then query on that */
	if (backup_server && 
	    backup_server[0] && 
	    backup_queries == TRUE &&
	    strncasecmp(query,"select",6) == 0) 
	{
	    if ( (err = msqlQuery((int)bkdbs[handle].dbh,query)) < 0 ) {
		sprintf(errbuf, 
			"Query failed on primary AND backup server! - %s\n", 
			msqlErrMsg);
		return err;
	    }
	} else {
	    sprintf(errbuf, "Query failed! - %s\n", msqlErrMsg);
	    return err;
	}
    }

    if ( strncasecmp(query,"select", 6) == 0) {
	if ( db->res != NULL )
	    msqlFreeResult(db->res);

	/*-- store the result so it isn't overwritten */
	db->res = msqlStoreResult();

	db->nrows = msqlNumRows(db->res);

	db->nfields = msqlNumFields(db->res);
    } else if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	if ( (err = msqlQuery((int)bkdbs[handle].dbh,query)) < 0 ) {
	    sprintf(errbuf, "Query failed on backup server! - %s\n", 
		    msqlErrMsg);
	    return err;
	}
    }

    return 0;

}

/*
 * close the connection to the database engine
*/
int
MsqlaccClose(int handle)
{
    msqlClose(dbs[handle].dbh);

    dbs[handle].inuse = 0;

    if ( backup_server && backup_server[0] && backup_queries == TRUE) {
	msqlClose((int)bkdbs[handle].dbh);
    }

    return 0;
}

/*
 * 
*/
int
MsqlaccFetchRow(int handle, char *fldv[], int *num)
{
    int      i;
    DBhandle	*db;

    db = &dbs[handle];

    if ( *num > db->nfields )
	*num = db->nfields;

    if ((db->row=msqlFetchRow(db->res)) == NULL) 
	return -1;

    /*-- print each field into the buffer */
    for (i = 0; i < *num; i++) 
    {
	fldv[i] = db->row[i];
    }

    return 0;
}

/*
 * get pointers to the first record's data values
*/
int
MsqlaccFirstRec(int handle, char *fldv[], int *num)
{
    DBhandle	*db;

    db = &dbs[handle];

    msqlDataSeek(db->res,(db->rpos = 0));

    return MsqlaccFetchRow(handle, fldv, num);

}

/*
 * move the result record pointer to the next result
 * and get the values therein
*/
int
MsqlaccNextRec(int handle, char *fldv[], int *num)
{
    DBhandle	*db;

    db = &dbs[handle];

    msqlDataSeek(db->res,++db->rpos);

    return MsqlaccFetchRow(handle, fldv, num);
}

/*
 * move the result record pointer to the previous result
 * and get the values therein
*/
int
MsqlaccPrevRec(int handle, char *fldv[], int *num)
{
    DBhandle	*db;

    db = &dbs[handle];

    if ( db->rpos > 0) {
	msqlDataSeek(db->res,--db->rpos);

	return MsqlaccFetchRow(handle, fldv, num);
    } else
	return -1;

}

/*
 * format the result of a query into a list of strings
 * each field is delimited by '^' character
*/
StringList  
MsqlaccResultSL(int handle, int sep)
{
    StringList   sl = NULL;
    char         rbuf[4096], *p;
    int          i, num = 1;
    DBhandle	*db;

    db = &dbs[handle];

    /*-- while there are more rows in the result */

    while ((db->row=msqlFetchRow(db->res)) != NULL) 
    {
	if ( sl == NULL) {
	    sl = CreateStringList(1);
	}

	p = rbuf;

	/*-- print each field into the buffer */
	for (i = 0; i < db->nfields; i++) 
	{
	    sprintf( p, "%s%c", db->row[i], sep & 0xff );

	    p = EndOfString(p) +1;
	}

	/*-- extend the StringList to accomodate the new row
	  (has no effect for the first row) */
	sl = ExtendStringList(sl, &num);

	/*-- and copy the buffer into the StringList */
	sl[num - 1] = strdup(rbuf);

	num++;

    }

    return sl;
}


/*
 * format the result of a query into a list of strings
 * each field is delimited by specified seperator character
*/
LLlist  *
MsqlaccResultLL(int handle, int sep)
{
    LLlist       *rl;
    char         rbuf[4096], *p;
    int          i;
    DBhandle	*db;

    db = &dbs[handle];

    rl = LLcreate(NULL,NULL,NULL,0);

    /*-- while there are more rows in the result */

    while ((db->row=msqlFetchRow(db->res)) != NULL) 
    {
	p = rbuf;

	/*-- print each field into the buffer */
	for (i = 0; i < db->nfields; i++) 
	{
	    sprintf( p, "%s%c", db->row[i], sep & 0xff );

	    p = EndOfString(p);
	}

	/*-- and copy the buffer into the StringList */
	LLappend(rl,(void *) strdup(rbuf));

    }

    return rl;
}



