unit HebrewTranslator;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, StdCtrls, Grids, DBLabelNEdit, Mask, _libmysq , MyMySQL, IniFiles, OoMisc, AdPort, ExtCtrls,
  Buttons, Menus;

type
  TMainForm = class(TForm)
    Button1: TButton;
    StringGrid1: TStringGrid;
    Button2: TButton;
    Connect: TButton;
    DBName: TDBLabelNEdit;
    Button3: TButton;
    INIFILENAME: TDBLabelNEdit;
    Button4: TButton;
    Button5: TButton;
    TXTFile: TDBLabelNEdit;
    Timer1: TTimer;
    Label1: TLabel;
    LogWinButton: TButton;
    LoginButton: TButton;
    ApdComPort1: TApdComPort;
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Name: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Properties1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure ConnectClick(Sender: TObject);
{    procedure LoadManufactorClick(Sender: TObject);}
    procedure FormCreate(Sender: TObject);
    procedure UpdateSQLTable(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ReadINIFile(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure LogWinButtonClick(Sender: TObject);
    procedure LoginButtonClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    function ParseCommand (S : String) : String;
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  MySqlRec: mysql; //Global mysql struct
  Connected: Integer; //Global var to keep track of whether we are connected
  Header,Primary : Integer;
  Row     : integer;
  Setup : TStringList;
  BufferedFromCom : String;
  InBuffer : String;
  StartExclude,EndExclude : Integer;
  LastRowUpdated : Integer;
  LastRowUpdate : boolean;

implementation

uses LogWindow, LoginWindow, PropertiesWindow;

{$R *.DFM}

function ZeroField (FieldData,FieldType : String) : String;

begin
 If FieldType='STRING' then result:='' else
 if FieldType='INTEGER' then result:='0' else
 if FieldType='REAL' then result:='0.00' else
 if FieldType='DATE' then result:='2000-01-01' else
 if FieldType='TIME' then result:='00:00:00' else
 if FieldType='HEBSTRING' then result:='' else
 if FieldType='BOOLEAN' then result:='N' else
 Result:=FieldData;
end;

function Chartoheb(c : char) : Char;

var
   x: char;
begin
    X:=c;
     case c of
          chr(128): X:='';
          chr(129): X:='';
          chr(130): X:='';
          chr(131): X:='';
          chr(132): X:='';
          chr(133): X:='';
          chr(134): X:='';
          chr(135): X:='';
          chr(136): X:='';
          chr(137): X:='';
          chr(138): X:='';
          chr(139): X:='';
          chr(140): X:='';
          chr(141): X:='';
          chr(142): X:='';
          chr(143): X:='';
          chr(144): X:='';
          chr(145): X:='';
          chr(146): X:='';
          chr(147): X:='';
          chr(148): X:='';
          chr(149): X:='';
          chr(150): X:='';
          chr(151): X:='';
          chr(152): X:='';
          chr(153): X:='';
          chr(154): X:='';
     end;
     chartoheb:=x;
end;

function SwapString (S : string) : string;

var I : integer;

begin
 result:='';
 for I:=length(S) downto 1 do
  result:=result+S[I];
end;


function StrtoHeb(s: string) : string;

const bdika : string = ',."''/\+- '{ ()'};

var
   h: string;
   x:Integer;
   poser : integer;

begin
     h:=''; poser:=0;
     for x:=length(s) downto 1 do
         begin
             if ((ord(s[x])>=128) and (ord(s[x])<=154)) or (Pos(s[x],bdika)>0) then
              begin
               h:=h+chartoheb(s[x]);
               poser:=0;
              end
             else
              begin
               insert (S[x],h,Length(h)-poser);
               inc (poser);
              end;
         end;
     strtoheb:=h;
end;

function TMainForm.ParseCommand (S : String) : String;

var
  I,I1 : integer;
  StringList : TStringList;
  StringType : String;
  Ch : Char;

 begin
  For I:=0 to StringGrid1.ColCount-1 do
   begin
    StringList:=StringGrid1.Objects[I,0] as TStringList;
    if (StringList<>nil) and (StringList.Values['IDENTIFY']<>'') then
     begin
      I1:=Pos (StringList.Values['IDENTIFY'],S);
      Result:='';
      if I1>0 then
       begin
        StringType:=StringList.Values['FIELDTYPE'];
        if StringType='Boolean' then
         begin
          Ch:=S[I1+Length(StringList.Values['IDENTIFY'])];
          if (Ch='Y') or (Ch='y') or (Ch='') then Result:='Y' else Result:='N';
         end
        else
        if StringType='Integer' then
         begin
          inc (I1);
          While (I1<=Length(S)) and ((S[I1]>='0') and (S[I1]<='9') or (S[I1]='.') or (S[I1]='-')) do
           begin
            Result:=result+S[I1];
            inc (I1);
           end;
         end
        else
        if StringType='String' then
         Result:=Copy (S,I1+1,Length(S)-(I1+1));
        if (Result<>'') then StringGrid1.Cells [I,Row]:=Result;
       end;
     end;
   end;
 end;

function ParseString (S : String ; StringType : String) : String;

var
 DateTime : TDateTime;

begin
 if S<>'' then
  begin
   if StringType = 'HebString' then
    Result:=Trim(StrToHeb(Trim(S))) else
   if StringType = 'String' then
    Result:=Trim(S) else
   if StringType = 'Time' then
    begin
      try
       DateTime:=StrToTime (Trim(S));
       DateTimeToString (Result,'hh:mm:ss',DateTime);
      except on EConvertError do result:=''; end;
    end else
   if StringType = 'Date' then
    begin
      try
       DateTime:=Strtodate (Trim(S));
       DateTimeToString (Result,'yyyy-mm-dd',DateTime);
      except on EConvertError do result:=''; end;
    end else
   if StringType = 'Integer' then
    begin
     try
       result:=Inttostr(round(strtofloat (S)));
     except on EConvertError do result:='';
     end;
    end else
   if StringType = 'Boolean' then
     begin if (S='y') or (S='Y') or (S='') then Result:='Y' else Result:='N'; end
   else
    Result:=S;
  end
 else
  result:='';
end;

procedure ParseExceptions (StringList : TStringList ; var S : String);

var
 I : integer;

begin
 For i:=0 to StringList.Count-1 do
  if Copy(StringList.Names[I],1,6)='EXCEPT' then
   if S=StringList.Values [StringList.Names[I]] then S:='';
end;

function ParseEnvironment (S : string) : String;

var
 DateTime : TDateTime;

begin
 Result:=S;
 if S='%TODAY%' then
  begin
   DateTime:=Now;
   Result:=DateToStr(DateTime);
  end
 else
  if S='%NOW%' then
   begin
    DateTime:=Now;
    Result:=TimeToStr(DateTime);
   end;
end;

procedure TMainForm.Button1Click(Sender: TObject);

var
 F : TextFile;
 S,S1 : string;
 I,I1,I2 : integer;
 StringList : TStringList;
 HeaderString : String;
 Mode : boolean;

begin
 {datefilter:=false;}
 Mode:=False; {False - File, True - Buffer}
  I1:=-1; I2:=-1;
 if Connected>0 then
  begin
    HeaderString:='';
     if (BufferedFromCom = '') then
      begin

       AssignFile (F,TXTFile.Text);
       Reset (F);
       StringGrid1.RowCount:=2;
      end
     else Mode:=True;
     while ((BufferedFromCom<>'') and (Mode)) or ((Mode=False) and (not EOF(F))) do
      begin
       if Mode then
        begin
         S := BufferedFromCom;
         BufferedFromCom:='';
        end
       else
        ReadLn (F,S);
       if S<>'' then
        begin
         if (Primary<>-1) then
          begin
           StringList:=StringGrid1.Objects[Primary,0] as TStringList;
           try
            I1:=strtoint (StringList.Values ['STARTCHAR']);
            I2:=strtoint (StringList.Values ['ENDCHAR']);
           except
            on EConvertError do begin I1:=-1; I2:=-1; end; end;
           if (I1>0) and (I2>=I1) then S1:=Copy (S,I1,I2-I1+1) else S1:='';
           if StringList.Values ['LEFTCONCAT']<>'' then S1:=StringList.Values ['LEFTCONCAT']+S1;
           if StringList.Values ['RIGHTCONCAT']<>'' then S1:=S1+StringList.Values ['RIGHTCONCAT'];
           ParseExceptions (StringList,S1);
           if (Trim(S1)<>'') then
            begin
              if (Row>=StartExclude) and (StartExclude<=EndExclude) and (Row<=EndExclude) then
                begin Dec (EndExclude); S:=''; end else
              begin
                StringGrid1.RowCount:=StringGrid1.RowCount+1;
                Row:=StringGrid1.RowCount-2;
                StringGrid1.Cells [Primary,Row]:=(ParseString(S1,StringList.Values ['FIELDTYPE']));
              end;
            end
           else
            begin
              S1:='';
              if (Header <> -1) then
               begin
                 StringList:=StringGrid1.Objects[Header,0] as TStringList;
                 try
                  I1:=strtoint (StringList.Values ['STARTCHAR']);
                  I2:=strtoint (StringList.Values ['ENDCHAR']);
                 except
                  on EConvertError do begin I1:=-1; I2:=-1; end; end;
                  if (I1>0) and (I2>=I1) then
                   S1:=Copy (S,I1,I2-I1+1)
                   else S1:='';
                  if StringList.Values ['DEFAULT']<>'' then S1:=ParseEnvironment(StringList.Values ['DEFAULT']);
                  if StringList.Values ['LEFTCONCAT']<>'' then S1:=ParseEnvironment(StringList.Values ['LEFTCONCAT'])+S1;
                  if StringList.Values ['RIGHTCONCAT']<>'' then S1:=S1+ParseEnvironment(StringList.Values ['RIGHTCONCAT']);
                  ParseExceptions (StringList,S1);
                 if Trim(S1)<>'' then
                   begin
                    HeaderString:=ParseString(S1,StringList.Values ['FIELDTYPE']);
                    S:='';
                   end;
               end;
            end;
          end;
         if S<>'' then
         For I:=0 to StringGrid1.ColCount-1 do
          begin
           if (I<>Primary) and (I<>Header) then
            begin
             StringList:=StringGrid1.Objects[I,0] as TStringList;
             if (StringList<>nil) then
              begin
               try
                I1:=strtoint (StringList.Values ['STARTCHAR']);
                I2:=strtoint (StringList.Values ['ENDCHAR']);
               except
                on EConvertError do begin I1:=-1; I2:=-1; end; end;
               if (I1>0) and (I2>=I1) then S1:=Copy (S,I1,I2-I1+1) else S1:='';
               if StringList.Values ['DEFAULT']<>'' then S1:=ParseEnvironment(StringList.Values ['DEFAULT']);
               if StringList.Values ['LEFTCONCAT']<>'' then S1:=ParseEnvironment(StringList.Values ['LEFTCONCAT'])+S1;
               if StringList.Values ['RIGHTCONCAT']<>'' then S1:=S1+ParseEnvironment(StringList.Values ['RIGHTCONCAT']);
               ParseExceptions (StringList,S1);
               if S1<>'' then
                begin
                 if (StringList.Values ['FIELDTYPE']<>'Command') and (StringList.Values ['IDENTIFY']='') then
                  StringGrid1.Cells[I,Row]:=(ParseString(S1,StringList.Values ['FIELDTYPE']))
                 else
                  if (StringList.Values ['IDENTIFY']='') then ParseCommand(S1);
                end;
              end;
            end
           else
            if (I=Header) and (HeaderString<>'') then StringGrid1.Cells[Header,Row]:= (HeaderString);
          end;
        end;
       if (StringGrid1.RowCount MOD 20)=0 then
        begin
         StringGrid1.Row := StringGrid1.RowCount-1;
        end;
      end;
    if not Mode then
     begin
      CloseFile (F);
      StringGrid1.Row:=1;
     end;
    if Connected=1 then Connected:=2;
  end
 else ShowMessage ('First load .INI file');
end;

procedure TMainForm.ConnectClick(Sender: TObject);
var
   Host, User, Passwd: String;
   db: String;
   retval: Integer;

begin
  if (Connected>0) and (connected<>4) then
   begin
     if (LoginWin.Hostname.Text='') or (LoginWin.Username.Text='') or (LoginWin.Password.Text='') then
      LoginWin.Showmodal;
     Host:= LoginWin.HostName.Text;
     User:= LoginWin.Username.Text;
     Passwd:= LoginWin.Password.Text;
     {Connect to server}
     mysql_connect(@mysqlrec, PChar(host), PChar(user), PChar(passwd));
     if mysqlrec._net.last_errno = 0 then
     begin
          connected:= 3; //keep track of connection
          Logwin.Memo1.Lines.Add('CONNECTION: Connected to: '+User+'@'+Host+':'+inttostr(MYSQL_PORT));
          db:= DBName.Text;
          retval:= mysql_select_db(@mysqlrec, PChar(db));
          if retval <> 0 then
             ShowMessage('Error attaching to: ' + db)
          else
              begin
               connected:=4;
               Logwin.Memo1.Lines.Add ('CONNECTION: Connected to db: '+db);
              end;
     end
     else
         ShowMessage (Trim(mysqlrec._net.last_error));
   end
   else ShowMessage ('Could not connected to server');
end;
{
procedure TForm1.LoadManufactorClick(Sender: TObject);

var
   presults: pmysql_res; //results structure *pointer
   prow: pmysql_row;     //row structure *pointer
   row: mysql_row;       //Couldnt figure out pointer arithmetic so....you'll see
   i : Integer;        //Counter vars
   query: String;

begin
   if connected>1 then
    begin
     Query:= 'SELECT MnfName,MnfShortName FROM Manufactors'; //Query text
     presults:= nil;
     try
     mysql_query(@mysqlrec, PChar(query)); //Send Query to server
     presults:= mysql_store_result(@mysqlrec); //Store results locally
     ManufactorGrid.Cols[0].Add('MnfName');
     ManufactorGrid.Cols[1].Add('MnfShortName');
     ManufactorGrid.RowCount:=presults^.row_count+1;
     for i:= 1 to presults^.row_count do begin
     prow:= mysql_fetch_row(presults);
     row:= prow^;  // Only way I could figure out to use an index into a MYSQL_ROW struct
     query:=Trim(StrPas(row[0]));
     if query<>'' then
      begin
       ManufactorGrid.Cols[0].Add (query);
       ManufactorGrid.Cols[1].Add (Trim(StrPas(row[1])));
      end;
     end; // i
     finally
         mysql_free_result(presults); //release the stored results from memory
     end;
    end
   else
    ShowMessage ('First connect to server');
end;
}
procedure TMainForm.FormCreate(Sender: TObject);

begin
 Connected:=0;
end;

procedure TMainForm.UpdateSQLTable(Sender: TObject);

var
   presults: pmysql_res; //results structure *pointer
   i, j: Integer;        //Counter vars
   SQL : TStringList;
   S,S1 : String;
   QueryResult : integer;
   StringList : TStringList;
   FromRow : integer;
   LogWinVisibility : Boolean;
   FieldData : string;

begin
 if (connected=4) then
   begin
    QueryResult:=0;
    LogWinVisibility:=LogWin.Visible;
    LogWin.Show;
    SQL:=TStringList.Create;
    if LastRowUpdate then FromRow:=LastRowUpdated else FromRow:=1;
    for I:=FromRow to StringGrid1.RowCount-2 do
     begin
      presults:= nil;
      {- Build update query}
      StringList:=StringGrid1.Objects[Primary,0] as TStringList;
      if (StringList<>nil) and (StringList.Values['TABLE']<>'') then
       begin
        {Update Start}
        if (Setup<>nil) and ((Setup.Values['DO']='') or (Setup.Values['DO']='UPDATEONLY') or (Setup.Values['DO']='UPDATE&INSERT')) then
         begin
          SQLUpdateStart (SQL,StringList.Values['TABLE']);
           For j:=0 to StringGrid1.ColCount-1 do
            begin
              if (j<>Primary) and (StringGrid1.Cells[j,i]<>'') then
                begin
                 StringList:=StringGrid1.Objects[j,0] as TStringList;
                 if (StringList<>nil) and (StringList.Values ['FIELDNAME']<>'') and
                    (StringList.Values ['UPDATE']='Y') then
                    begin
                     S:=UpperCase(StringList.Values['FIELDTYPE']); S1:='';
                     S1:=Uppercase(StringList.Values ['IFEMPTY']);
                     FieldData:=StringGrid1.Cells[j,i];
                     if (S1='ZERO') and (Trim(FieldData)='') then FieldData:=ZeroField (FieldData,S);
                     if (S1='EXCLUDE') and (Trim(FieldData)<>'') or (S1='') or (S1='NOTHING') or (S1='ZERO') then
                      begin
                       if (S='STRING') or (S='DATE') or (S='TIME') then
                        SQLStrUpdate (SQL,StringList.Values ['FIELDNAME'],FieldData) else
                       if (S='INTEGER') then
                         SQLUpdate (SQL,StringList.Values ['FIELDNAME'],FieldData) else
                       if (S='REAL') then
                         SQLUpdate (SQL,StringList.Values ['FIELDNAME'],FieldData) else
                       if (S='BOOLEAN') then
                        SQLStrUpdate (SQL,StringList.Values ['FIELDNAME'],FieldData);
                      end;
                    end;
               end;
            end;
          StringList:=StringGrid1.Objects[Primary,0] as TStringList;
          if (StringList<>nil) and (StringList.Values['FIELDNAME']<>'') and (StringGrid1.Cells[Primary,i]<>'') then
           begin
            SQLUpdateFinish (SQL,StringList.Values['FIELDNAME'],StringGrid1.Cells[Primary,i]);
            if Trim(SQL[1])<>'set' then
             begin
              try
               QueryResult:=mysql_query(@mysqlrec,PChar (SQL.Text));
               presults:=mysql_use_result(@mysqlrec);
               presults:=mysql_store_result(@mysqlrec); // get results;
               finally
                mysql_free_result(presults); //release the stored results from memory
               end;
               Logwin.Memo1.Lines.Add ('UPDATING: '+CRLFTrim(SQL.Text)+' Result: '+IntToStr(QueryResult)+'|'+mysqlrec.info);
               S:=Copy(mysqlrec.info,15,1);
             end
             else
              begin
               Logwin.Memo1.Lines.Add ('UPDATE QUERY: Nothing to update.');
               S:='';
              end;
           end;
         end;
        {Update finish}
         // if update returns '0' then update was done succesful?
         // Query Report = 0 , update was done succefull,
         // Query Report = -1 , update was done succefull.
         // primary was not found; need to insert.
         // if update returns ''  then bad primary.
         // if UPDATEONLY, no insert should occurs.
         // if UPDATE&INSERT, should insert only if update was not success. Default value
         // if INSERTONLY, should insert all the time.
        {Insert Start}
          if (QueryResult=-1) and ((Setup=nil) or (Setup<>nil) and (Setup.Values['DO']<>'UPDATEONLY')) or
             ((Setup<>nil) and (Setup.Values['DO']='INSERTONLY')) then
            begin //insert required, therefor insert record!
              SQLInsertStart (SQL,StringList.Values['TABLE']);
              For j:=0 to StringGrid1.ColCount-1 do
               begin
                if (StringGrid1.Cells[j,i]<>'') then
                 begin
                  StringList:=StringGrid1.Objects[j,0] as TStringList;
                  if (StringList<>nil) and (StringList.Values ['FIELDNAME']<>'') and
                  (StringList.Values ['INSERT']='Y') or (j=primary) then
                   begin
                     S:=UpperCase(StringList.Values['FIELDTYPE']);
                     S1:=Uppercase(StringList.Values ['IFEMPTY']);
                     FieldData:=StringGrid1.Cells[j,i];
                     if (S1='ZERO') and (Trim(FieldData)='') then FieldData:=ZeroField (FieldData,S);
                     if (S1='EXCLUDE') and (Trim(FieldData)<>'') or (S1='') or (S1='NOTHING') or (S1='ZERO') then
                      begin
                       if (S='STRING') or (S='DATE') or (S='TIME') then
                        SQLStrInsert (SQL,StringList.Values ['FIELDNAME'],FieldData) else
                       if (S='INTEGER') then
                        SQLInsert (SQL,StringList.Values ['FIELDNAME'],FieldData) else
                       if (S='BOOLEAN') then
                        SQLStrInsert (SQL,StringList.Values ['FIELDNAME'],FieldData) else
                       if (S='REAL') then
                        SQLInsert (SQL,StringList.Values ['FIELDNAME'],FieldData);
                      end;
                   end;
                 end;
               end;
//             presults:= mysql_store_result(@mysqlrec); //Store results locally
             SQLInsertFinish (SQL);
             Logwin.Memo1.Lines.Add ('INSERTING: '+SQL.Text+' Result: '+inttostr(mysql_query(@mysqlrec, PChar(SQL.Text)))); //Send Query to server
            end;
           {Insert Finish}
        end;
     end;
     LastRowUpdated:=StringGrid1.RowCount-1;
     LogWin.Visible:=LogWinVisibility;
   end
  else
   ShowMessage ('First Connect to Server');
end;

procedure TMainForm.Button3Click(Sender: TObject);

var
 I : integer;

begin
 For I:=0 to StringGrid1.ColCount-1 do
  begin
   if (StringGrid1.Objects[I,0] is TStringList) then
    (StringGrid1.Objects[I,0] as TStringList).Free;
   StringGrid1.Cols [I].Clear;
  end;
 StringGrid1.ColCount:=9;
 StringGrid1.RowCount:=1;
 if Connected>=4 then
  mysql_close(@mysqlrec);
 connected:=0;
end;

procedure TMainForm.ReadINIFile(Sender: TObject);

var
 Groups : TStringList;
 I,I1 : integer;
 IniFile : TIniFile;
 StringList : TStringList;
 S,S1 : String;
 I2,I3 : integer;

begin
   {Check Date}
  if Connected=0 then
   begin
     LastRowUpdate:=False;
     LastRowUpdated:=1;
     StartExclude:=-1; EndExclude:=-1; I2:=-1; I3:=-1;
     Groups:=TStringList.Create;
     IniFile:=TIniFile.Create(INIFILENAME.Text);
     IniFile.ReadSections (Groups);
     I:=0; Header:=-1; Primary:=-1; Row:=0;
     StringGrid1.ColCount:=Groups.Count-1;
//     LongDateFormat:='yyyymmdd';
//     LongTimeFormat:='hhmmss';
     TwoDigitYearCenturyWindow:=50;
     if Groups.IndexOf ('SETUP')>=0 then
      begin
       Setup:=TStringList.Create;
       IniFile.ReadSectionValues ('SETUP',Setup);
       if Setup.Values ['TXTFILE']<>'' then TXTFile.Text:=Setup.Values ['TXTFILE'];
       if Setup.Values ['SQLHOST']<>'' then LoginWin.HostName.Text:=Setup.Values ['SQLHOST'];
       if Setup.Values ['SQLDB']<>'' then DBNAME.Text:=Setup.Values ['SQLDB'];
       if Setup.Values ['SQLUSER']<>'' then LoginWin.UserName.Text:=Setup.Values ['SQLUSER'];
       if Setup.Values ['SQLPW']<>'' then LoginWin.Password.Text:=Setup.Values ['SQLPW'];
       if Setup.Values ['DATEFORMAT']<>'' then ShortDateFormat:=Setup.Values ['DATEFORMAT'];
       if Setup.Values ['TIMEFORMAT']<>'' then ShortTimeFormat:=Setup.Values ['TIMEFORMAT'];
       if Setup.Values ['DATESEPARATOR']<>'' then begin S:=Setup.Values ['DATESEPARATOR']; DateSeparator:=S[1]; end;
       if Setup.Values ['TIMESEPARATOR']<>'' then begin S:=Setup.Values ['TIMESEPARATOR']; TimeSeparator:=S[1]; end;
       if Setup.Values ['MODE']<>'' then
        begin
         if Copy (Setup.Values ['MODE'],1,3)='COM' then
          S:=Copy (Setup.Values ['MODE'],4,Length(Setup.Values ['MODE'])-3);
          try
            ApdComPort1.ComNumber:=Strtoint(GetWord(',',S,1));
            ApdComPort1.Baud:=Strtoint (GetWord(',',S,2));
            ApdComPort1.DataBits:=Strtoint (GetWord(',',S,3));
            S1:=UpperCase(GetWord(',',S,4));
            if S1='N' then ApdComPort1.Parity:=PNone else
            if S1='E' then ApdComPort1.Parity:=PEven else
            if S1='O' then ApdComPort1.Parity:=POdd else
            if S1='M' then ApdComPort1.Parity:=PMark;
            ApdComPort1.StopBits :=Strtoint (GetWord(',',S,4));
          except on EConvertError do end;
         if ApdComPort1.ComNumber<>0 then Timer1.Enabled:=True;
        end;
       if (SetUp.Values['EXCLUDE']<>'') then
         begin
          S1:=SetUp.Values['EXCLUDE'];
          if Pos ('..',S1)>0 then
          try
           StartExclude:=strtoint(Copy (S1,1,Pos('..',S1)-1));
           EndExclude:=strtoint(Copy (S1,Pos('..',S1)+2,Length(S1)-(Pos('..',S1)+1)));
           if (StartExclude>EndExclude) then begin StartExclude:=-1; EndExclude:=-1; end;
           except on EConvertError do; end;
         end;
       end
      else Setup:=nil;
     if Groups.IndexOf ('PRIMARY')>=0 then
      begin
       StringList:=TStringList.Create;
       IniFile.ReadSectionValues ('PRIMARY',StringList);
       if StringList.Values ['NAME']<>'' then
        StringGrid1.Cols[I].Add (StringList.Values ['NAME'])
       else StringGrid1.Cols[I].Add ('PRIMARY');
       StringGrid1.Objects[I,0]:=StringList;
       Primary:=I;
       inc (I);
      end;
     if Groups.IndexOf ('HEADER')>=0 then
      begin
       StringList:=TStringList.Create;
       IniFile.ReadSectionValues ('HEADER',StringList);
       if StringList.Values ['NAME']<>'' then
        StringGrid1.Cols[I].Add (StringList.Values ['NAME'])
       else StringGrid1.Cols[I].Add ('HEADER');
       StringGrid1.Objects[I,0]:=StringList;
       Header:=I;
       inc (I);
      end;
     For I1:=0 to Groups.Count-1 do
      begin
       S:=Groups.Strings[I1];
       if Pos('FIELD',S)=1 then
        begin
         StringList:=TStringList.Create;
         IniFile.ReadSectionValues (S,StringList);
         if StringList.Values ['NAME']<>'' then
          StringGrid1.Cols[I].Add (StringList.Values ['NAME'])
         else StringGrid1.Cols[I].Add (S);
         StringGrid1.Objects[I,0]:=StringList;
         try
          I2:=strtoint (StringList.Values ['STARTCHAR']);
          I3:=strtoint (StringList.Values ['ENDCHAR']);
         except
          on EConvertError do begin I2:=-1; I3:=-1; end; end;
         if ((I3-I2)>0) and ((I3-I2)>Length (StringList.Values['NAME'])) then
          StringGrid1.ColWidths[I]:=StringGrid1.Font.Size*(I3-I2) else
          StringGrid1.ColWidths[I]:=StringGrid1.Font.Size*(Length(StringList.Values['NAME']));
         inc (I);
        end
       else
       if Pos('COMMAND',S)=1 then
        begin
         StringList:=TStringList.Create;
         IniFile.ReadSectionValues (S,StringList);
         if StringList.Values ['NAME']<>'' then
          StringGrid1.Cols[I].Add (StringList.Values ['NAME'])
         else StringGrid1.Cols[I].Add (S);
         StringGrid1.Objects[I,0]:=StringList;
         inc (I);
        end;
      end;
      Connected:=1;
      Row:=1;
     IniFile.Free;
    end
   else ShowMessage ('Already Read INI File');
end;

procedure TMainForm.Button5Click(Sender: TObject);

begin
  close;
end;

procedure TMainForm.FormShow(Sender: TObject);

var
  I : integer;
  S : string;
  DoAutoRun : boolean;
  DoAutoConnect : boolean;

begin
  MainForm.Paint;
  DoAutoRun:=False;
  DoAutoConnect:=False;
  For I:=1 to ParamCount do
   begin
    S:=UpperCase (ParamStr (I));
    if S='/AUTORUN' then DoAutoRun:=True;
    if (Copy (S,1,3)='/I=') and (Length(S)>3) then IniFileName.Text:=Copy (S,4,Length(S)-3);
    if S='/AUTOCONNECT' then DoAutoConnect:=True;
   end;
  if DoAutoRun then
   begin
    LogWin.Memo1.Lines.Add ('STARTING AUTOMATIC PROCEDURE:');
    Button4.Click;
    LogWin.Memo1.Lines.Add ('DONE READING INI FILE:');
    if Connected=1 then Button1.Click;
    LogWin.Memo1.Lines.Add ('DONE READING TXT FILE:');
    if Connected=2 then Connect.Click;
    LogWin.Memo1.Lines.Add ('DONE CONNECTION TO SQL SERVER:');
    if Connected=4 then Button2.Click;
    LogWin.Memo1.Lines.Add ('DONE UPDATING TABLE:');
    button5.click;
   end
  else
  if DoAutoConnect then
   begin
    LogWin.Memo1.Lines.Add ('STARTING AUTOMATIC PROCEDURE:');
    Button4.Click;
    LogWin.Memo1.Lines.Add ('DONE READING INI FILE:');
    if Connected=1 then Connect.Click;
    LogWin.Memo1.Lines.Add ('DONE CONNECTION TO SQL SERVER:');
   end;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);

var
 S : String;
 Ch : Char;
 I : word;

begin
 I:=0;
 while (ApdComPort1.CharReady) and (I=0) do
  begin
   Ch:=ApdComPort1.GetChar;
   I:=ApdComPort1.LineError;
   InBuffer:=InBuffer+Ch;
   S:=Copy (InBuffer,Length(InBuffer)-1,2);
   if (S=#13#10) or (S=#10#13) then
    begin
     LogWin.Memo1.Lines.Add ('COM ATTN: '+Copy (InBuffer,1,Length(InBuffer)-2));
     BufferedFromCom:=InBuffer;
     InBuffer:='';
     Button1.Click;
     LastRowUpdate:=True;
     if Connected>=4 then Button2.Click;
     LastRowUpdate:=False;
    end;
  end;
end;

procedure TMainForm.LogWinButtonClick(Sender: TObject);
begin
 LogWin.ShowModal;
end;

procedure TMainForm.LoginButtonClick(Sender: TObject);
begin
 LoginWin.ShowModal;
end;

procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
 OpenDialog1.FileName:=TxtFile.Text;
 if OpenDialog1.Execute then TxtFile.Text:=OpenDialog1.Filename;
end;

procedure TMainForm.Properties1Click(Sender: TObject);

begin
  PropertiesWin.ShowModal;
end;

procedure TMainForm.Exit1Click(Sender: TObject);

begin
  Close;
end;

end.

