#include <stdio.h>

/*****************************/
/* Field Types               */

#define DB_CHAR_FLD      'C'
#define DB_LOGICAL_FLD   'L'
#define DB_NUMERIC_FLD   'N'
#define DB_DATE_FLD      'D'
#define DB_MEMO_FLD      'M'
#define DB_FLOAT_FLD     'F'

/*****************************/
/* File Status Codes         */

#define DB_CLOSED  0
#define DB_OPEN    1
#define DB_UPDATED 2

/*****************************/
/* Other defines             */

#define DB_OVERLAY     1    
#define DB_DONTOVERLAY 0
#define DB_ERROR	-1
#define DB_NO_ERROR	0
#define EndianType	'L'

/*****************************/
/* Error Phrases             */
#define DB_ERROR_WRITING_HEADER     "error while writing the header"
#define DB_MEMORY_ERROR             "error while getting memory"

/*****************************/
/* Definicion de funciones   */
void pr_error(char *);
void impre(char *);
void PutLong(char *, const long);
void PutUShort(char *, const short int);



/* This structure is used for defining a database */
struct db_Struct_File {
   char      FieldName[11];
   char      Type;
   unsigned  char FieldLen;  /* fields are stored as one byte on record*/
   unsigned  char NoOfDecs;
};

/* This structure defines field data as defined in an Xbase file header */
struct db_Struct_Rec {
   char     FieldName[11];
   char     Type;            /* field type */
   char     *Address;        /* pointer to field in record buffer 1 */
   unsigned char FieldLen;   /* fields are stored as one byte on record */
   unsigned char NoOfDecs;
   char     *Address2;       /* pointer to field in record buffer 2 */
   char     *fp;             /* pointer to null terminated buffer for field */
                             /* see method GetString */
   long  LongFieldLen;    /* to handle long field lengths */
};

struct db_Struct_Memo{            /* memo header                    */
   long    NextBlock;             /* pointer to next block to write */
   char    FileName[8];           /* name of dbt file               */
   char    Version;               /* not sure                       */
   short   BlockSize;             /* memo file block size           */
};
