VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "Msflxgrd.ocx"
Begin VB.Form frmMain 
   Caption         =   "<DYNAMIC>"
   ClientHeight    =   8025
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   13530
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmMain.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   8025
   ScaleWidth      =   13530
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdTable 
      Caption         =   "&Table View"
      Height          =   300
      Left            =   4200
      TabIndex        =   6
      Top             =   960
      Width           =   1215
   End
   Begin VB.CommandButton cmdExport 
      Caption         =   "Export"
      Height          =   300
      Left            =   12240
      TabIndex        =   19
      TabStop         =   0   'False
      Top             =   960
      Width           =   1215
   End
   Begin VB.CommandButton cmdQueryBuilder 
      Caption         =   "&Query Builder"
      Height          =   300
      Left            =   5640
      TabIndex        =   7
      ToolTipText     =   "Shortcut = <F8>"
      Top             =   960
      Width           =   1335
   End
   Begin VB.TextBox txtChunk 
      Alignment       =   1  'Right Justify
      Height          =   300
      Left            =   8400
      TabIndex        =   9
      Top             =   960
      Width           =   1335
   End
   Begin VB.TextBox txtOffset 
      Alignment       =   1  'Right Justify
      Height          =   300
      Left            =   7080
      TabIndex        =   8
      Top             =   960
      Width           =   1335
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   ">"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   10440
      TabIndex        =   11
      Top             =   960
      Width           =   615
   End
   Begin VB.CommandButton cmdPrev 
      Caption         =   "<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   9840
      TabIndex        =   10
      Top             =   960
      Width           =   615
   End
   Begin VB.CommandButton cmdDatabase 
      Caption         =   "&Databases"
      Height          =   300
      Left            =   2760
      TabIndex        =   5
      Top             =   960
      Width           =   1215
   End
   Begin MSFlexGridLib.MSFlexGrid fgData 
      Height          =   6235
      Left            =   120
      TabIndex        =   14
      Top             =   1340
      Width           =   13335
      _ExtentX        =   23521
      _ExtentY        =   11007
      _Version        =   393216
      AllowUserResizing=   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSComctlLib.StatusBar sbStatus 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   18
      Top             =   7650
      Width           =   13530
      _ExtentX        =   23865
      _ExtentY        =   661
      Style           =   1
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdSQL 
      Caption         =   "&SQL"
      Height          =   735
      Left            =   12240
      TabIndex        =   13
      Top             =   120
      Width           =   1215
   End
   Begin VB.TextBox txtSQL 
      Height          =   735
      Left            =   4200
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   12
      Top             =   120
      Width           =   7935
   End
   Begin VB.CommandButton cmdDisconnect 
      Caption         =   "Dis&connect"
      Height          =   300
      Left            =   1440
      TabIndex        =   4
      Top             =   960
      Width           =   1215
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "&Connect"
      Height          =   300
      Left            =   120
      TabIndex        =   3
      Top             =   960
      Width           =   1215
   End
   Begin VB.TextBox txtPassword 
      Height          =   285
      IMEMode         =   3  'DISABLE
      Left            =   1080
      PasswordChar    =   "*"
      TabIndex        =   2
      Top             =   600
      Width           =   2880
   End
   Begin VB.TextBox txtUsername 
      Height          =   285
      Left            =   1080
      TabIndex        =   1
      Top             =   360
      Width           =   2880
   End
   Begin VB.TextBox txtHostname 
      Height          =   285
      Left            =   1080
      TabIndex        =   0
      Top             =   120
      Width           =   2880
   End
   Begin VB.Label Label3 
      Caption         =   "Password"
      Height          =   255
      Left            =   120
      TabIndex        =   17
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label Label2 
      Caption         =   "Username"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      Top             =   360
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Hostname"
      Height          =   255
      Left            =   120
      TabIndex        =   15
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'###############################################################################
'###############################################################################
'
' Copyright (C) 2000 icarz, Inc.
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.
'
' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'###############################################################################
'###############################################################################
'
' Written by Eric Grau
'
' Please send questions, comments, and changes to mysql@icarz.com
'
'###############################################################################
'###############################################################################
'

Option Explicit

Dim prevH As Long, prevW As Long
Dim msDb As String
Dim msTable As String
Dim msColumns As String
Dim msOrderBy As String
Dim msGroupBy As String

'''''''''''''''''''''''''''''''''''''''''''''''''

Private Sub ToggleControls()
    Dim bConnected As Boolean: bConnected = (gMyConn.State = MY_CONN_OPEN)
    Dim bGotDatabase As Boolean: bGotDatabase = (Len(msDb) > 0)
    Dim bGotTable As Boolean: bGotTable = (Len(msTable) > 0)

    txtHostname.Enabled = Not bConnected
    txtUsername.Enabled = Not bConnected
    txtPassword.Enabled = Not bConnected

    cmdConnect.Enabled = Not bConnected
    cmdDisconnect.Enabled = bConnected
    cmdDatabase.Enabled = bConnected

    cmdTable.Enabled = bConnected And bGotDatabase
    cmdQueryBuilder.Enabled = bConnected And bGotDatabase

    txtOffset.Enabled = bConnected And bGotDatabase And bGotTable
    txtChunk.Enabled = bConnected And bGotDatabase And bGotTable
    cmdPrev.Enabled = bConnected And bGotDatabase And bGotTable
    cmdNext.Enabled = bConnected And bGotDatabase And bGotTable

    txtSQL.Enabled = bConnected And bGotDatabase And Not bGotTable
    cmdSQL.Enabled = bConnected And bGotDatabase
    cmdSQL.Caption = IIf(bConnected And bGotDatabase, IIf(bGotTable, "&SQL", "&Run"), "&SQL")

    If bConnected And bGotDatabase And Not bGotTable And txtSQL.Visible Then txtSQL.SetFocus

    cmdExport.Enabled = (fgData.Visible And fgData.Cols > 1 And fgData.Rows > 1)

    Me.Caption = App.Title & IIf(bGotDatabase, " - " & msDb, "")
End Sub

Private Sub cmdConnect_Click()
    sbStatus.SimpleText = "Connecting..."
    sbStatus.Refresh

    'use compression
    gMyConn.SetOption MYSQL_OPT_COMPRESS
    'attempt to connect to server ...
    gMyConn.OpenConnection txtHostname.Text, txtUsername.Text, txtPassword.Text, "", 3306    ', CLIENT_COMPRESS

    If gMyConn.State = MY_CONN_OPEN Then
        'successfully connected ...
        sbStatus.SimpleText = "Connected to MySQL server"
        'force db selection window open
        cmdDatabase_Click
    Else
        'couldn't connect to server
        sbStatus.SimpleText = "Couldn't connect to MySQL server"
        'if we got an error show it ...
        If gMyConn.Error.Number <> 0 Then ShowError
    End If

    ToggleControls
End Sub

Private Sub cmdDatabase_Click()
    'open the db selection window ... and change the db if user clicks OK
    '
    Dim f As New frmDatabase
    Dim sDb As String

    f.Show vbModal
    If f.mOK Then
        InitSqlVars
        sDb = f.lstDatabase.List(f.lstDatabase.ListIndex)

        gMyConn.SelectDb sDb

        If gMyConn.Error.Number <> 0 Then
            sbStatus.SimpleText = "Couldn't select database " & sDb
            msDb = ""
            ShowError
        Else
            sbStatus.SimpleText = "Database " & sDb & " selected."
            msDb = sDb
        End If
    End If
    Unload f

    ToggleControls
End Sub

Private Sub cmdDisconnect_Click()
    'disconnect from the db
    '
    sbStatus.SimpleText = "Disconnecting..."
    sbStatus.Refresh
    gMyConn.CloseConnection
    msDb = ""
    InitSqlVars
    sbStatus.SimpleText = "Disconnected"

    ToggleControls
End Sub

Private Sub cmdExport_Click()
    'open window to export flex grid data ...
    '
    Dim f As New frmExport
    f.SetFlexGrid = Me.fgData
    f.Show vbModal
    Unload f
End Sub

Private Sub cmdNext_Click()
    'increment the limit offset for the prebuild sql statement ...
    'ie. LIMIT 0, 10
    '    LIMIT 10, 10
    '    LIMIT 20, 10
    '    etc.
    '
    If IsNumeric(txtOffset.Text) Then
        txtOffset.Text = txtOffset.Text + 1
    Else
        txtOffset.Text = "0"
    End If

    BuildTableSelect
End Sub

Private Sub cmdPrev_Click()
    'decrement the limit offset for the prebuild sql statement ...
    'ie. LIMIT 20, 10
    '    LIMIT 10, 10
    '    LIMIT 0, 10
    '    etc.
    '
    If IsNumeric(txtOffset.Text) _
            And txtOffset.Text > 0 Then
        txtOffset.Text = txtOffset.Text - 1
    Else
        txtOffset.Text = "0"
    End If

    BuildTableSelect
End Sub

Private Sub cmdQueryBuilder_Click()
    'open the query build window and build an sql statement when user clicks OK ...
    '
    Dim f As New frmQueryBuilder
    Dim lCnt As Long

    f.msTable = msTable
    f.msColumns = msColumns
    f.msOrderBy = msOrderBy
    f.msGroupBy = msGroupBy

    f.Show vbModal

    If f.mOK Then
        InitSqlVars
        msTable = f.lstTable.List(f.lstTable.ListIndex)

        msColumns = ""
        For lCnt = 0 To (f.lstColSelected.ListCount - 1)
            msColumns = msColumns _
                    & IIf(Len(msColumns) > 0, ", ", "") _
                    & Trim(f.lstColSelected.List(lCnt))
        Next lCnt

        msOrderBy = ""
        For lCnt = 0 To (f.lstOrderBy.ListCount - 1)
            msOrderBy = msOrderBy _
                    & IIf(Len(msOrderBy) > 0, ", ", "") _
                    & Trim(f.lstOrderBy.List(lCnt))
        Next lCnt

        msGroupBy = ""
        For lCnt = 0 To (f.lstGroupBy.ListCount - 1)
            msGroupBy = msGroupBy _
                    & IIf(Len(msGroupBy) > 0, ", ", "") _
                    & Trim(f.lstGroupBy.List(lCnt))
        Next lCnt

        txtOffset.Text = "0"
        txtChunk.Text = "10"
        BuildTableSelect
    End If
    Unload f

    ToggleControls
End Sub

Private Sub cmdSQL_Click()
    If Len(msTable) > 0 Then
        'not currently in user input sql mode ...
        'enable sql entry text box and wait for user to enter query ...
        InitSqlVars
        ToggleControls
    Else
        'currently in user input sql mode ... attempt to run user's query ...
        RunQuery
    End If
End Sub

Private Sub RunQuery()
    On Local Error GoTo EH

    Dim v As Variant
    Dim sSql As String
    Dim sSqlArr() As String
    Dim iCnt As Integer
    Dim MyRS As MYSQL_RS
    Dim lRow As Long, lFIELD As Long
    Dim lRecordsAffected As Long
    Dim sngTimer As Single, sngTimer1 As Single, sngTimer2 As Single

    MouseWaitOn
    sbStatus.SimpleText = "Executing query..."
    sbStatus.Refresh

    'initialize the flex grid
    fgData.Rows = 0
    fgData.Cols = 0
    fgData.Refresh

    'remove CR and LF from sql statement(s)
    sSql = Trim(Replace(Replace(txtSQL.Text, vbLf, " "), vbCr, " "))
    If Len(sSql) = 0 Then GoTo Exit_Sub

    'separate multiple sql statements
    sSqlArr = Split(sSql, ";")
    For iCnt = LBound(sSqlArr) To UBound(sSqlArr)
        If Len(Trim(sSqlArr(iCnt))) > 0 Then
            'run each sql statement ... we will only show the result for the last query
            sngTimer = Timer
            Set MyRS = gMyConn.Execute(sSqlArr(iCnt), lRecordsAffected)
            'always abort on sql error
            If gMyConn.Error.Number <> 0 Then Exit For
        End If
    Next iCnt

    sngTimer1 = Timer

    sbStatus.SimpleText = "Query complete.  Filling grid..."
    sbStatus.Refresh

    If MyRS.RecordCount > 0 Then
        'query returned a result set ... show the data in the flex grid ...
        fgData.Visible = False

        fgData.Rows = MyRS.RecordCount + 1
        fgData.FixedRows = 1

        fgData.Cols = MyRS.FieldCount + 1
        fgData.FixedCols = 1
        fgData.ColWidth(0) = fgData.RowHeight(0)

        'fill in the header row will column names ...
        lRow = 0
        fgData.Row = lRow
        For lFIELD = 1 To MyRS.FieldCount
            fgData.Col = lFIELD
            fgData.Text = MyRS.Fields(lFIELD - 1).Name
            fgData.ColWidth(lFIELD) = Me.TextWidth(fgData.Text) + 125
        Next lFIELD

        Do
            'loop thru the data rows to fill the flex grid ...
            lRow = lRow + 1
            fgData.Row = lRow
            For lFIELD = 1 To MyRS.FieldCount
                fgData.Col = lFIELD
                fgData.ColAlignment(lFIELD) = flexAlignLeftCenter

                v = MyRS.Fields(lFIELD - 1).Value
                'v = MyRS.Field(MyRS.Field(lFIELD - 1).Name).Value   'test column reference by name
                If IsNull(v) Then
                    fgData.Text = "<-NULL->"
                Else
                    fgData.Text = v
                End If

                If (Me.TextWidth(fgData.Text) + 125) > fgData.ColWidth(lFIELD) Then
                    fgData.ColWidth(lFIELD) = Me.TextWidth(fgData.Text) + 125
                End If
            Next lFIELD

            MyRS.MoveNext
        Loop While Not MyRS.EOF

        fgData.Visible = True
    End If

    sngTimer2 = Timer

    If gMyConn.Error.Number <> 0 Then
        'got an error, inform the user ...
        sbStatus.SimpleText = "Error running query."
        ShowError
    ElseIf MyRS.RecordCount > 0 _
            Or lRecordsAffected > 0 Then
        'got data back or affect some rows ...
        'show info about the query ...
        Dim sQueryInfo As String: sQueryInfo = Trim(gMyConn.QueryInfo)

        sbStatus.SimpleText = "Query completed in " & Format(sngTimer1 - sngTimer, "0.000") & " seconds" _
                & IIf(fgData.Rows > 0 And fgData.Cols > 0, " - Grid filled in " & Format(sngTimer2 - sngTimer1, "0.000") & " seconds", "") _
                & IIf(lRecordsAffected > 0, " - Records affected = " & lRecordsAffected, "") _
                & IIf(Len(sQueryInfo) > 0, " - MySQL query info = " & sQueryInfo, "")
    Else
        'got nothing back from query ...
        sbStatus.SimpleText = "Empty recordset."
        MouseWaitOff
        MsgBox "Your query returned no records.", vbInformation
    End If

Exit_Sub:
    ToggleControls
    MouseWaitOff
    Exit Sub
EH:
    'trap potential run time errors ... not enought memory for flex grid ... etc ...
    MouseWaitOff
    MsgBox "Error " & Err.Number & ": (" & Err.Description & ")", vbCritical
    ToggleControls
End Sub

Private Sub ShowError()
    MsgBox "Error " & gMyConn.Error.Number & ": (" & gMyConn.Error.Description & ")", vbCritical
End Sub

Private Sub BuildTableSelect()
    'build sql statement ...
    '
    If Not IsNumeric(txtOffset.Text) _
            Or Not IsNumeric(txtChunk.Text) Then
        txtOffset.Text = "0"
        txtChunk.Text = "10"
    End If

    txtSQL.Text = "SELECT " & IIf(Len(Trim(msColumns)) > 0, msColumns, "*") & " FROM " & msTable _
            & IIf(Len(Trim(msOrderBy)) > 0, " ORDER BY " & Trim(msOrderBy), "") _
            & IIf(Len(Trim(msGroupBy)) > 0, " GROUP BY " & Trim(msGroupBy), "") _
            & " LIMIT " & (txtOffset.Text * txtChunk.Text) & "," & txtChunk.Text

    txtOffset.Refresh
    txtChunk.Refresh
    txtSQL.Refresh

    RunQuery
End Sub

Private Sub cmdTable_Click()
    'open the table view selection window and build an sql statement if user clicks OK ...
    Dim f As New frmTable
    Dim lCnt As Long

    f.Show vbModal

    If f.mOK Then
        InitSqlVars
        msTable = f.lstTable.List(f.lstTable.ListIndex)

        txtOffset.Text = "0"
        txtChunk.Text = "10"
        BuildTableSelect
    End If
    Unload f

    ToggleControls
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    'a couple of hot keys ...
    '
    If KeyCode = vbKeyEscape Then
        Unload Me
    ElseIf KeyCode = vbKeyF8 Then
        Dim f As New frmQueryBuilder
        f.Show vbModal
        Unload f
    End If
End Sub

Private Sub Form_Load()
    Dim sSize As String

    fgData.Rows = 0
    fgData.Cols = 0

    prevH = Me.Height
    prevW = Me.Width

    sSize = GetSetting(App.Title, "Settings", "MainTop")
    If IsNumeric(sSize) Then Me.Top = sSize
    sSize = GetSetting(App.Title, "Settings", "MainLeft")
    If IsNumeric(sSize) Then Me.Left = sSize
    sSize = GetSetting(App.Title, "Settings", "MainWidth")
    If IsNumeric(sSize) Then Me.Width = sSize
    sSize = GetSetting(App.Title, "Settings", "MainHeight")
    If IsNumeric(sSize) Then Me.Height = sSize

    If GetSetting(App.Title, "Settings", "Maximized", False) = True Then
        Me.WindowState = vbMaximized
    End If

    txtHostname.Text = GetSetting(App.Title, "Settings", "HOSTNAME")
    txtUsername.Text = GetSetting(App.Title, "Settings", "USERNAME")

    ToggleControls
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    If MsgBox("Are you sure you want to exit?", vbYesNo + vbQuestion) = vbNo Then Cancel = -1
End Sub

Private Sub Form_Resize()
    Dim h As Long, w As Long

    If Me.WindowState = vbMinimized Then Exit Sub

    h = Me.Height - prevH
    w = Me.Width - prevW

    cmdSQL.Left = cmdSQL.Left + w
    txtSQL.Width = txtSQL.Width + w
    cmdExport.Left = cmdExport.Left + w

    fgData.Height = fgData.Height + h
    fgData.Width = fgData.Width + w

    prevH = Me.Height
    prevW = Me.Width
End Sub

Private Sub Form_Unload(Cancel As Integer)
    cmdDisconnect_Click

    SaveSetting App.Title, "Settings", "HOSTNAME", txtHostname.Text
    SaveSetting App.Title, "Settings", "USERNAME", txtUsername.Text

    If Me.WindowState = vbMaximized Then
        SaveSetting App.Title, "Settings", "Maximized", True
    Else: SaveSetting App.Title, "Settings", "Maximized", False
    End If

    If Me.WindowState = vbNormal Then
        SaveSetting App.Title, "Settings", "MainTop", Me.Top
        SaveSetting App.Title, "Settings", "MainLeft", Me.Left
        SaveSetting App.Title, "Settings", "MainWidth", Me.Width
        SaveSetting App.Title, "Settings", "MainHeight", Me.Height
    End If
End Sub

Private Sub Highlight(obj As Object)
    obj.SelStart = 0
    obj.SelLength = Len(obj.Text)
End Sub

Private Sub txtChunk_GotFocus()
    Highlight txtChunk
End Sub

Private Sub txtChunk_KeyPress(KeyAscii As Integer)
    If KeyAscii = vbKeyReturn Then
        txtOffset.Text = "0"
        BuildTableSelect
    End If
End Sub

Private Sub txtHostname_GotFocus()
    Highlight txtHostname
End Sub

Private Sub txtOffset_GotFocus()
    Highlight txtOffset
End Sub

Private Sub txtOffset_KeyPress(KeyAscii As Integer)
    If KeyAscii = vbKeyReturn Then
        BuildTableSelect
    End If
End Sub

Private Sub txtPassword_GotFocus()
    Highlight txtPassword
End Sub

Private Sub txtSQL_GotFocus()
    Highlight txtSQL
End Sub

Private Sub txtUsername_GotFocus()
    Highlight txtUsername
End Sub

Private Sub InitSqlVars()
    msTable = ""
    msColumns = ""
    msOrderBy = ""
    msGroupBy = ""
End Sub

