/***************************************************************************
                          recordset.h  -  description
                             -------------------
    begin                : Mon Feb 14 2000
    copyright            : (C) 2000 by satish
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECORDSET_H
#define RECORDSET_H

#include </usr/include/mysql/mysql.h>

#define MAX_RECSRC_LEN			8192
#define MAX_COLS_IN_RECSRC	64
#define MAX_ACTQRY_LEN			8192

#define MODE_RO		0
#define MODE_EDIT	1
#define MODE_ADD	2

/**
  *@author satish
  */

class recordset {
public:
	unsigned long int RecordCount;
	unsigned long int AffectedRows;
	char RecSource[MAX_RECSRC_LEN];
	bool EOR;
	bool BOR;

private:
	struct Cols{
		char *CNam;
		char *CVal;
		unsigned int CLen;
		};
	Cols TFlds[MAX_COLS_IN_RECSRC];
	long FieldCount;
	MYSQL *mysql;
	MYSQL_RES *RecResult;
	MYSQL_ROW RecRow;
	MYSQL_FIELD *RecFields;
	unsigned long int RowPtr;
	int Mode;

private:
	void FillCols();
	void ActionQry(char *ActQry);

public: 
	recordset();
	~recordset();
	void OpenRecordset(MYSQL *Structmysql, char *sql);
	void CloseRecordset();
	void MoveNext();
	void MovePrevious();
	void MoveFirst();
	void MoveLast();
	char *GetFieldN(int FNum);
  char *GetField(char *FName);
	void SetFieldN(int FNum, char *Value);
	void SetField(char *FName, char *Value);
	void Edit();
	void AddNew();
	void Update(char *Where);
	void Delete(char *Where);
	void Refresh();
};

#endif
