--TEST--
mysqli_real_escape_string()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
	include "connect.inc";

	$dbname	= 'test';
	$tmp	= NULL;
	$link	= NULL;

	if (NULL !== ($tmp = @mysqli_real_escape_string()))
		printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

	if (NULL !== ($tmp = @mysqli_real_escape_string($link)))
		printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

	require('table.inc');

	if (NULL !== ($tmp =@mysqli_real_escape_string($link, "фуу", "бар")))
		printf("[003] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

	if ('фу\\\\бар' !== ($tmp = mysqli_real_escape_string($link, 'фу\\бар')))
		printf("[004] Expecting фу\\\\бар, got %s\n", $tmp);

	if ('бар\"фус' !== ($tmp = mysqli_real_escape_string($link, 'бар"фус')))
		printf("[005] Expecting бар\"фус, got %s\n", $tmp);

	if ("лала\'лали" !== ($tmp = mysqli_real_escape_string($link, "лала'лали")))
		printf("[006] Expecting лала'лали, got %s\n", $tmp); 

	if ("абра\\nкадабра" !== ($tmp = mysqli_real_escape_string($link, "абра\nкадабра")))
		printf("[007] Expecting абра\\nкадабра, got %s\n", $tmp);

	if ("манда\\rин" !== ($tmp = mysqli_real_escape_string($link, "манда\rин")))
		printf("[008] Expecting \\r, got %s\n", $tmp);

	if ("иху\\0аху" !== ($tmp = mysqli_real_escape_string($link, "иху" . chr(0) . "аху")))
		printf("[009] Expecting %s, got %s\n", "foo\\0bar", $tmp);

	if (($exp='абра\\\\ка\"да\\'."'".'бра\Zсим\\nсала\\rби\\0м') !==
		($tmp = mysqli_real_escape_string($link, "абра\\ка\"да'бра\032сим\nсала\rби" . chr(0) . "м")))
	{
		printf("[010] Expecting %s, got %s\n", $exp, $tmp, var_dump($exp, $tmp));
	}


	mysqli_close($link);

	if (NULL !== ($tmp = mysqli_real_escape_string($link, 'foo')))
		printf("[015] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
	
	print "done!";
?>
--EXPECTF--
Warning: mysqli_real_escape_string(): Couldn't fetch mysqli in %s on line %d
done!
