--TEST--
mysqli_kill()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_kill()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_kill($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    require('table.inc');
    
    // Zend will cast the NULL to 0
    if (!is_bool($tmp = mysqli_kill($link, null)))
        printf("[003] Expecting boolean/any, got %s/%s\n", gettype($tmp), $tmp);
    
    if (!$thread_id = mysqli_thread_id($link))
        printf("[004] Cannot determine thread id, [%d] %s\n", mysqli_errno($link), mysqli_error($link));
   
    $tmp = mysqli_kill($link, $thread_id);
    if (!is_bool($tmp))
        printf("[005] Expecting boolean/any, got %s/%s\n", gettype($tmp), $tmp);
        
    if ($res = mysqli_query($link, "SELECT id FROM test LIMIT 1"))
        pintf("[006] Expecting boolean/false, got %s/%s\n", gettype($res), $res);

    var_dump($error = mysqli_error($link));
    if (!is_string($error) || ('' === $error))
        printf("[007] Expecting string/any non empty, got %s/%s\n", gettype($error), $error);
    var_dump($res);
    var_dump($link);    
        
    mysqli_close($link);
    
    if (!$link = mysqli_connect($host, $user, $passwd, $db, $port, $socket))
        printf("[008] Cannot connect, [%d] %s\n", mysqli_connect_errno(), mysqli_connect_error());
        
    mysqli_kill($link, -1);
    if ((!$res = mysqli_query($link, "SELECT id FROM test LIMIT 1")) ||     
        (!$tmp = mysqli_fetch_assoc($res))) {
        printf("[009] Connection should not be gone, [%d] %s\n", mysqli_errno($link), mysqli_error($link));        
    }
    var_dump($tmp);
    mysqli_free_result($res);
    mysqli_close($link);
    
    if (!$link = mysqli_connect($host, $user, $passwd, $db, $port, $socket))
        printf("[010] Cannot connect, [%d] %s\n", mysqli_connect_errno(), mysqli_connect_error());
    
    mysqli_change_user($link, "This might work if you accept anonymous users in your setup", "password", $db);      mysqli_kill($link, -1);

    mysqli_close($link);
    
    print "done!";
?>
--EXPECTF--
Warning: mysqli_kill(): processid should have positive value in %s on line %d
%s(%d) "%s
bool(false)
object(mysqli)#%d (0) {
}

Warning: mysqli_kill(): processid should have positive value in %s on line %d
array(1) {
  [%s]=>
  %s(1) "1"
}

Warning: mysqli_kill(): processid should have positive value in %s on line %d
done!
