--TEST--
mysqli_fetch_assoc()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";    
    require('table.inc');    
        
    if (!$res = mysqli_query($link, "SELECT 1, 2")) {
        printf("[001] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[002]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);
    

    if (!$res = mysqli_query($link, "SELECT 1 AS a, 2")) {
        printf("[003] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[004]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);
    

    if (!$res = mysqli_query($link, "SELECT 1 AS a, 2, 2 as '2'")) {
        printf("[005] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[006]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);
    

    if (!$res = mysqli_query($link, "SELECT 1 AS a, 2 as '2', 2")) {
        printf("[007] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[008]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);


	/* Now do it with unbuffered queries */

    if (!$res = mysqli_real_query($link, "SELECT 1, 2")) {
        printf("[009] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    if (!$res = mysqli_use_result($link)) {
        printf("[010] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[011]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);


    if (!$res = mysqli_real_query($link, "SELECT 1 AS a, 2")) {
        printf("[012] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    if (!$res = mysqli_use_result($link)) {
        printf("[013] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[014]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);


    if (!$res = mysqli_real_query($link, "SELECT 1 AS a, 2, 2 as '2'")) {
        printf("[015] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    if (!$res = mysqli_use_result($link)) {
        printf("[016] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[017]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);


    if (!$res = mysqli_real_query($link, "SELECT 1 AS a, 2 as '2', 2")) {
        printf("[015] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    if (!$res = mysqli_use_result($link)) {
        printf("[016] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[017]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);

    /* some cyrillic (utf8) comes here */


    if (!$res = mysqli_query($link, "SET NAMES UTF8")) {
        printf("[018] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }


    if (!$res = mysqli_query($link, "SELECT 1 AS 'Андрей Христов', 2 AS 'Улф Вендел', 3 AS 'Георг Рихтер'")) {
        printf("[019] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[020]\n";
    var_dump(mysqli_fetch_assoc($res));
    mysqli_free_result($res);

    if (!$res = mysqli_query($link, "CREATE TABLE автори_на_mysqlnd (id integer not null auto_increment primary key, име varchar(20) character set ucs2, фамилия varchar(20) character set utf8)")) {
        printf("[021] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    if (!$res = mysqli_query($link, "INSERT INTO автори_на_mysqlnd (име, фамилия) VALUES ('Андрей', 'Христов'), ('Георг', 'Рихтер'), ('Улф','Вендел')")) {
        printf("[021] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    if (!$res = mysqli_query($link, "INSERT INTO автори_на_mysqlnd (име, фамилия) VALUES ('Andrey', 'Hristov'), ('Georg', 'Richter'), ('Ulf','Wendel')")) {
        printf("[022] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }

    if (!$res = mysqli_query($link, "SELECT id, име, фамилия FROM автори_на_mysqlnd ORDER BY фамилия")) {
        printf("[023] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    print "[024]\n";
    while ($row = mysqli_fetch_assoc($res)) {
        var_dump($row);
    }
    mysqli_free_result($res);
 
   if (!$res = mysqli_query($link, "DROP TABLE автори_на_mysqlnd")) {
        printf("[025] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }

    mysqli_close($link);

    print "done!";
?>
--EXPECTF--
[002]
array(2) {
  [1]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[004]
array(2) {
  ["a"]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[006]
array(2) {
  ["a"]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[008]
array(2) {
  ["a"]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[011]
array(2) {
  [1]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[014]
array(2) {
  ["a"]=>
  %s(1) "1"
  [2]=>
  %s(1) "2"
}
[017]
array(2) {
  ["a"]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[017]
array(2) {
  ["a"]=>
  string(1) "1"
  [2]=>
  string(1) "2"
}
[020]
array(3) {
  ["Андрей Христов"]=>
  string(1) "1"
  ["Улф Вендел"]=>
  string(1) "2"
  ["Георг Рихтер"]=>
  string(1) "3"
}
[024]
array(3) {
  ["id"]=>
  string(1) "4"
  ["име"]=>
  string(6) "Andrey"
  ["фамилия"]=>
  string(7) "Hristov"
}
array(3) {
  ["id"]=>
  string(1) "5"
  ["име"]=>
  string(5) "Georg"
  ["фамилия"]=>
  string(7) "Richter"
}
array(3) {
  ["id"]=>
  string(1) "6"
  ["име"]=>
  string(3) "Ulf"
  ["фамилия"]=>
  string(6) "Wendel"
}
array(3) {
  ["id"]=>
  string(1) "3"
  ["име"]=>
  string(6) "Улф"
  ["фамилия"]=>
  string(12) "Вендел"
}
array(3) {
  ["id"]=>
  string(1) "2"
  ["име"]=>
  string(10) "Георг"
  ["фамилия"]=>
  string(12) "Рихтер"
}
array(3) {
  ["id"]=>
  string(1) "1"
  ["име"]=>
  string(12) "Андрей"
  ["фамилия"]=>
  string(14) "Христов"
}
done!
--UEXPECTF--
[002]
array(2) {
  [1]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[004]
array(2) {
  [u"a"]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[006]
array(2) {
  [u"a"]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[008]
array(2) {
  [u"a"]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[011]
array(2) {
  [1]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[014]
array(2) {
  [u"a"]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[017]
array(2) {
  [u"a"]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[017]
array(2) {
  [u"a"]=>
  unicode(1) "1"
  [2]=>
  unicode(1) "2"
}
[020]
array(3) {
  [u"Андрей Христов"]=>
  unicode(1) "1"
  [u"Улф Вендел"]=>
  unicode(1) "2"
  [u"Георг Рихтер"]=>
  unicode(1) "3"
}
[024]
array(3) {
  [u"id"]=>
  unicode(1) "4"
  [u"име"]=>
  unicode(6) "Andrey"
  [u"фамилия"]=>
  unicode(7) "Hristov"
}
array(3) {
  [u"id"]=>
  unicode(1) "5"
  [u"име"]=>
  unicode(5) "Georg"
  [u"фамилия"]=>
  unicode(7) "Richter"
}
array(3) {
  [u"id"]=>
  unicode(1) "6"
  [u"име"]=>
  unicode(3) "Ulf"
  [u"фамилия"]=>
  unicode(6) "Wendel"
}
array(3) {
  [u"id"]=>
  unicode(1) "3"
  [u"име"]=>
  unicode(3) "Улф"
  [u"фамилия"]=>
  unicode(6) "Вендел"
}
array(3) {
  [u"id"]=>
  unicode(1) "2"
  [u"име"]=>
  unicode(5) "Георг"
  [u"фамилия"]=>
  unicode(6) "Рихтер"
}
array(3) {
  [u"id"]=>
  unicode(1) "1"
  [u"име"]=>
  unicode(6) "Андрей"
  [u"фамилия"]=>
  unicode(7) "Христов"
}
done!
