--TEST--
new mysqli()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";

    $tmp    = NULL;   
    $link   = NULL;
    
    mysqli_report(MYSQLI_REPORT_OFF);
    mysqli_report(MYSQLI_REPORT_STRICT);  
      
    ini_set('mysqli.default_socket', $socket);       
    ini_set('mysqli.default_port', $port);    
    ini_set('mysqli.default_pw', $passwd);    
    ini_set('mysqli.default_user', $user);    
    ini_set('mysqli.default_host', $host);
    /*
    NOTE: do not try $mysqli = new mysqli() !
    */
    try {
        $mysqli = mysqli_init();
        $mysqli->real_connect();
        
        if (!$res = $mysqli->query("SELECT 1"))
            printf("[001] [%d] %s\n", $mysqli->errno, $mysqli->error);
        $res->free_result();
        
        if (!$res = $mysqli->query("SELECT SUBSTRING_INDEX(USER(),'@',1) AS username"))
            printf("[002] [%d] %s\n", $mysqli->errno, $mysqli->error);
        
        $tmp = $res->fetch_assoc();
        $res->free_result();
        if ($tmp['username'] !== $user)
            printf("[003] Expecting string/%s, got %s/%s\n", $user, gettype($tmp['username']), $tmp['username']);
            
        $mysqli->close();
        
    } catch (mysqli_sql_exception $e) {
        printf("%s\n", $e->getMessage());
        printf("[004] Usage of mysqli.default_host failed\n");        
    }
    
    $link = mysqli_connect();
    if (!$res = mysqli_query($link, "SELECT 1"))
        printf("[005] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    var_dump(mysqli_fetch_assoc($res));
            
    mysqli_close($link);   

    print "done!";
?>
--EXPECTF--
array(1) {
  [1]=>
  %s(1) "1"
}
done!
