<?PHP
// 
// Check for PHP's run-test.php and use it's environment variables?
// If enabled MYSQL_TEST_USER etc. will overwrite settings specified here!
// 
define('RB_USE_ENV', true);

//
// PHP binaries to use
//
$rb_binaries = array(
  'mysqli'        => '/home/andrey/dev/non_cpp_mysqlnd/php6.0-200702150930/sapi/cli/php',  
  'mysqlnd'       => '/home/andrey/dev/php6/sapi/cli/php',
);

//
// Database connection parameter
//

// database user
define('RB_DB_USER', 'foo');
// database password
define('RB_DB_PASSWD', 'bar');
// database 
define('RB_DB_DB', 'test');
// host, for mysqlnd: localhost = socket, 127.0.0.1 = tcp/ip
define('RB_DB_HOST', '127.0.0.1');
// port
define('RB_DB_PORT', 3306);
// socket
define('RB_DB_SOCKET', NULL);
// database engine
define('RB_DB_ENGINE', 'InnoDB');


// WARNING, run-tests.php can overrule the above settings!
// .. which is handy for dev environments ;)
if (RB_USE_ENV) {
  
  if ($tmp = getenv('MYSQL_TEST_USER'))
    define('RB_DB_USER', $tmp);
    
  if ($tmp = getenv('MYSQL_TEST_PASSWD'))
    define('RB_DB_PASSWD', $tmp);
    
  if ($tmp = getenv('MYSQL_TEST_DB'))
    define('RB_DB_DB', $tmp);
    
  if ($tmp = getenv('MYSQL_TEST_HOST'))
    define('RB_DB_HOST', $tmp);
    
  if ($tmp = getenv('MYSQL_TEST_PORT'))
    define('RB_DB_PORT', $tmp);
    
  if ($tmp = getenv('MYSQL_TEST_SOCKET'))
    define('RB_TEST_SOCKET', $tmp);
    
  if ($tmp = getenv('MYSQL_TEST_ENGINE'))
    define('RB_TEST_ENGINE', $tmp);
}

//
// oprofile profiling
//

// run oprofile by default?
define('RB_DEFAULT_OPROFILE', false);
// binaries and co
define('RB_OPROFILE_OPCONTROL', (RB_USE_ENV && getenv('MYSQL_TEST_OPCONTROL')) ? getenv('MYSQL_TEST_OPCONTROL') : '/usr/bin/opcontrol');
define('RB_OPROFILE_OPREPORT',  (RB_USE_ENV && getenv('MYSQL_TEST_OPREPORT')) ? getenv('MYSQL_TEST_OPREPORT') : '/usr/bin/opreport');
define('RB_OPROFILE_VMLINUX',   (RB_USE_ENV && getenv('MYSQL_TEST_VMLINUX')) ? getenv('MYSQL_TEST_VMLINUX') : '/usr/src/linux/vmlinux');

//
// program options
//

// activate HTML output generation by default?
define('RB_DEFAULT_OUTPUT_HTML', true);
// where to store the HTML files
define('RB_OUTPUT_HTML_DIR', './web/');
// where to store the HTML that can be used in the MySQL Wiki - not implemented
define('RB_OUTPUT_WIKI_DIR', './web/wiki/');


// activate storing results into the DB by default?
define('RB_DEFAULT_STORAGE_DB', true);
?>
