--TEST--
mysqli_multi_query()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";

    $dbname = 'test';    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_multi_query()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_multi_query($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    require('table.inc');
    
    if (false !== ($tmp = mysqli_multi_query($link, "")))
        printf("[003] Expecting boolean/false, got %s/%s\n", gettype($tmp), $tmp);
    
    if (!mysqli_multi_query($link, "SELECT 1 AS a; SELECT 1 AS a, 2 AS b; SELECT id FROM test ORDER BY id LIMIT 3"))
        printf("[005] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
               
    $i = 0;
    do {
        $res = mysqli_store_result($link);
        while ($row = mysqli_fetch_array($res))
            ;
        mysqli_free_result($res);
        $i++;
    } while (mysqli_next_result($link));
    printf("[006] %d\n", $i);
        
    if (!mysqli_multi_query($link, "ALTER TABLE test MODIFY id INT AUTO_INCREMENT; INSERT INTO test(label) VALUES ('a'); SELECT id, label FROM test ORDER BY id"))
        printf("[007] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
       
    $i = 0;
    while (mysqli_next_result($link) && ($res = mysqli_store_result($link))) {               
        
        while ($row = mysqli_fetch_array($res))
            ;        
        mysqli_free_result($res);
        printf("%d/%d\n", $i, mysqli_insert_id($link));
        $i++;
    }
    printf("[008] %d\n", $i);
        
    if (!mysqli_multi_query($link, "SELECT id, label FROM test"))
        printf("[009] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        
    $i = 0;
    while (mysqli_next_result($link) && ($res = mysqli_store_result($link))) {        
        while ($row = mysqli_fetch_array($res))
            $i++;
        mysqli_free_result($res);                
    }
    printf("[010] %d\n", $i);        
        
    mysqli_close($link); 
    
    var_dump(mysqli_multi_query($link, "SELECT id, label FROM test"));
       
    print "done!";
?>
--EXPECTF--
[006] 3
[008] 0
[009] [2014] Commands out of sync; you can't run this command now
[010] 7

Warning: mysqli_multi_query(): Couldn't fetch mysqli in %s on line %d
NULL
done! 