--TEST--
mysqli_kill()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_kill()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_kill($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    require('table.inc');
    
    // Zend will cast the NULL to 0
    if (!is_bool($tmp = mysqli_kill($link, null)))
        printf("[003] Expecting boolean/any, got %s/%s\n", gettype($tmp), $tmp);
    
    if (!$thread_id = mysqli_thread_id($link))
        printf("[004] Cannot determine thread id, [%d] %s\n", mysqli_errno($link), mysqli_error($link));
   
    $tmp = mysqli_kill($link, $thread_id);
    if (!is_bool($tmp))
        printf("[005] Expecting boolean/any, got %s/%s\n", gettype($tmp), $tmp);
        
    if ($res = mysqli_query($link, "SELECT id FROM test LIMIT 1"))
        pintf("[006] Expecting boolean/false, got %s/%s\n", gettype($res), $res);

    var_dump(mysqli_error($link));
    var_dump($res);
    var_dump($link);    
        
    mysqli_close($link);    
    print "done!";
?>
--EXPECTF--
string(26) "MySQL server has gone away"
bool(false)
object(mysqli)#%d (0) {
}
done!