--TEST--
mysqli_commit()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
<?PHP
	if (!$link = mysqli_connect($host, $user, $passwd, $db, $port, $socket)) {
        printf("[s001] SKIP: Cannot connect to the server using host=%s, user=%s, passwd=***, dbname=%s, port=%s, socket=%s\n",
            $host, $user, $db, $port, $socket);
        exit(1);            
	}
            
	if (!$res = mysqli_query($link, "SHOW VARIABLES LIKE 'have_innodb'")) {
	   printf("[s002] SKIP: Cannot fetch have_innodb variable\n");
	   exit(1);	   
	}
	
	$row = mysqli_fetch_row($res);
	mysqli_free_result($res);
	mysqli_close($link);
	
	if ($row[1] == "DISABLED" || $row[1] == "NO") {
		printf ("[s003] SKIP: Innodb support is not installed or enabled.");
		exit(1);
	}
?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_commit()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_commit($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);        
        
    if (!is_null($tmp = @mysqli_commit($link, $link)))
        printf("[003] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);    
        
    if (!$link = mysqli_connect($host, $user, $passwd, $db, $port, $socket))
        printf("[004] Cannot connect to the server using host=%s, user=%s, passwd=***, dbname=%s, port=%s, socket=%s\n",
            $host, $user, $db, $port, $socket);      
        
    if (true !== ($tmp = mysqli_autocommit($link, false)))
        printf("[005] Cannot turn off autocommit, expecting true, got %s/%s\n", gettype($tmp), $tmp);

    if (!mysqli_query($link, 'DROP TABLE IF EXISTS test'))    
        printf("[006] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        
    // TODO - WARNING
    // Note: we ignore $engine here        
    if (!mysqli_query($link, 'CREATE TABLE test(id INT) ENGINE = InnoDB'))
        printf("[007] Cannot create test table, [%d] %s\n", mysqli_errno($link), mysqli_error($link));

    if (!mysqli_query($link, 'INSERT INTO test(id) VALUES (1)'))
        printf("[008] [%d] %s\n", mysqli_errno($link), mysqli_error($link));

    $tmp = mysqli_commit($link);
    if ($tmp !== true) 
        printf("[009] Expecting boolean/true, got %s/%s\n", gettype($tmp), $tmp);
   
    if (!mysqli_query($link, 'ROLLBACK'))
        printf("[010] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        
    if (!$res = mysqli_query($link, 'SELECT COUNT(*) AS num FROM test'))
        printf("[011] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    $tmp = mysqli_fetch_assoc($res);    
    if (1 != $tmp['num'])
        printf("[12] Expecting 1 row in table test, found %d rows\n", $tmp['num']);
    mysqli_free_result($res);
    
    if (!mysqli_query($link, 'DROP TABLE IF EXISTS test'))
        printf("[013] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
       
    mysqli_close($link);
    
    if (NULL !== ($tmp = @mysqli_commit($link)))
        printf("[014] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
    
    print "done!\n";
?>
--EXPECTF--
done! 