--TEST--
Interface of the class mysqli
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
<?php die("skip: disabled"); ?>
--FILE--
<?php
    require('connect.inc');
        
    $mysqli = new mysqli($host, $user, $passwd, $db, $port, $socket);
    $link = mysqli_connect($host, $user, $passwd, $db, $port, $socket);
    
    printf("Parent class:\n");
    var_dump(get_parent_class($mysqli));

    printf("\nMethods:\n");
    $methods = get_class_methods($mysqli);
    sort($methods);
    foreach ($methods as $k => $method)
      printf("%s\n", $method);
    
    printf("\nClass variables:\n");    
    $variables = get_class_vars(get_class($mysqli));
    sort($variables);
    foreach ($variables as $k => $var)
      printf("%s\n", $var);
    
    printf("\nObject variables:\n");
    $variables = get_object_vars($mysqli);
    foreach ($variables as $k => $var)
      printf("%s\n", $var);
      
    printf("\nMagic, magic properties:\n");
    
    assert(mysqli_affected_rows($link) === $mysqli->affected_rows);
    printf("mysqli->affected_rows = %s\n", $mysqli->affected_rows);
    
    assert(mysqli_get_client_info() === $mysqli->client_info);
    printf("mysqli->client_info = '%s'\n", $mysqli->client_info);
    
    assert(mysqli_get_client_version() === $mysqli->client_version);
    printf("mysqli->client_version = %s\n", $mysqli->client_version);
    
    assert(mysqli_errno($link) === $mysqli->errno);
    printf("mysqli->errno = %s\n", $mysqli->errno);
    
    assert(mysqli_error($link) === $mysqli->error);
    printf("mysqli->error = %s\n", $mysqli->error);
    
    assert(mysqli_field_count($link) === $mysqli->field_count);
    printf("mysqli->field_count = %s\n", $mysqli->field_count);
       
    assert(mysqli_insert_id($link) === $mysqli->insert_id);
    printf("mysqli->insert_id = %s\n", $mysqli->insert_id);
    
    assert(mysqli_sqlstate($link) === $mysqli->sqlstate);
    printf("mysqli->sqlstate = '%s'\n", $mysqli->sqlstate);
        
    print "done!";
?>
--EXPECTF--
Parent class:
bool(false)

Methods:
autocommit
change_user
character_set_name
client_encoding
close
commit
connect
dump_debug_info
escape_string
get_charset
get_client_info
get_server_info
get_warnings
init
kill
more_results
multi_query
mysqli
next_result
options
ping
prepare
query
real_connect
real_escape_string
real_query
rollback
select_db
set_charset
set_local_infile_default
set_local_infile_handler
set_opt
ssl_set
stat
stmt_init
store_result
thread_safe
use_result

Class variables:

Object variables:

Magic, magic properties:
mysqli->affected_rows = -1
mysqli->client_info = '%s'
mysqli->client_version = %d
mysqli->errno = %d
mysqli->error = 
mysqli->field_count = %d
mysqli->insert_id = %d
mysqli->sqlstate = '%d%d%d%d'
done!
