@ECHO OFF

REM  Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved.
REM
REM  The MySQL Connector/ODBC is licensed under the terms of the GPLv2
REM  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most
REM  MySQL Connectors. There are special exceptions to the terms and
REM  conditions of the GPLv2 as it is applied to this software, see the
REM  FLOSS License Exception
REM  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
REM
REM  This program is free software; you can redistribute it and/or modify
REM  it under the terms of the GNU General Public License as published
REM  by the Free Software Foundation; version 2 of the License.
REM
REM  This program is distributed in the hope that it will be useful, but
REM  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
REM  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
REM  for more details.
REM
REM  You should have received a copy of the GNU General Public License along
REM  with this program; if not, write to the Free Software Foundation, Inc.,
REM  51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
REM

REM #########################################################
REM 
REM \brief  Execute post build tests.
REM
REM         This executes a series of post-build tests. This is
REM         useful for a small sanity check before proceeding with
REM         more extensive tests.
REM
REM         This is not automatically executed after each build.
REM         Typical usage would be to;
REM
REM         > Uninstall.bat
REM         > Build.bat
REM         > Install.bat
REM         > PostBuildTest.bat
REM
REM \sa     Build.bat
REM
REM #########################################################

IF "%1"=="" GOTO doSyntax

ECHO BEGIN: Post build test...
GOTO d
test\my_connect.exe %1 %2 %3
test\my_basics.exe %1 %2 %3
test\my_param.exe %1 %2 %3
test\my_result.exe %1 %2 %3
test\my_cursor.exe %1 %2 %3
test\my_tran.exe %1 %2 %3
test\my_position.exe %1 %2 %3
test\my_relative.exe %1 %2 %3
test\my_scroll.exe %1 %2 %3
REM test\bin\col_length.exe %1 %2 %3
test\my_blob.exe %1 %2 %3
test\my_bulk.exe %1 %2 %3
test\my_unixodbc.exe %1 %2 %3
test\my_dyn_cursor.exe %1 %2 %3
test\my_timestamp.exe %1 %2 %3
test\my_keys.exe %1 %2 %3
test\my_curext.exe %1 %2 %3
test\my_error.exe %1 %2 %3
test\my_tran_ext.exe %1 %2 %3
REM test\bin\use_result.exe 10000 %1 %2 %3
test\my_use_result.exe %1 %2 %3
test\my_catalog.exe %1 %2 %3
:d
test\bin\test32.exe %1 %2 %3
EXIT /B 0

ECHO END: Post build test.

EXIT /B 0

:doSyntax
ECHO "+-----------------------------------------------------+"
ECHO "| PostBuildTest.bat                                   |"
ECHO "+-----------------------------------------------------+"
ECHO "|                                                     |"
ECHO "| DESCRIPTION                                         |"
ECHO "|                                                     |"
ECHO "| Use this to execute a series of post-build tests.   |"
ECHO "| This is often done after a Build.bat.               |"
ECHO "|                                                     |"
ECHO "| SYNTAX                                              |"
ECHO "|                                                     |"
ECHO "| PostBuildTest <DSN> [UID] [PWD]                     |"
ECHO "|                                                     |"
ECHO "| EXAMPLE                                             |"
ECHO "|                                                     |"
ECHO "| PostBuildTest test                                  |"
ECHO "|                                                     |"
ECHO "+-----------------------------------------------------+"



