/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.ListToString;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Utils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public final class ProcessUtil {
    private String pid;
    private PrintStream out;
    private PrintStream err;
    private String killCommand;
    private Utils utils;
    private File installDir;

    public ProcessUtil(String pid, PrintStream out, PrintStream err, File installDir) {
        this(pid, out, err, installDir, new Utils(), "kill.exe");
    }

    public ProcessUtil(String pid, PrintStream out, PrintStream err, File installDir, Utils utils, String windowsKillCommand) {
        this.installDir = installDir;
        this.pid = pid != null ? pid.trim() : "-1";
        this.out = out;
        this.err = err;
        this.utils = utils;
        this.killCommand = utils.files().isWindows() ? this.getWindowsKillFile(windowsKillCommand).getPath() : "kill";
    }

    final File getWindowsKillFile(String windowsKillCommand) {
        File parent = new File(this.installDir, "c-mxj-utils");
        File kill = new File(parent, windowsKillCommand);
        if (!kill.exists()) {
            this.utils.streams().createFileFromResource(windowsKillCommand, kill);
        }
        return kill;
    }

    String pid() {
        return this.pid;
    }

    public void kill() {
        this.kill(false);
    }

    public void forceKill() {
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() {
                ProcessUtil.this.kill(true);
            }
        };
        block.execNotThrowingExceptions(this.err);
    }

    private void kill(boolean force) {
        String threadName = "killing process " + this.pid;
        if (force) {
            threadName = "force " + threadName;
        }
        this.launchShell(threadName, this.killArgs(force), 10);
    }

    String[] killArgs(boolean force) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.killCommand);
        if (force) {
            args.add("-9");
        }
        args.add(this.pid);
        return this.utils.str().toStringArray(args);
    }

    public boolean isRunning() {
        String threadName = "is_process_" + this.pid + "_running";
        Shell shell = this.launchShell(threadName, this.isRunningArgs(), 5);
        if (!shell.hasReturned()) {
            return false;
        }
        return shell.returnCode() == 0;
    }

    private Shell launchShell(String threadName, String[] args, int seconds) {
        Shell shell = this.utils.shellFactory().newShell(args, threadName, this.out, this.err);
        shell.start();
        int fraction = 20;
        int loops = fraction * seconds;
        do {
            this.utils.threads().pause(1000 / fraction);
        } while (!shell.hasReturned() && loops-- > 0);
        if (!shell.hasReturned()) {
            this.err.println("Thread \"" + threadName + "\" may be hung");
            this.err.println("(did not return after " + seconds + " seconds)");
            this.err.println("command line used: ");
            this.err.println(new ListToString("", " ", "").toString(args));
        }
        return shell;
    }

    String[] isRunningArgs() {
        return new String[]{this.killCommand, "-0", this.pid};
    }

    public void killNoThrow() {
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            public void inner() {
                ProcessUtil.this.kill();
            }
        };
        block.execNotThrowingExceptions(this.err);
    }
}

