/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Files;
import com.mysql.management.util.FilesTest;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.TestCase;

public class FilesTest
extends TestCase {
    private Files fileUtil;
    private File foo;
    private File defaultDir;
    private TestUtil testUtil;

    protected void setUp() {
        this.fileUtil = new Files();
        this.testUtil = new TestUtil();
    }

    protected void tearDown() throws Exception {
        if (this.foo != null) {
            this.fileUtil.deleteTree(this.foo);
        }
        if (this.defaultDir != null) {
            this.fileUtil.deleteTree(this.defaultDir);
        }
    }

    public void testTempDir() throws Exception {
        String property = System.getProperty("java.io.tmpdir");
        FilesTest.assertNotNull((Object)property);
        File javaTmp = new File(property);
        FilesTest.assertEquals((String)javaTmp.getPath(), (boolean)true, (boolean)javaTmp.exists());
        File testParent = this.fileUtil.testDir().getParentFile();
        FilesTest.assertEquals((Object)javaTmp.getCanonicalFile(), (Object)testParent.getCanonicalFile());
    }

    public void testDeleteTree() throws FileNotFoundException {
        this.foo = new File(this.fileUtil.testDir(), "foo");
        File bar = new File(this.foo, "bar");
        bar.mkdirs();
        FilesTest.assertEquals((boolean)true, (boolean)bar.exists());
        File baz = new File(this.foo, "baz");
        FileOutputStream fos = new FileOutputStream(baz);
        PrintWriter out = new PrintWriter(fos);
        out.print("baz");
        out.close();
        FilesTest.assertEquals((boolean)true, (boolean)baz.exists());
        FilesTest.assertEquals((long)3L, (long)baz.length());
        FilesTest.assertEquals((boolean)true, (boolean)this.fileUtil.deleteTree(this.foo));
        FilesTest.assertEquals((boolean)false, (boolean)this.foo.exists());
    }

    public void testMakeExecutable() {
        class FakeShellStub
        extends Shell.Stub {
            String[] args;
            int runCalled;
            final /* synthetic */ FilesTest this$0;

            FakeShellStub(FilesTest filesTest) {
                this.this$0 = filesTest;
                this.runCalled = 0;
            }

            public void run() {
                ++this.runCalled;
            }
        }
        FakeShellStub shell = new FakeShellStub(this);
        class FakeShellFactory
        extends Shell.Factory {
            final /* synthetic */ FilesTest this$0;
            private final /* synthetic */ FakeShellStub val$shell;

            FakeShellFactory(FilesTest filesTest, FakeShellStub fakeShellStub) {
                this.this$0 = filesTest;
                this.val$shell = fakeShellStub;
            }

            public Shell newShell(String[] args, String name, PrintStream out, PrintStream err) {
                FilesTest.assertNotNull((Object)name);
                FilesTest.assertNotNull((Object)out);
                FilesTest.assertNotNull((Object)err);
                this.val$shell.args = args;
                return this.val$shell;
            }
        }
        this.fileUtil = new Files(new FakeShellFactory(this, shell), '\\', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        FilesTest.assertNull((Object)shell.args);
        FilesTest.assertEquals((int)0, (int)shell.runCalled);
        this.fileUtil = new Files(new FakeShellFactory(this, shell), '/', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        FilesTest.assertEquals((int)1, (int)shell.runCalled);
        FilesTest.assertEquals((int)3, (int)shell.args.length);
        FilesTest.assertEquals((String)"chmod", (String)shell.args[0]);
        FilesTest.assertEquals((String)"+x", (String)shell.args[1]);
        FilesTest.assertTrue((shell.args[2].indexOf("bogus") >= 0 ? 1 : 0) != 0);
    }

    public void testValidCononicalDir() throws Exception {
        this.foo = this.fileUtil.tmp("foo");
        File cononicalFoo = this.foo.getCanonicalFile();
        this.defaultDir = this.fileUtil.tmp("defaultDir");
        File valid = this.fileUtil.validCononicalDir(this.foo);
        FilesTest.assertEquals((Object)cononicalFoo, (Object)valid);
        valid = this.fileUtil.validCononicalDir(this.foo, this.defaultDir);
        FilesTest.assertEquals((Object)cononicalFoo, (Object)valid);
        valid = this.fileUtil.validCononicalDir(null, this.defaultDir);
        FilesTest.assertEquals((Object)this.defaultDir, (Object)valid);
        File bar = new File(this.fileUtil.testDir(), "junkFile.txt");
        bar.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(bar);
        PrintStream ps = new PrintStream(fos);
        ps.println("junk");
        ps.close();
        IllegalArgumentException expected = null;
        try {
            this.fileUtil.validCononicalDir(bar);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        FilesTest.assertNotNull((Object)expected);
        this.testUtil.assertContainsIgnoreCase(expected.getMessage(), "directory");
        expected = null;
        try {
            this.fileUtil.validCononicalDir(null);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        FilesTest.assertNotNull((Object)expected);
        this.testUtil.assertContainsIgnoreCase(expected.getMessage(), "null");
    }
}

