/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.management.jmx.ConnectorMXJPropertiesTransform;
import com.mysql.management.jmx.StubTestMBeanServer;
import com.mysql.management.util.TestUtil;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import junit.framework.TestCase;

public class ConnectorMXJPropertiesTransformTest
extends TestCase {
    private static final String PORT = "3307";
    private ConnectorMXJPropertiesTransform munger;
    private TestUtil testUtil;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void setUp() throws Exception {
        this.testUtil = new TestUtil();
        String[] objectNames = new String[]{"mysql:name=MySQL1"};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.management.jmx.MysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> mbeanClass = clazz;
        TestMBeanServer mbs = new TestMBeanServer(objectNames, mbeanClass);
        this.munger = new ConnectorMXJPropertiesTransform(mbs);
    }

    public void testGetMysqldDynamicMBean() throws Exception {
        ObjectName objName = this.munger.getMysqldObjectName();
        String name = objName.getCanonicalName();
        this.testUtil.assertContainsIgnoreCase(name, "mysql");
    }

    public void testGetHostAndPort() throws Exception {
        ConnectorMXJPropertiesTransformTest.assertEquals((String)"localhost", (String)this.munger.getHost());
        ConnectorMXJPropertiesTransformTest.assertEquals((String)PORT, (String)this.munger.getPort());
    }

    public void testTransformProperties() throws Exception {
        Properties props = new Properties();
        props.put("HOST", "foo");
        props.put("PORT", PORT);
        this.munger.transformProperties(props);
        ConnectorMXJPropertiesTransformTest.assertEquals((Object)"localhost:3307", (Object)props.get("HOST"));
        ConnectorMXJPropertiesTransformTest.assertEquals((Object)PORT, (Object)props.get("PORT"));
    }

    public void testGetMysqldObjectName() throws Exception {
        String[] objectNames = new String[]{"foo:name=foo1", "foo:name=bar1", "baz:name=baz1"};
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestMBeanServer mbs = new TestMBeanServer(objectNames, clazz);
        this.munger = new ConnectorMXJPropertiesTransform(mbs);
        IllegalStateException expected = null;
        ObjectName objectName = null;
        try {
            objectName = this.munger.getMysqldObjectName();
        }
        catch (IllegalStateException e) {
            expected = e;
        }
        ConnectorMXJPropertiesTransformTest.assertNull((Object)objectName);
        ConnectorMXJPropertiesTransformTest.assertNotNull((Object)expected);
        String errMsg = expected.getMessage();
        this.testUtil.assertContainsIgnoreCase(errMsg, "foo");
        this.testUtil.assertContainsIgnoreCase(errMsg, "bar");
        this.testUtil.assertContainsIgnoreCase(errMsg, "baz");
    }

    public void testNameMatch() throws Exception {
        ConnectorMXJPropertiesTransformTest.assertFalse((boolean)this.munger.classNameMatch("foo"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.management.jmx.MysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectorMXJPropertiesTransformTest.assertTrue((boolean)this.munger.classNameMatch(clazz.getName()));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.mysql.management.jmx.SimpleMysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectorMXJPropertiesTransformTest.assertTrue((boolean)this.munger.classNameMatch(clazz2.getName()));
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.mysql.management.jmx.jboss.JBossMysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectorMXJPropertiesTransformTest.assertTrue((boolean)this.munger.classNameMatch(clazz3.getName()));
    }

    static class TestMBeanServer
    extends StubTestMBeanServer {
        private Set objectNames = new LinkedHashSet();
        private String className;
        Object[] methodparams;

        public TestMBeanServer(String[] names, Class aClass) throws Exception {
            int i = 0;
            while (i < names.length) {
                this.objectNames.add(new ObjectName(names[i]));
                ++i;
            }
            this.className = aClass.getName();
        }

        public Set queryNames(ObjectName arg0, QueryExp arg1) {
            this.methodparams = new Object[]{arg0, arg1};
            return this.objectNames;
        }

        public ObjectInstance getObjectInstance(ObjectName arg0) {
            return new ObjectInstance(arg0, this.className);
        }

        public Object getAttribute(ObjectName arg0, String arg1) {
            if ("port".equals(arg1)) {
                return ConnectorMXJPropertiesTransformTest.PORT;
            }
            return String.valueOf(arg1) + "? ... arg0: " + arg0;
        }
    }
}

