/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.jdbc.ConnectionPropertiesTransform;
import com.mysql.management.util.Exceptions;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class ConnectorMXJPropertiesTransform
implements ConnectionPropertiesTransform {
    private static Class[] mbeanClasses;
    private MBeanServer mbeanServer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.management.jmx.MysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.mysql.management.jmx.SimpleMysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.mysql.management.jmx.jboss.JBossMysqldDynamicMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        mbeanClasses = classArray;
    }

    public ConnectorMXJPropertiesTransform(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public ConnectorMXJPropertiesTransform() {
        this(MBeanServerFactory.findMBeanServer(null).get(0));
    }

    MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public Properties transformProperties(Properties props) throws SQLException {
        String host = this.getHost();
        String port = this.getPort();
        if (!port.equals("3306")) {
            host = String.valueOf(host) + ":" + port;
        }
        props.put("HOST", host);
        props.put("PORT", port);
        return props;
    }

    String getHost() {
        return "localhost";
    }

    String getPort() throws SQLException {
        Exceptions.SQLBlock block = new Exceptions.SQLBlock(System.err){

            public Object inner() throws Exception {
                return ConnectorMXJPropertiesTransform.this.getPortInner();
            }
        };
        return (String)block.exec();
    }

    private Object getPortInner() throws InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        ObjectName objName = this.getMysqldObjectName();
        String port = (String)this.getMBeanServer().getAttribute(objName, "port");
        return port;
    }

    ObjectName getMysqldObjectName() throws InstanceNotFoundException {
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(null, null);
        StringBuffer error = this.errorMsgHeader();
        Iterator<ObjectName> iter = objectNames.iterator();
        while (iter.hasNext()) {
            ObjectName objectName = iter.next();
            ObjectInstance objInst = this.getMBeanServer().getObjectInstance(objectName);
            String className = objInst.getClassName();
            if (this.classNameMatch(className)) {
                return objectName;
            }
            this.appendItem(error, objectName, className);
        }
        throw new IllegalStateException(error.toString());
    }

    private void appendItem(StringBuffer error, ObjectName objectName, String className) {
        error.append("[");
        error.append(className);
        error.append("(");
        error.append(objectName.getCanonicalName());
        error.append(")]");
    }

    private StringBuffer errorMsgHeader() {
        StringBuffer error = new StringBuffer();
        error.append("MySQL MBean (");
        int i = 0;
        while (i < mbeanClasses.length) {
            error.append(mbeanClasses[i].getName());
            if (i < mbeanClasses.length - 1) {
                error.append(", ");
            }
            ++i;
        }
        error.append(") Not Found in: ");
        return error;
    }

    boolean classNameMatch(String className) {
        int i = 0;
        while (i < mbeanClasses.length) {
            if (mbeanClasses[i].getName().equals(className)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

