/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.management.MysqldResourceI;
import com.mysql.management.jmx.ConnectorMXJPropertiesTransform;
import com.mysql.management.jmx.MysqldDynamicMBean;
import com.mysql.management.jmx.MysqldDynamicMBeanTestAgent;
import com.mysql.management.jmx.SimpleMysqldDynamicMBean;
import com.mysql.management.jmx.jboss.JBossMysqldDynamicMBean;
import com.mysql.management.util.Files;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Threads;
import java.io.File;
import javax.management.Attribute;

public class AcceptanceTest
extends QuietTestCase {
    private MysqldDynamicMBeanTestAgent agent;
    private SimpleMysqldDynamicMBean bean;
    private Threads threads = new Threads();
    private String orig;
    private File dataDir;
    private TestUtil testUtil;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() {
        super.setUp();
        this.orig = System.getProperty("c-mxj.files.use-test-dir", "");
        System.setProperty("c-mxj.files.use-test-dir", Boolean.TRUE.toString());
        this.dataDir = new Files().tmp("MxjAccTest_" + System.currentTimeMillis());
        this.testUtil = new TestUtil();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        try {
            if (this.bean != null) {
                try {
                    this.bean.invoke("stop", null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.threads.pause(50);
            }
            if (this.agent != null) {
                this.agent.shutdown();
            }
            new Files().deleteTree(this.dataDir);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            System.setProperty("c-mxj.files.use-test-dir", this.orig);
            super.tearDown();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        System.setProperty("c-mxj.files.use-test-dir", this.orig);
        super.tearDown();
    }

    public void testConnectorMXJPropertiesTransformDefaultConstructor() {
        ConnectorMXJPropertiesTransform munger = null;
        this.agent = new MysqldDynamicMBeanTestAgent("mysql");
        munger = new ConnectorMXJPropertiesTransform();
        AcceptanceTest.assertEquals((Object)this.agent.get(), (Object)munger.getMBeanServer());
    }

    public void testEverything() throws Exception {
        this.agent = new MysqldDynamicMBeanTestAgent("mysql");
        StringBuffer stringBuffer = new StringBuffer("jdbc:mysql:///test?propertiesTransform=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.management.jmx.ConnectorMXJPropertiesTransform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String url = stringBuffer.append(clazz.getName()).toString();
        this.bean = new MysqldDynamicMBean();
        this.bean.getMysqldResource().setKillDelay(this.testUtil.testKillDelay());
        this.agent.addBean("mysql", "MySQL1", this.bean);
        AcceptanceTest.assertEquals((boolean)false, (boolean)this.bean.getMysqldResource().isRunning());
        String port = "" + this.testUtil.testPort();
        AcceptanceTest.assertEquals((Object)"3306", this.bean.getMysqldResource().getServerOptions().get("port"));
        this.bean.setAttribute(new Attribute("port", port));
        this.bean.invoke("startMysqld", null, null);
        int i = 0;
        while (++i < 100) {
            if (this.bean.getMysqldResource().isRunning()) break;
            this.threads.pause(50);
        }
        AcceptanceTest.assertTrue((String)("still not started: " + i), (boolean)this.bean.getMysqldResource().isRunning());
        AcceptanceTest.assertEquals((Object)port, this.bean.getMysqldResource().getServerOptions().get("port"));
        new TestUtil().assertConnectViaJDBC(url);
    }

    public void testJBossDefaultConstructor() throws Exception {
        JBossMysqldDynamicMBean jbossbean = new JBossMysqldDynamicMBean();
        MysqldResourceI mysqldResource = jbossbean.getMysqldResource();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.mysql.management.MysqldResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AcceptanceTest.assertEquals((Object)clazz, mysqldResource.getClass());
    }

    public void testDifferentDataDir() throws Exception {
        this.agent = new MysqldDynamicMBeanTestAgent("mysql");
        StringBuffer stringBuffer = new StringBuffer("jdbc:mysql:///test?propertiesTransform=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.management.jmx.ConnectorMXJPropertiesTransform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String url = stringBuffer.append(clazz.getName()).toString();
        this.bean = new MysqldDynamicMBean();
        this.bean.getMysqldResource().setKillDelay(this.testUtil.testKillDelay());
        this.agent.addBean("mysql", "MySQL1", this.bean);
        AcceptanceTest.assertEquals((boolean)false, (boolean)this.bean.getMysqldResource().isRunning());
        String port = "" + this.testUtil.testPort();
        AcceptanceTest.assertEquals((Object)"3306", this.bean.getMysqldResource().getServerOptions().get("port"));
        this.bean.setAttribute(new Attribute("port", port));
        this.bean.setAttribute(new Attribute("datadir", this.dataDir.getPath()));
        this.bean.invoke("startMysqld", null, null);
        int i = 0;
        while (++i < 100) {
            if (this.bean.getMysqldResource().isRunning()) break;
            this.threads.pause(50);
        }
        AcceptanceTest.assertTrue((String)("still not started: " + i), (boolean)this.bean.getMysqldResource().isRunning());
        AcceptanceTest.assertEquals((String)port, (String)("" + this.bean.getMysqldResource().getPort()));
        AcceptanceTest.assertEquals((Object)port, this.bean.getMysqldResource().getServerOptions().get("port"));
        AcceptanceTest.assertEquals((Object)this.dataDir, (Object)this.bean.getMysqldResource().getDataDir());
        new TestUtil().assertConnectViaJDBC(url);
    }
}

