/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.CompactTypeStructureRepresentation;
import org.aspectj.ajdt.internal.core.builder.IStateListener;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.aspectj.org.eclipse.jdt.internal.core.builder.StringSet;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;

public class AjState {
    private AjBuildManager buildManager;
    private boolean couldBeSubsequentIncrementalBuild = false;
    public static IStateListener stateListener = null;
    public static boolean FORCE_INCREMENTAL_DURING_TESTING = false;
    private IHierarchy structureModel;
    private IRelationshipMap relmap;
    private long lastSuccessfulFullBuildTime = -1L;
    private Hashtable structuralChangesSinceLastFullBuild = new Hashtable();
    private long lastSuccessfulBuildTime = -1L;
    private long currentBuildTime = -1L;
    private AjBuildConfig buildConfig;
    private boolean batchBuildRequiredThisTime = false;
    private Map fullyQualifiedTypeNamesResultingFromCompilationUnit = new HashMap();
    private Set sourceFilesDefiningAspects = new HashSet();
    private Map references = new HashMap();
    private Map binarySourceFiles = new HashMap();
    private Map inputClassFilesBySource = new HashMap();
    private Map resolvedTypeStructuresFromLastBuild = new HashMap();
    private Map classesFromName = new HashMap();
    private List compiledSourceFiles = new ArrayList();
    private List resources = new ArrayList();
    private List aspectNames;
    private ArrayList qualifiedStrings;
    private ArrayList simpleStrings;
    private Set addedFiles;
    private Set deletedFiles;
    private Set addedBinaryFiles;
    private Set deletedBinaryFiles;
    private BcelWeaver weaver;
    private BcelWorld world;
    private static final char[][] EMPTY_CHAR_ARRAY = new char[0][];
    private static final char[] BRACKET_V = new char[]{')', 'V'};

    public AjState(AjBuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setCouldBeSubsequentIncrementalBuild(boolean yesThereCould) {
        this.couldBeSubsequentIncrementalBuild = yesThereCould;
    }

    void successfulCompile(AjBuildConfig config, boolean wasFullBuild) {
        this.buildConfig = config;
        this.lastSuccessfulBuildTime = this.currentBuildTime;
        if (stateListener != null) {
            stateListener.buildSuccessful(wasFullBuild);
        }
        if (wasFullBuild) {
            this.lastSuccessfulFullBuildTime = this.currentBuildTime;
        }
    }

    boolean prepareForNextBuild(AjBuildConfig newBuildConfig) {
        this.currentBuildTime = System.currentTimeMillis();
        if (!this.maybeIncremental()) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because either not in AJDT or incremental deactivated");
            }
            return false;
        }
        if (this.batchBuildRequiredThisTime) {
            this.batchBuildRequiredThisTime = false;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental this time because batch build explicitly forced");
            }
            return false;
        }
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null) {
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because no successful previous full build");
            }
            return false;
        }
        if (newBuildConfig.getOutputJar() != null) {
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because outjar being used");
            }
            return false;
        }
        if (this.pathChange(this.buildConfig, newBuildConfig)) {
            this.removeAllResultsOfLastBuild();
            if (stateListener != null) {
                stateListener.pathChangeDetected();
            }
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because path change detected (one of classpath/aspectpath/inpath/injars)");
            }
            return false;
        }
        this.simpleStrings = new ArrayList();
        this.qualifiedStrings = new ArrayList();
        HashSet oldFiles = new HashSet(this.buildConfig.getFiles());
        HashSet newFiles = new HashSet(newBuildConfig.getFiles());
        this.addedFiles = new HashSet(newFiles);
        this.addedFiles.removeAll(oldFiles);
        this.deletedFiles = new HashSet(oldFiles);
        this.deletedFiles.removeAll(newFiles);
        HashSet oldBinaryFiles = new HashSet(this.buildConfig.getBinaryFiles());
        HashSet newBinaryFiles = new HashSet(newBuildConfig.getBinaryFiles());
        this.addedBinaryFiles = new HashSet(newBinaryFiles);
        this.addedBinaryFiles.removeAll(oldBinaryFiles);
        this.deletedBinaryFiles = new HashSet(oldBinaryFiles);
        this.deletedBinaryFiles.removeAll(newBinaryFiles);
        boolean couldStillBeIncremental = this.processDeletedFiles(this.deletedFiles);
        if (!couldStillBeIncremental) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because an aspect was deleted");
            }
            return false;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision("Preparing for build: planning to be an incremental build");
        }
        return true;
    }

    private boolean processDeletedFiles(Set deletedFiles) {
        Iterator iter = deletedFiles.iterator();
        while (iter.hasNext()) {
            File aDeletedFile = (File)iter.next();
            if (this.sourceFilesDefiningAspects.contains(aDeletedFile)) {
                this.removeAllResultsOfLastBuild();
                if (stateListener != null) {
                    stateListener.detectedAspectDeleted(aDeletedFile);
                }
                return false;
            }
            List classes = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(aDeletedFile);
            if (classes == null) continue;
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                ClassFile element = (ClassFile)iterator.next();
                this.resolvedTypeStructuresFromLastBuild.remove(element.fullyQualifiedTypeName);
            }
        }
        return true;
    }

    private Collection getModifiedFiles() {
        return this.getModifiedFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedFiles(long lastBuildTime) {
        ArrayList<File> ret = new ArrayList<File>();
        Iterator i = this.buildConfig.getFiles().iterator();
        while (i.hasNext()) {
            long modTime;
            File file = (File)i.next();
            if (!file.exists() || (modTime = file.lastModified()) + 1000L <= lastBuildTime) continue;
            ret.add(file);
        }
        return ret;
    }

    private Collection getModifiedBinaryFiles() {
        return this.getModifiedBinaryFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedBinaryFiles(long lastBuildTime) {
        ArrayList<AjBuildConfig.BinarySourceFile> ret = new ArrayList<AjBuildConfig.BinarySourceFile>();
        Iterator i = this.buildConfig.getBinaryFiles().iterator();
        while (i.hasNext()) {
            long modTime;
            AjBuildConfig.BinarySourceFile bsfile = (AjBuildConfig.BinarySourceFile)i.next();
            File file = bsfile.binSrc;
            if (!file.exists() || (modTime = file.lastModified()) + 1000L < lastBuildTime) continue;
            ret.add(bsfile);
        }
        return ret;
    }

    private boolean classFileChangedInDirSinceLastBuild(File dir) {
        AjState state = IncrementalStateManager.findStateManagingOutputLocation(dir);
        File[] classFiles = FileUtil.listFiles(dir, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".class");
            }
        });
        for (int i = 0; i < classFiles.length; ++i) {
            long modTime = classFiles[i].lastModified();
            if (modTime + 1000L < this.lastSuccessfulBuildTime) continue;
            if (state != null) {
                boolean realChange = state.hasStructuralChangedSince(classFiles[i], this.lastSuccessfulBuildTime);
                if (!realChange) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean hasStructuralChangedSince(File file, long lastSuccessfulBuildTime) {
        Long l = (Long)this.structuralChangesSinceLastFullBuild.get(file.getAbsolutePath());
        long strucModTime = -1L;
        strucModTime = l != null ? l : this.lastSuccessfulFullBuildTime;
        return strucModTime > lastSuccessfulBuildTime;
    }

    private boolean pathChange(AjBuildConfig oldConfig, AjBuildConfig newConfig) {
        List newInPath;
        List newInJars;
        List newAspectpath;
        boolean changed = false;
        List oldClasspath = oldConfig.getClasspath();
        List newClasspath = newConfig.getClasspath();
        if (stateListener != null) {
            stateListener.aboutToCompareClasspaths(oldClasspath, newClasspath);
        }
        if (this.changed(oldClasspath, newClasspath, true, oldConfig.getOutputDir())) {
            return true;
        }
        List oldAspectpath = oldConfig.getAspectpath();
        if (this.changed(oldAspectpath, newAspectpath = newConfig.getAspectpath(), true, oldConfig.getOutputDir())) {
            return true;
        }
        List oldInJars = oldConfig.getInJars();
        if (this.changed(oldInJars, newInJars = newConfig.getInJars(), false, oldConfig.getOutputDir())) {
            return true;
        }
        List oldInPath = oldConfig.getInpath();
        if (this.changed(oldInPath, newInPath = newConfig.getInpath(), false, oldConfig.getOutputDir())) {
            return true;
        }
        return changed;
    }

    private boolean changed(List oldPath, List newPath, boolean checkClassFiles, File oldOutputLocation) {
        if (oldPath == null) {
            oldPath = new ArrayList();
        }
        if (newPath == null) {
            newPath = new ArrayList();
        }
        try {
            if (oldOutputLocation != null) {
                oldOutputLocation = oldOutputLocation.getCanonicalFile();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (oldPath.size() != newPath.size()) {
            return true;
        }
        for (int i = 0; i < oldPath.size(); ++i) {
            if (!oldPath.get(i).equals(newPath.get(i))) {
                return true;
            }
            Object o = oldPath.get(i);
            File f = null;
            f = o instanceof String ? new File((String)o) : (File)o;
            if (f.exists() && !f.isDirectory() && f.lastModified() >= this.lastSuccessfulBuildTime) {
                return true;
            }
            if (!f.exists() || !f.isDirectory() || !checkClassFiles || f.equals(oldOutputLocation)) continue;
            boolean b = this.classFileChangedInDirSinceLastBuild(f);
            if (b && stateListener != null) {
                stateListener.detectedClassChangeInThisDir(f);
            }
            if (!b) continue;
            return true;
        }
        return false;
    }

    public List getFilesToCompile(boolean firstPass) {
        ArrayList thisTime = new ArrayList();
        if (firstPass) {
            this.compiledSourceFiles = new ArrayList();
            Collection modifiedFiles = this.getModifiedFiles();
            thisTime.addAll(modifiedFiles);
            thisTime.addAll(this.addedFiles);
            this.deleteClassFiles();
            this.deleteResources();
            this.addAffectedSourceFiles(thisTime, thisTime);
        } else {
            this.addAffectedSourceFiles(thisTime, this.compiledSourceFiles);
        }
        this.compiledSourceFiles = thisTime;
        return thisTime;
    }

    private boolean maybeIncremental() {
        return FORCE_INCREMENTAL_DURING_TESTING || this.couldBeSubsequentIncrementalBuild;
    }

    public Map getBinaryFilesToCompile(boolean firstTime) {
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null || !this.maybeIncremental()) {
            return this.binarySourceFiles;
        }
        HashMap toWeave = new HashMap();
        if (firstTime) {
            ArrayList addedOrModified = new ArrayList();
            addedOrModified.addAll(this.addedBinaryFiles);
            addedOrModified.addAll(this.getModifiedBinaryFiles());
            Iterator iter = addedOrModified.iterator();
            while (iter.hasNext()) {
                AjBuildConfig.BinarySourceFile bsf = (AjBuildConfig.BinarySourceFile)iter.next();
                UnwovenClassFile ucf = this.createUnwovenClassFile(bsf);
                if (ucf == null) continue;
                ArrayList<UnwovenClassFile> ucfs = new ArrayList<UnwovenClassFile>();
                ucfs.add(ucf);
                this.addDependentsOf(ucf.getClassName());
                this.binarySourceFiles.put(bsf.binSrc.getPath(), ucfs);
                ArrayList<ClassFile> cfs = new ArrayList<ClassFile>(1);
                cfs.add(this.getClassFileFor(ucf));
                this.inputClassFilesBySource.put(bsf.binSrc.getPath(), cfs);
                toWeave.put(bsf.binSrc.getPath(), ucfs);
            }
            this.deleteBinaryClassFiles();
        }
        return toWeave;
    }

    private void removeAllResultsOfLastBuild() {
        Iterator<Object> iter = this.inputClassFilesBySource.values().iterator();
        while (iter.hasNext()) {
            List cfs = (List)iter.next();
            Iterator iterator = cfs.iterator();
            while (iterator.hasNext()) {
                ClassFile cf = (ClassFile)iterator.next();
                cf.deleteFromFileSystem();
            }
        }
        Iterator iterator = this.classesFromName.values().iterator();
        while (iterator.hasNext()) {
            File f = (File)iterator.next();
            new ClassFile("", f).deleteFromFileSystem();
        }
        iter = this.resources.iterator();
        while (iter.hasNext()) {
            String resource = (String)iter.next();
            new File(this.buildConfig.getOutputDir(), resource).delete();
        }
    }

    private void deleteClassFiles() {
        Iterator i = this.deletedFiles.iterator();
        while (i.hasNext()) {
            File deletedFile = (File)i.next();
            this.addDependentsOf(deletedFile);
            List cfs = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(deletedFile);
            this.fullyQualifiedTypeNamesResultingFromCompilationUnit.remove(deletedFile);
            if (cfs == null) continue;
            Iterator iter = cfs.iterator();
            while (iter.hasNext()) {
                ClassFile cf = (ClassFile)iter.next();
                this.deleteClassFile(cf);
            }
        }
    }

    private void deleteBinaryClassFiles() {
        Iterator iter = this.deletedBinaryFiles.iterator();
        while (iter.hasNext()) {
            AjBuildConfig.BinarySourceFile deletedFile = (AjBuildConfig.BinarySourceFile)iter.next();
            List cfs = (List)this.inputClassFilesBySource.get(deletedFile.binSrc.getPath());
            Iterator iterator = cfs.iterator();
            while (iterator.hasNext()) {
                this.deleteClassFile((ClassFile)iterator.next());
            }
            this.inputClassFilesBySource.remove(deletedFile.binSrc.getPath());
        }
    }

    private void deleteResources() {
        ArrayList oldResources = new ArrayList();
        oldResources.addAll(this.resources);
        Iterator<Object> i = this.buildConfig.getInpath().iterator();
        while (i.hasNext()) {
            File inPathElement = (File)i.next();
            if (!inPathElement.isDirectory()) continue;
        }
        if (this.buildConfig.getSourcePathResources() != null) {
            i = this.buildConfig.getSourcePathResources().keySet().iterator();
            while (i.hasNext()) {
                String resource = (String)i.next();
                this.maybeDeleteResource(resource, oldResources);
            }
        }
        Iterator iter = oldResources.iterator();
        while (iter.hasNext()) {
            String victim = (String)iter.next();
            File f = new File(this.buildConfig.getOutputDir(), victim);
            if (f.exists()) {
                f.delete();
            }
            this.resources.remove(victim);
        }
    }

    private void maybeDeleteResource(String resName, List oldResources) {
        if (this.resources.contains(resName)) {
            oldResources.remove(resName);
            File source = new File(this.buildConfig.getOutputDir(), resName);
            if (source != null && source.exists() && source.lastModified() >= this.lastSuccessfulBuildTime) {
                this.resources.remove(resName);
            }
        }
    }

    private void deleteResourcesFromDirectory(File dir, List oldResources) {
        File[] files = FileUtil.listFiles(dir, new FileFilter(){

            public boolean accept(File f) {
                boolean accept = !f.isDirectory() && !f.getName().endsWith(".class");
                return accept;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
            this.maybeDeleteResource(filename, oldResources);
        }
    }

    private void deleteClassFile(ClassFile cf) {
        this.classesFromName.remove(cf.fullyQualifiedTypeName);
        this.weaver.deleteClassFile(cf.fullyQualifiedTypeName);
        cf.deleteFromFileSystem();
    }

    private UnwovenClassFile createUnwovenClassFile(AjBuildConfig.BinarySourceFile bsf) {
        UnwovenClassFile ucf = null;
        try {
            ucf = this.weaver.addClassFile(bsf.binSrc, bsf.fromInPathDirectory, this.buildConfig.getOutputDir());
        }
        catch (IOException ex) {
            Message msg = new Message("can't read class file " + bsf.binSrc.getPath(), new SourceLocation(bsf.binSrc, 0), false);
            this.buildManager.handler.handleMessage(msg);
        }
        return ucf;
    }

    public void noteResult(InterimCompilationResult result) {
        if (!this.maybeIncremental()) {
            return;
        }
        File sourceFile = new File(result.fileName());
        CompilationResult cr = result.result();
        if (result != null) {
            this.references.put(sourceFile, new ReferenceCollection(cr.qualifiedReferences, cr.simpleNameReferences));
        }
        UnwovenClassFile[] unwovenClassFiles = result.unwovenClassFiles();
        for (int i = 0; i < unwovenClassFiles.length; ++i) {
            File lastTimeRound = (File)this.classesFromName.get(unwovenClassFiles[i].getClassName());
            this.recordClassFile(unwovenClassFiles[i], lastTimeRound);
            this.classesFromName.put(unwovenClassFiles[i].getClassName(), new File(unwovenClassFiles[i].getFilename()));
        }
        this.recordWhetherCompilationUnitDefinedAspect(sourceFile, cr);
        this.deleteTypesThatWereInThisCompilationUnitLastTimeRoundButHaveBeenDeletedInThisIncrement(sourceFile, unwovenClassFiles);
        this.recordFQNsResultingFromCompilationUnit(sourceFile, result);
    }

    private UnwovenClassFile maybeGetExistingClassFileFor(UnwovenClassFile classFile) {
        File existing = new File(classFile.getFilename());
        if (!existing.exists()) {
            return null;
        }
        try {
            return new UnwovenClassFile(classFile.getFilename(), FileUtil.readAsByteArray(existing));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read contents of '" + classFile.getFilename() + "' " + "from last compile cycle");
        }
    }

    private void deleteTypesThatWereInThisCompilationUnitLastTimeRoundButHaveBeenDeletedInThisIncrement(File sourceFile, UnwovenClassFile[] unwovenClassFiles) {
        List classFiles = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(sourceFile);
        if (classFiles != null) {
            for (int i = 0; i < unwovenClassFiles.length; ++i) {
                this.removeFromClassFilesIfPresent(unwovenClassFiles[i].getClassName(), classFiles);
            }
            Iterator iter = classFiles.iterator();
            while (iter.hasNext()) {
                ClassFile cf = (ClassFile)iter.next();
                this.deleteClassFile(cf);
            }
        }
    }

    private void removeFromClassFilesIfPresent(String className, List classFiles) {
        ClassFile victim = null;
        Iterator iter = classFiles.iterator();
        while (iter.hasNext()) {
            ClassFile cf = (ClassFile)iter.next();
            if (!cf.fullyQualifiedTypeName.equals(className)) continue;
            victim = cf;
            break;
        }
        if (victim != null) {
            classFiles.remove(victim);
        }
    }

    private void recordFQNsResultingFromCompilationUnit(File sourceFile, InterimCompilationResult icr) {
        ArrayList<ClassFile> classFiles = new ArrayList<ClassFile>();
        UnwovenClassFile[] types = icr.unwovenClassFiles();
        for (int i = 0; i < types.length; ++i) {
            classFiles.add(new ClassFile(types[i].getClassName(), new File(types[i].getFilename())));
        }
        this.fullyQualifiedTypeNamesResultingFromCompilationUnit.put(sourceFile, classFiles);
    }

    private void recordWhetherCompilationUnitDefinedAspect(File sourceFile, CompilationResult cr) {
        Map compiledTypes;
        this.sourceFilesDefiningAspects.remove(sourceFile);
        if (cr != null && (compiledTypes = cr.compiledTypes) != null) {
            Iterator iterator = compiledTypes.keySet().iterator();
            while (iterator.hasNext()) {
                char[] className = (char[])iterator.next();
                String typeName = new String(className).replace('/', '.');
                if (typeName.indexOf("$ajc") != -1) continue;
                ResolvedType rt = this.world.resolve(typeName);
                if (rt.isMissing()) {
                    throw new IllegalStateException("Type '" + rt.getSignature() + "' not found in world!");
                }
                if (!rt.isAspect()) continue;
                this.sourceFilesDefiningAspects.add(sourceFile);
                break;
            }
        }
    }

    private UnwovenClassFile removeFromPreviousIfPresent(UnwovenClassFile cf, InterimCompilationResult previous) {
        if (previous == null) {
            return null;
        }
        UnwovenClassFile[] unwovenClassFiles = previous.unwovenClassFiles();
        for (int i = 0; i < unwovenClassFiles.length; ++i) {
            UnwovenClassFile candidate = unwovenClassFiles[i];
            if (candidate == null || !candidate.getFilename().equals(cf.getFilename())) continue;
            unwovenClassFiles[i] = null;
            return candidate;
        }
        return null;
    }

    private void recordClassFile(UnwovenClassFile thisTime, File lastTime) {
        if (this.simpleStrings == null) {
            ResolvedType rType = this.world.resolve(thisTime.getClassName());
            if (!rType.isMissing()) {
                try {
                    ClassFileReader reader = new ClassFileReader(thisTime.getBytes(), null);
                    this.resolvedTypeStructuresFromLastBuild.put(thisTime.getClassName(), new CompactTypeStructureRepresentation(reader));
                }
                catch (ClassFormatException cfe) {
                    throw new BCException("Unexpected problem processing class", cfe);
                }
            }
            return;
        }
        CompactTypeStructureRepresentation existingStructure = (CompactTypeStructureRepresentation)this.resolvedTypeStructuresFromLastBuild.get(thisTime.getClassName());
        ResolvedType newResolvedType = this.world.resolve(thisTime.getClassName());
        if (!newResolvedType.isMissing()) {
            try {
                ClassFileReader reader = new ClassFileReader(thisTime.getBytes(), null);
                this.resolvedTypeStructuresFromLastBuild.put(thisTime.getClassName(), new CompactTypeStructureRepresentation(reader));
            }
            catch (ClassFormatException cfe) {
                throw new BCException("Unexpected problem processing class", cfe);
            }
        }
        if (lastTime == null) {
            this.addDependentsOf(thisTime.getClassName());
            return;
        }
        if (newResolvedType.isMissing()) {
            return;
        }
        this.world.ensureAdvancedConfigurationProcessed();
        byte[] newBytes = thisTime.getBytes();
        try {
            ClassFileReader reader = new ClassFileReader(newBytes, lastTime.getAbsolutePath().toCharArray());
            if (!reader.isLocal() && !reader.isAnonymous() && this.hasStructuralChanges(reader, existingStructure)) {
                if (this.world.forDEBUG_structuralChangesCode) {
                    System.err.println("Detected a structural change in " + thisTime.getFilename());
                }
                this.structuralChangesSinceLastFullBuild.put(thisTime.getFilename(), new Long(this.currentBuildTime));
                this.addDependentsOf(new String(reader.getName()).replace('/', '.'));
            }
        }
        catch (ClassFormatException e) {
            this.addDependentsOf(thisTime.getClassName());
        }
    }

    private boolean hasStructuralChanges(ClassFileReader reader, CompactTypeStructureRepresentation existingType) {
        IBinaryMethod[] existingMs;
        IBinaryField[] existingFs;
        if (existingType == null) {
            return true;
        }
        if (!this.modifiersEqual(reader.getModifiers(), existingType.modifiers)) {
            return true;
        }
        if (!CharOperation.equals(reader.getGenericSignature(), existingType.genericSignature)) {
            return true;
        }
        if (!CharOperation.equals(reader.getSuperclassName(), existingType.superclassName)) {
            return true;
        }
        char[][] existingIfs = existingType.interfaces;
        char[][] newIfsAsChars = reader.getInterfaceNames();
        if (newIfsAsChars == null) {
            newIfsAsChars = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs == null) {
            existingIfs = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs.length != newIfsAsChars.length) {
            return true;
        }
        block0: for (int i = 0; i < newIfsAsChars.length; ++i) {
            for (int j = 0; j < existingIfs.length; ++j) {
                if (CharOperation.equals(existingIfs[j], newIfsAsChars[i])) continue block0;
            }
            return true;
        }
        IBinaryField[] newFields = reader.getFields();
        if (newFields == null) {
            newFields = CompactTypeStructureRepresentation.NoField;
        }
        if (newFields.length != (existingFs = existingType.binFields).length) {
            return true;
        }
        block2: for (int i = 0; i < newFields.length; ++i) {
            IBinaryField field = newFields[i];
            char[] fieldName = field.getName();
            for (int j = 0; j < existingFs.length; ++j) {
                if (!CharOperation.equals(existingFs[j].getName(), fieldName)) continue;
                if (!this.modifiersEqual(field.getModifiers(), existingFs[j].getModifiers())) {
                    return true;
                }
                if (CharOperation.equals(existingFs[j].getTypeName(), field.getTypeName())) continue block2;
                return true;
            }
            return true;
        }
        IBinaryMethod[] newMethods = reader.getMethods();
        if (newMethods == null) {
            newMethods = CompactTypeStructureRepresentation.NoMethod;
        }
        if (newMethods.length != (existingMs = existingType.binMethods).length) {
            return true;
        }
        block4: for (int i = 0; i < newMethods.length; ++i) {
            IBinaryMethod method = newMethods[i];
            char[] methodName = method.getSelector();
            for (int j = 0; j < existingMs.length; ++j) {
                if (!CharOperation.equals(existingMs[j].getSelector(), methodName) || !CharOperation.equals(method.getMethodDescriptor(), existingMs[j].getMethodDescriptor())) continue;
                if (this.modifiersEqual(method.getModifiers(), existingMs[j].getModifiers())) continue block4;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean modifiersEqual(int eclipseModifiers, int resolvedTypeModifiers) {
        return (eclipseModifiers &= 0xFFFF) == (resolvedTypeModifiers &= 0xFFFF);
    }

    private static StringSet makeStringSet(List strings) {
        StringSet ret = new StringSet(strings.size());
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            ret.add(element);
        }
        return ret;
    }

    private String stringifyList(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Object el = iter.next();
            sb.append(el);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    protected void addAffectedSourceFiles(List addTo, List lastTimeSources) {
        char[][] simpleNames;
        char[][][] qualifiedNames;
        if (this.qualifiedStrings.isEmpty() && this.simpleStrings.isEmpty()) {
            return;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision("Examining whether any other files now need compilation based just compiling: '" + this.stringifyList(lastTimeSources) + "'");
        }
        if ((qualifiedNames = ReferenceCollection.internQualifiedNames(AjState.makeStringSet(this.qualifiedStrings))).length < this.qualifiedStrings.size()) {
            qualifiedNames = null;
        }
        if ((simpleNames = ReferenceCollection.internSimpleNames(AjState.makeStringSet(this.simpleStrings))).length < this.simpleStrings.size()) {
            simpleNames = null;
        }
        Iterator i = this.references.entrySet().iterator();
        while (i.hasNext()) {
            File file;
            Map.Entry entry = i.next();
            ReferenceCollection refs = (ReferenceCollection)entry.getValue();
            if (refs == null || !refs.includes(qualifiedNames, simpleNames) || !(file = (File)entry.getKey()).exists() || lastTimeSources.contains(file)) continue;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Need to recompile '" + file.getName().toString() + "'");
            }
            addTo.add(file);
        }
        if (addTo.size() > 0) {
            Iterator iter = lastTimeSources.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (addTo.contains(element)) continue;
                addTo.add(element);
            }
        }
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
    }

    protected void addDependentsOf(String qualifiedTypeName) {
        String typeName;
        int lastDot = qualifiedTypeName.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = qualifiedTypeName.substring(0, lastDot).replace('.', '/');
            if (!this.qualifiedStrings.contains(packageName)) {
                this.qualifiedStrings.add(packageName);
            }
            typeName = qualifiedTypeName.substring(lastDot + 1);
        } else {
            this.qualifiedStrings.add("");
            typeName = qualifiedTypeName;
        }
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (!this.simpleStrings.contains(typeName)) {
            this.simpleStrings.add(typeName);
        }
    }

    protected void addDependentsOf(File sourceFile) {
        List cfs = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(sourceFile);
        if (cfs != null) {
            Iterator iter = cfs.iterator();
            while (iter.hasNext()) {
                ClassFile cf = (ClassFile)iter.next();
                this.addDependentsOf(cf.fullyQualifiedTypeName);
            }
        }
    }

    public void setStructureModel(IHierarchy model) {
        this.structureModel = model;
    }

    public IHierarchy getStructureModel() {
        return this.structureModel;
    }

    public void setWeaver(BcelWeaver bw) {
        this.weaver = bw;
    }

    public BcelWeaver getWeaver() {
        return this.weaver;
    }

    public void setWorld(BcelWorld bw) {
        this.world = bw;
    }

    public BcelWorld getBcelWorld() {
        return this.world;
    }

    public void setRelationshipMap(IRelationshipMap irm) {
        this.relmap = irm;
    }

    public IRelationshipMap getRelationshipMap() {
        return this.relmap;
    }

    public int getNumberOfStructuralChangesSinceLastFullBuild() {
        return this.structuralChangesSinceLastFullBuild.size();
    }

    public long getLastBuildTime() {
        return this.lastSuccessfulBuildTime;
    }

    public long getLastFullBuildTime() {
        return this.lastSuccessfulFullBuildTime;
    }

    public AjBuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public void clearBinarySourceFiles() {
        this.binarySourceFiles = new HashMap();
    }

    public void recordBinarySource(String fromPathName, List unwovenClassFiles) {
        this.binarySourceFiles.put(fromPathName, unwovenClassFiles);
        if (this.maybeIncremental()) {
            LinkedList<ClassFile> simpleClassFiles = new LinkedList<ClassFile>();
            Iterator iter = unwovenClassFiles.iterator();
            while (iter.hasNext()) {
                UnwovenClassFile ucf = (UnwovenClassFile)iter.next();
                ClassFile cf = this.getClassFileFor(ucf);
                simpleClassFiles.add(cf);
            }
            this.inputClassFilesBySource.put(fromPathName, simpleClassFiles);
        }
    }

    private ClassFile getClassFileFor(UnwovenClassFile ucf) {
        return new ClassFile(ucf.getClassName(), new File(ucf.getFilename()));
    }

    public Map getBinarySourceMap() {
        return this.binarySourceFiles;
    }

    public Map getClassNameToFileMap() {
        return this.classesFromName;
    }

    public boolean hasResource(String resourceName) {
        return this.resources.contains(resourceName);
    }

    public void recordResource(String resourceName) {
        this.resources.add(resourceName);
    }

    public Set getAddedFiles() {
        return this.addedFiles;
    }

    public Set getDeletedFiles() {
        return this.deletedFiles;
    }

    public void forceBatchBuildNextTimeAround() {
        this.batchBuildRequiredThisTime = true;
    }

    public boolean requiresFullBatchBuild() {
        return this.batchBuildRequiredThisTime;
    }

    public void wipeAllKnowledge() {
        this.buildManager.state = null;
        this.buildManager.setStructureModel(null);
    }

    public List getAspectNames() {
        return this.aspectNames;
    }

    public void initializeAspectNamesList() {
        this.aspectNames = new LinkedList();
    }

    public boolean listenerDefined() {
        return stateListener != null;
    }

    public IStateListener getListener() {
        return stateListener;
    }

    public IBinaryType checkPreviousBuild(String name) {
        return (IBinaryType)this.resolvedTypeStructuresFromLastBuild.get(name);
    }

    private static class ClassFile {
        public String fullyQualifiedTypeName;
        public File locationOnDisk;

        public ClassFile(String fqn, File location) {
            this.fullyQualifiedTypeName = fqn;
            this.locationOnDisk = location;
        }

        public void deleteFromFileSystem() {
            File[] weaverGenerated;
            String namePrefix = this.locationOnDisk.getName();
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf(46));
            final String targetPrefix = namePrefix + "$Ajc";
            File dir = this.locationOnDisk.getParentFile();
            if (dir != null && (weaverGenerated = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(targetPrefix);
                }
            })) != null) {
                for (int i = 0; i < weaverGenerated.length; ++i) {
                    weaverGenerated[i].delete();
                }
            }
            this.locationOnDisk.delete();
        }
    }
}

